<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $th_job_position
 * @var $th_text_department
 * @var $th_date
 * @var $values
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Job_Position
 */

$th_job_position = $th_text_department = $th_date = $values = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);
$wrapper_classes = array(
	'gf-job-position',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);
$th_titles = array($th_job_position, $th_text_department, $th_date);
$values = (array)vc_param_group_parse_atts($values);


if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-banner'), G5P()->helper()->getAssetUrl('shortcodes/job-position/assets/css/job-position.min.css'), array(), G5P()->pluginVer());
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<?php if (!empty($th_job_position) && !empty($th_text_department) && !empty($th_date)): ?>
	<table class="<?php echo esc_attr($css_class) ?>">
		<tr class="gf-jp-title">
			<?php foreach ($th_titles as $th_title): ?>
				<th><?php echo esc_attr($th_title) ?></th>
			<?php endforeach; ?>
		</tr>
		<?php if (count($values) > 0): ?>
			<?php foreach ($values as $value):
				$job_position = isset($value['job_position']) ? $value['job_position'] : '';
				$text_department = isset($value['text_department']) ? $value['text_department'] : '';
				$time = isset($value['time']) ? $value['time'] : '';
				if(!empty($time)){
					$time = mysql2date(get_option('date_format'), $time);
				}
				?>
				<tr class="gf-jp-content-row">
					<td data-title="job_position"><?php echo esc_attr($job_position) ?></td>
					<td data-title="text_department"><?php echo esc_attr($text_department) ?></td>
					<td data-title="time"><?php echo esc_attr($time) ?></td>
				</tr>
			<?php endforeach; ?>
		<?php endif; ?>
	</table>
<?php endif; ?>