<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $box_shadow_hover
 * @var $layout_style
 * @var $icon_size
 * @var $el_class
 * @var $has_line
 * @var $link
 * @var $animation_duration
 * @var $animation_delay
 * @var $css_animation
 * @var $css
 * @var $icon_type
 * @var $icon_image
 * @var $icon_font
 * @var $icon_align
 * @var $title
 * @var $description
 * Shortcode class
 * @var $this WPBakeryShortCode_G5Plus_Icon_Box
 */
$box_shadow_hover = $layout_style = $icon_size = $el_class = $link = $animation_delay = $animation_duration = $css_animation = $css =$icon_font = $icon_align = $title = $description = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

if ('true' == $box_shadow_hover) {
	$has_box_shadow = 'box_shadow_hover';
} else {
	$has_box_shadow = '';
}

$wrapper_classes = array(
	'g5f-icon-box',
	$icon_align,
	$layout_style,
	$icon_size,
	$has_box_shadow,
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);

// animation
if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

//parse link
$a_href = $a_title = $a_target = $a_rel = '';
$link = ('||' === $link) ? '' : $link;
$link = vc_build_link($link);
$use_link = false;
if (strlen($link['url']) > 0) {
	$use_link = true;
	$a_href = $link['url'];
	$a_title = $link['title'];
	$a_target = $link['target'];
	$a_rel = $link['rel'];
}

// File min
if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-icon-box'), G5P()->helper()->getAssetUrl('shortcodes/icon-box/assets/css/icon-box.min.css'), array(), G5P()->pluginVer());
}

// wrapper class
$wrapper_class = implode(' ', array_filter($wrapper_classes));


?>

<div class="<?php echo esc_attr($wrapper_class) ?>">
	<div class="ib-shape">
		<?php if (!empty($icon_font)): ?>
			<div class="icon">
				<i class="<?php echo esc_attr($icon_font) ?>"></i>
			</div>
		<?php endif; ?>
	</div>
	<?php if (($icon_align == 'align-left') || ($icon_align == 'align-center')): ?>
		<div class="ib-content">
			<?php if (!empty($title)): ?>
				<h4 class="heading-color letter-spacing-03 fw-normal">
					<?php if ($use_link): ?>
						<a href="<?php echo esc_url(trim($a_href)) ?>"><?php echo esc_html($title) ?></a>
					<?php else: ?>
						<?php echo esc_html($title) ?>
					<?php endif; ?>
				</h4>
			<?php endif;
			if (!empty($description)): ?>
				<p class="letter-spacing-03"><?php echo esc_html($description) ?></p>
			<?php endif; ?>
		</div>
	<?php else:
		if (!empty($title)): ?>
			<h4 class="heading-color letter-spacing-03 fw-normal">
				<?php if ($use_link): ?>
					<a href="<?php echo esc_url(trim($a_href)) ?>"><?php echo esc_html($title) ?></a>
				<?php else: ?>
					<?php echo esc_html($title) ?>
				<?php endif; ?>
			</h4>
		<?php endif;
		if (!empty($description)): ?>
			<p class="letter-spacing-03"><?php echo esc_html($description) ?></p>
		<?php endif;
	endif; ?>
</div>
