<?php
return array(
	'base' => 'gsf_icon_box',
	'name' => esc_html__( 'Icon Box', 'ruby-build-framework' ),
	'icon' => 'fa fa-diamond',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		G5P()->shortcode()->vc_map_add_icon_font(),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__('Title', 'ruby-build-framework'),
			'param_name'  => 'title',
			'value'       => '',
		),
		//description
		array(
			'type'        => 'textarea',
			'heading'     => esc_html__('Description', 'ruby-build-framework'),
			'param_name'  => 'description',
			'value'       => '',
			'description' => esc_html__('Provide the description for this element.', 'ruby-build-framework'),
		),
		array(
			'type'        => 'checkbox',
			'heading'     => esc_html__('Set box shadow when hover ?', 'ruby-build-framework'),
			'param_name'  => 'box_shadow_hover',
			'std'         => 'false',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		// vc link
		array(
			'type'       => 'vc_link',
			'heading'    => esc_html__('Link (url)', 'ruby-build-framework'),
			'param_name' => 'link',
			'value'      => '',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		//Layout style
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__('Layout Style', 'ruby-build-framework'),
			'param_name'       => 'layout_style',
			'value'            => array(
				esc_html__('None', 'ruby-build-framework')        => 'transparent',
				esc_html__('Background', 'ruby-build-framework')     => 'background',
				esc_html__('Outline', 'ruby-build-framework') => 'outline',
			),
			'admin_label'      => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'std'              => 'background',
		),
		//icon size
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__('Icon Size', 'ruby-build-framework'),
			'param_name'       => 'icon_size',
			'value'            => array(
				esc_html__('Icon Large', 'ruby-build-framework')     => 'icon-large',
				esc_html__('Icon Normal', 'ruby-build-framework')        => 'icon-normal',
				esc_html__('Icon Small', 'ruby-build-framework')     => 'icon-small',
			),
			'admin_label'      => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'std'              => 'icon-normal',
		),
		//Icon align
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__('Icon Align', 'ruby-build-framework'),
			'param_name'       => 'icon_align',
			'value'            => array(
				esc_html__('Top-Left', 'ruby-build-framework')  => 'align-top-left',
				esc_html__('Top-Center', 'ruby-build-framework') => 'align-center',
				esc_html__('Left', 'ruby-build-framework') => 'align-left',
			),
			'std'              => 'align-center',
			'admin_label'      => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);