<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $text_align
 * @var $heading_bg_color
 * @var $text_color
 * @var $border_bottom_width
 * @var $icon_shape
 * @var $icon_font
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Heading
 */

$text_align = $sub_title = $local_subtitle = $heading_size = $css_animation = $animation_duration =
$animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$wrapper_classes = array(
	'gf-heading',
	$text_align,
	'gf-heading-'.$heading_size,
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-heading'), G5P()->helper()->getAssetUrl('shortcodes/heading/assets/css/heading.min.css'), array(), G5P()->pluginVer());
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);

?>
<?php if(!empty( $content )||(!empty($sub_title))): ?>
<div class="<?php echo esc_attr($css_class) ?>">
	<?php if('subtitle-top' == $local_subtitle):?>
		<p class="heading_subtitle accent-color heading-top"><?php echo esc_attr($sub_title)?></p>
		<h5 class="heading_title" ><?php echo wp_kses_post($content)?></h5>
	<?php else:?>
		<h5 class="heading_title heading-top"><?php echo wp_kses_post($content)?></h5>
		<p class="heading_subtitle accent-color"><?php echo esc_attr($sub_title)?></p>
	<?php endif;?>
	
</div>
<?php endif; ?>