<?php
return array(
	'base' => 'gsf_heading',
	'name' => esc_html__( 'Heading', 'ruby-build-framework' ),
	'icon' => 'fa fa-header',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		array(
			'type' => 'textarea_html',
			'heading' => esc_html__( 'Text', 'ruby-build-framework' ),
			'param_name' => 'content',
			'value' => wp_kses_post('<strong class="uppercase">Why Choose</strong> Ruby<span class="accent-color">Build</span>', 'ruby-build-framework'),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Sub Title', 'ruby-build-framework' ),
			'param_name' => 'sub_title',
			'value' => esc_html__('Building And Civil Construction', 'ruby-build-framework'),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Location Of Sub Title', 'ruby-build-framework'),
			'param_name' => 'local_subtitle',
			'description' => esc_html__('Select location of subtitle.', 'ruby-build-framework'),
			'value' => array(
				esc_html__('Top', 'ruby-build-framework') => 'subtitle-top',
				esc_html__('Bottom', 'ruby-build-framework') => 'subtitle-bottom',
			),
			'std' => 'subtitle-top',
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Text Alignment', 'ruby-build-framework'),
			'param_name' => 'text_align',
			'description' => esc_html__('Select text alignment.', 'ruby-build-framework'),
			'value' => array(
				esc_html__('Left', 'ruby-build-framework') => 'text-left',
				esc_html__('Center', 'ruby-build-framework') => 'text-center',
				esc_html__('Right', 'ruby-build-framework') => 'text-right'
			),
			'std' => 'text-left',
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Heading size', 'ruby-build-framework'),
			'param_name' => 'heading_size',
			'description' => esc_html__('Select heading size.', 'ruby-build-framework'),
			'value' => array(
				esc_html__('normal', 'ruby-build-framework') => 'normal',
				esc_html__('large', 'ruby-build-framework') => 'large',
			),
			'std' => 'normal',
			'admin_label' => true,
		),
		//G5P()->shortcode()->vc_map_add_heading_bg_color(),
		//G5P()->shortcode()->vc_map_add_heading_text_color(),
		//G5P()->shortcode()->vc_map_add_heading_border_bottom_width(),
		/*G5P()->shortcode()->vc_map_add_icon_font(array(
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		)),*/
		//G5P()->shortcode()->vc_map_add_icon_shape(array('dependency' => array( 'element' => 'icon_font', 'value_not_equal_to' => array('')))),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);