<?php
return array(
    'name'     => esc_html__('Google Map', 'ruby-build-framework'),
    'base'     => 'gsf_google_map',
    'icon'     => 'fa fa-map-marker',
    'category' => G5P()->shortcode()->get_category_name(),
    'params'   => array(
        array(
            'type'       => 'param_group',
            'heading'    => esc_html__('Markers', 'ruby-build-framework'),
            'param_name' => 'markers',
            'value'      => urlencode(json_encode(array(
                array(
                    'label' => esc_html__('Title', 'ruby-build-framework'),
                    'value' => '',
                ),
            ))),
            'params'     => array(
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__('Latitude ', 'ruby-build-framework'),
                    'param_name'  => 'lat',
                    'admin_label' => true,
                    'value'       => '',
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__('Longitude ', 'ruby-build-framework'),
                    'param_name'  => 'lng',
                    'admin_label' => true,
                    'value'       => '',
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__('Title', 'ruby-build-framework'),
                    'param_name'  => 'title',
                    'admin_label' => true,
                    'value'       => '',
                ),
                array(
                    'type'       => 'textarea',
                    'heading'    => esc_html__('Description', 'ruby-build-framework'),
                    'param_name' => 'description',
                    'value'      => ''
                ),
                array(
                    'type'        => 'attach_image',
                    'heading'     => esc_html__('Marker Icon', 'ruby-build-framework'),
                    'param_name'  => 'image',
                    'value'       => '',
                    'description' => esc_html__('Select an image from media library.', 'ruby-build-framework'),
                ),
            ),
        ),
        array(
            'type'       => 'textfield',
            'heading'    => esc_html__('API Key', 'ruby-build-framework'),
            'param_name' => 'api_key',
            'std'        => 'AIzaSyAwey_47Cen4qJOjwHQ_sK1igwKPd74J18',
        ),
        array(
            'type'             => 'textfield',
            'heading'          => esc_html__('Map height (px or %)', 'ruby-build-framework'),
            'param_name'       => 'map_height',
            'edit_field_class' => 'vc_col-sm-6',
            'std'              => '500px',
        ),
        array(
            'type'             => 'gsf_number',
            'heading'          => esc_html__('Map zoom level default', 'ruby-build-framework'),
            'param_name'       => 'map_zoom',
            'edit_field_class' => 'vc_col-sm-6',
            'std'              => 15,
            'min'              => 0,
            'max'              => 18,
            'step'             => 1
        ),
        array(
            'type'             => 'gsf_switch',
            'heading'          => esc_html__('Zoom on scroll', 'ruby-build-framework'),
            'param_name'       => 'scroll_wheel',
            'edit_field_class' => 'vc_col-sm-6',
            'std'              => false
        ),
        array(
            'type'             => 'dropdown',
            'heading'          => esc_html__('Map Style', 'ruby-build-framework'),
            'param_name'       => 'map_style',
            'std'            => 'light',
            'value'         => array(
                esc_html__('Standar', 'ruby-build-framework') => 'standar',
                esc_html__('Light (Default)', 'ruby-build-framework') => 'light',
                esc_html__('Dark', 'ruby-build-framework') => 'dark',
                esc_html__('Sliver', 'ruby-build-framework') => 'sliver',
                esc_html__('Retro', 'ruby-build-framework') => 'retro',
                esc_html__('Night', 'ruby-build-framework') => 'night',
                esc_html__('Aubergine', 'ruby-build-framework') => 'aubergine',
                esc_html__('Custom', 'ruby-build-framework') => 'custom'
            ),
            'admin_label'      => true,
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type'             => 'textarea_raw_html',
            'heading'          => esc_html__('Custom map style', 'ruby-build-framework'),
            'param_name'       => 'map_style_content',
            'dependency' => array('element' => 'map_style', 'value' => 'custom'),
            'description' => wp_kses_post(__('Come <a target="_blank" href="https://snazzymaps.com/">here</a> to search map style code!', 'ruby-build-framework'))
        ),
        G5P()->shortcode()->vc_map_add_css_animation(),
        G5P()->shortcode()->vc_map_add_animation_duration(),
        G5P()->shortcode()->vc_map_add_animation_delay(),
        G5P()->shortcode()->vc_map_add_extra_class(),
        G5P()->shortcode()->vc_map_add_css_editor(),
        G5P()->shortcode()->vc_map_add_responsive()
    ),
);