<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var text_align
 * @var el_class
 * @var css_animation
 * @var animation_duration
 * @var animation_delay
 * @var css
 * @var image
 * @var link
 * @var title
 * @var content
 * @var $layout_outline
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Feature_Box
 */
$text_align = $el_class = $css_animation = $layout_outline = $animation_duration = $animation_delay = $css = $image = $link = $title = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

if ('true' == $layout_outline) {
	$layout_outline_class = 'layout_outline';
} else {
	$layout_outline_class = '';
}

$wrapper_classes = array(
	'g5plus-feature-box',
	'clearfix',
	$text_align,
	$layout_outline_class,
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);
// pare link
$a_href = $a_title = $a_target = $a_rel = '';
//parse link
$link = ('||' === $link) ? '' : $link;
$link = vc_build_link($link);
$use_link = false;
if (strlen($link['url']) > 0) {
	$use_link = true;
	$a_href = $link['url'];
	$a_title = $link['title'];
	$a_target = $link['target'];
	$a_rel = $link['rel'];
}

// get image
$feature_img = isset($image) ? $image : '';
$image_src = '';
if (function_exists('g5plusRubyBuild')) {
    $image_src = g5plusRubyBuild()->image_resize()->resize(array(
        'image_id' => $feature_img,
        'width'    => 370,
        'height'   => 241
    ));
    if (sizeof($image_src) > 0 && !empty($image_src)) {
        $image_src = $image_src['url'];
    }
}
$feature_bg_css = '';
$feature_class = 'gf-feature-box' . random_int(1000, 9999);
$feature_bg_css = <<<CSS
			.{$feature_class} {
				background-image: url('{$image_src}');
				padding-bottom: 65.135%;
				background-size: cover;
			}
CSS;
GSF()->customCss()->addCss($feature_bg_css);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-feature-box'), G5P()->helper()->getAssetUrl('shortcodes/feature-box/assets/css/feature-box.min.css'), array(), G5P()->pluginVer());
}
?>

<div class="<?php echo esc_attr($css_class) ?>">
	<div class="g5plus-feature-box-content-wrap fs-14">
		<div class="feature-image absolute-skew ">
			<?php if ($use_link): ?>
				<a title="<?php echo esc_attr($a_title); ?>" <?php echo empty($a_target) ? '' : 'target="' . trim(esc_attr($a_target)) . '"' ?>
				   href="<?php echo esc_url(trim($a_href)) ?>"
				   class="entry-thumbnail-overlay <?php echo esc_attr($feature_class) ?>"></a>
			<?php else: ?>
				<div class="entry-thumbnail-overlay  <?php echo esc_attr($feature_class) ?>"></div>
			<?php endif; ?>
		</div>
		<div class="g5plus-feature-box-content">
			<?php if (!empty($title)): ?>
				<h4 class="content-title fs-17">
					<a title="<?php echo esc_attr($a_title); ?>" <?php echo empty($a_target) ? '' : 'target="' . trim(esc_attr($a_target)) . '"' ?>
					   href="<?php echo esc_url(trim($a_href)) ?>">
						<?php echo esc_html($title); ?>
					</a>
				</h4>
			<?php endif; ?>
			<?php if (!empty($content)): ?>
				<p class="feature-description"><?php echo wp_kses_post($content); ?></p>
			<?php endif; ?>
			<a title="<?php echo esc_attr($a_title); ?>" <?php echo empty($a_target) ? '' : 'target="' . trim(esc_attr($a_target)) . '"' ?>
			   href="<?php echo esc_url(trim($a_href)) ?>" class="btn-read-more accent-color heading_font">
				<?php esc_html_e('Read more', 'ruby-build-framework') ?>
				<i class="fa fa-long-arrow-right"></i>
			</a>
		</div>
	</div>
</div>
