<?php
return array(
	'base' => 'gsf_feature_box',
	'name' => esc_html__( 'Feature Box', 'ruby-build-framework' ),
	'icon' => 'fa fa-th-list',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		G5P()->shortcode()->vc_map_add_title(array('admin_label' => true)),
		array(
			'type'        => 'attach_image',
			'heading'     => esc_html__('Images', 'ruby-build-framework'),
			'param_name'  => 'image',
			'value'       => '',
			'description' => esc_html__('Select images from media library.', 'ruby-build-framework')
		),
		//Layout outline
		array(
			'type' => 'checkbox',
			'heading' => esc_html__('Layout Outline?', 'ruby-build-framework' ),
			'param_name' => 'layout_outline',
			'description' => esc_html__('Add border for layout?', 'ruby-build-framework'),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textarea_html',
			'heading' => esc_html__( 'Text', 'ruby-build-framework' ),
			'param_name' => 'content'
		),
		//Text align
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Text Align', 'ruby-build-framework'),
			'param_name' => 'text_align',
			'value' => array(
				esc_html__('Alignment center','ruby-build-framework') => 'text-center',
				esc_html__('Alignment Left','ruby-build-framework') => 'text-left',
				esc_html__('Alignment Right','ruby-build-framework') => 'text-right',
			),
			'std' => 'text-center',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'admin_label' => true,
		),
		array(
			'type' => 'vc_link',
			'heading' => esc_html__('Link (url)', 'ruby-build-framework'),
			'param_name' => 'link',
			'value' => '',
		),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);