<?php
return array(
	'base' => 'gsf_counter',
	'name' => esc_html__( 'Counter', 'ruby-build-framework' ),
	'icon' => 'fa fa-tachometer',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		G5P()->shortcode()->vc_map_add_title(array('admin_label' => true)),
		G5P()->shortcode()->vc_map_add_icon_font(),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Start Value', 'ruby-build-framework'),
			'param_name'       => 'start',
			'value'            => '',
			'std'              => '0',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('End Value', 'ruby-build-framework'),
			'param_name'       => 'end',
			'value'            => '',
			'std'              => '1000',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Decimals', 'ruby-build-framework'),
			'param_name'       => 'decimals',
			'value'            => '',
			'std'              => '0',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Duration (s)', 'ruby-build-framework'),
			'param_name'       => 'duration',
			'value'            => '',
			'std'              => '2,5',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Separator', 'ruby-build-framework'),
			'param_name'       => 'separator',
			'value'            => '',
			'std'              => ',',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Decimal', 'ruby-build-framework'),
			'param_name'       => 'decimal',
			'value'            => '',
			'std'              => '.',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Prefix', 'ruby-build-framework'),
			'param_name'       => 'prefix',
			'value'            => '',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__('Suffix', 'ruby-build-framework'),
			'param_name'       => 'suffix',
			'value'            => '',
			'edit_field_class' => 'vc_col-sm-6 vc_column'
		),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);