<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $description
 * @var $image
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Job_Position
 */

$title = $description = $image = $values = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$wrapper_classes = array(
	'gf-certificates',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);

$image_src = wp_get_attachment_image_src($image, 'full');
if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-banner'), G5P()->helper()->getAssetUrl('shortcodes/certificates/assets/css/certificates.min.css'), array(), G5P()->pluginVer());
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<?php if (!empty($image_src[0])) : ?>
		<div class="certificates-image">
			<img src="<?php echo esc_url($image_src[0]) ?>" alt="<?php echo esc_attr($title) ?>"/>
		</div>
	<?php endif; ?>
	<div class="certificates-content">
		<?php if (!empty($title)): ?>
			<h4 class="fs-16 fw-normal mg-top-0 mg-bottom-0"><?php echo esc_attr($title) ?></h4>
		<?php endif;
		if (!empty($description)):?>
			<span class="fs-13 accent-color"><?php echo esc_attr($description) ?></span>
		<?php endif; ?>
	
	</div>

</div>