<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $css
 * @var $title
 * @var $link
 * @var $style
 * @var $shape
 * @var $color
 * @var $size
 * @var $align
 * @var $button_block
 * @var $icon_align
 * @var $custom_onclick
 * @var $custom_onclick_code
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Call_To_Action
 */
$el_class = $css_animation = $animation_duration =$animation_delay = $css =$title=$link=$style=$shape=$color=$size=$align=$button_block=$icon_align=$custom_onclick=$custom_onclick_code= '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract($atts);

$wrapper_attributes = array();
$wrapper_styles= array();

$wrapper_classes = array(
	'gf-call-to-action',
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$class_to_filter .= vc_shortcode_custom_css_class($css, ' ');
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-call-to-action'), G5P()->helper()->getAssetUrl('shortcodes/call-to-action/assets/css/call-to-action.min.css'), array(), G5P()->pluginVer());
}

?>
<div class="<?php echo esc_attr($css_class) ?>" <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php if( !empty($content) ) :?>
	<div class="cta-content">
		<?php echo wpb_js_remove_wpautop( $content, true );?>
	</div>
	<?php endif;
	if( !empty($title) ) :?>
	<div class="cta-action">
		<?php echo do_shortcode( '[gsf_button title="'.$title.
			'" link="'. $link.
			'" style="'.$style.
			'" shape="'.$shape.
			'" color="'.$color.
			'" size="'. $size.
			'" align="'.$align.
			'" button_block="'.$button_block.
			'" icon_align="'.$icon_align.
			'" custom_onclick="'.$custom_onclick.
			'" custom_onclick_code="'.$custom_onclick_code.'"]' ); ?>
	</div>
	<?php endif; ?>
</div>
