<?php
return array(
	'base' => 'gsf_call_to_action',
	'name' => esc_html__( 'Call To Action', 'ruby-build-framework' ),
	'icon' => 'fa fa-forward',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		array(
			'type' => 'textarea_html',
			'heading' => esc_html__( 'Text', 'ruby-build-framework' ),
			'param_name' => 'content'
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Text', 'ruby-build-framework'),
			'param_name' => 'title',
			'value' => esc_html__('Text on the button', 'ruby-build-framework'),
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'vc_link',
			'heading' => esc_html__('URL (Link)', 'ruby-build-framework'),
			'param_name' => 'link',
			'description' => esc_html__('Add link to button.', 'ruby-build-framework'),
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Style', 'ruby-build-framework'),
			'description' => esc_html__('Select button display style.', 'ruby-build-framework'),
			'param_name' => 'style',
			'value' => array(
				esc_html__('Classic', 'ruby-build-framework') => 'classic',
				esc_html__('Outline', 'ruby-build-framework') => 'outline',
				esc_html__('3d', 'ruby-build-framework') => '3d',
			),
			'std' => 'classic',
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Shape', 'ruby-build-framework'),
			'description' => esc_html__('Select button shape.', 'ruby-build-framework'),
			'param_name' => 'shape',
			'value' => array(
				esc_html__('Rounded', 'ruby-build-framework') => 'rounded',
				esc_html__('Square', 'ruby-build-framework') => 'square',
				esc_html__('Round', 'ruby-build-framework') => 'round',
			),
			'std' => 'rounded',
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Color', 'ruby-build-framework'),
			'param_name' => 'color',
			'description' => esc_html__('Select button color.', 'ruby-build-framework'),
			'value' => array(
				esc_html__('Primary', 'ruby-build-framework') => 'primary',
				esc_html__('Gray', 'ruby-build-framework') => 'gray',
				esc_html__('Black', 'ruby-build-framework') => 'black',
				esc_html__('White', 'ruby-build-framework') => 'white',
			),
			'std' => 'primary',
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Size', 'ruby-build-framework'),
			'param_name' => 'size',
			'description' => esc_html__('Select button display size.', 'ruby-build-framework'),
			'std' => 'sm',
			'value' => array(
				esc_html__('Mini', 'ruby-build-framework') => 'xs', // height 40px
				esc_html__('Small', 'ruby-build-framework') => 'sm', // height 44px - default
				esc_html__('Normal', 'ruby-build-framework') => 'md', // height 49px
				esc_html__('Large', 'ruby-build-framework') => 'lg', // height 52px
				esc_html__('Extra Large', 'ruby-build-framework') => 'xl', // height 56px
			),
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__('Alignment', 'ruby-build-framework'),
			'param_name' => 'align',
			'description' => esc_html__('Select button alignment.', 'ruby-build-framework'),
			'value' => array(
				esc_html__('Inline', 'ruby-build-framework') => 'inline',
				esc_html__('Left', 'ruby-build-framework') => 'left',
				esc_html__('Right', 'ruby-build-framework') => 'right',
				esc_html__('Center', 'ruby-build-framework') => 'center',
			),
			'std' => 'inline',
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'gsf_switch',
			'heading' => esc_html__('Set full width button?', 'ruby-build-framework'),
			'param_name' => 'button_block',
			'std' => '',
			'dependency' => array(
				'element' => 'align',
				'value_not_equal_to' => 'inline',
			),
			'admin_label' => true,
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array_merge(G5P()->shortcode()->vc_map_add_icon_font(),
			array(
				'group' => esc_html__('Button Options', 'ruby-build-framework')
			)
		),
		array(
			'type' => 'gsf_button_set',
			'heading' => esc_html__('Icon Alignment', 'ruby-build-framework'),
			'description' => esc_html__('Select icon alignment.', 'ruby-build-framework'),
			'param_name' => 'icon_align',
			'value' => array(
				esc_html__('Left', 'ruby-build-framework') => 'left',
				esc_html__('Right', 'ruby-build-framework') => 'right',
			),
			'dependency' => array(
				'element' => 'icon_font',
				'value_not_equal_to' => array(''),
			),
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'gsf_switch',
			'heading' => esc_html__('Advanced on click action', 'ruby-build-framework'),
			'param_name' => 'custom_onclick',
			'std' => '',
			'description' => esc_html__('Insert inline onclick javascript action.', 'ruby-build-framework'),
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('On click code', 'ruby-build-framework'),
			'param_name' => 'custom_onclick_code',
			'description' => esc_html__('Enter onclick action code.', 'ruby-build-framework'),
			'dependency' => array(
				'element' => 'custom_onclick',
				'value' => 'on',
			),
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);