<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $hover_effect
 * @var $image
 * @var $banner_bg_overlay_color
 * @var $bg_overlay_first
 * @var $link
 * @var $height_mode
 * @var $height
 * @var $title_color
 * @var $title_bottom_line_color
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_G5P_Banner
 */

$title = $hover_effect = $image = $banner_bg_overlay_color = $bg_overlay_first = $link = $height_mode = $height =
$title_color = $title_bottom_line_color = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$image_src = '';
$image_arr = wp_get_attachment_image_src( $image, 'full' );
if ( sizeof( $image_arr ) > 0 && ! empty( $image_arr[0] ) ) {
    $image_src = $image_arr[0];
}
if(empty( $image ) || empty($image_src)) return;

$wrapper_classes = array(
	'gf-banner',
	$hover_effect,
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);
if('on' === $bg_overlay_first) {
    $wrapper_classes[] = 'gf-banner-overlay-first';
}

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$link_attributes = $title_attributes = array();
$link = ( '||' === $link ) ? '' : $link;
$link = vc_build_link( $link );
$use_link = false;
if ( strlen( $link['url'] ) > 0 ) {
	$use_link = true;
	$link_attributes[] = 'href="' . esc_url( trim($link['url']) ) . '"';
	if(strlen($link['target']) >0) {
		$link_attributes[] = 'target="' . trim($link['target']) . '"';
	}
	if(strlen($link['rel']) >0) {
		$link_attributes[] = 'rel="' . trim($link['rel']) . '"';
	}
	if(strlen($link['title']) >0) {
		$link_attributes[] = 'title="' . trim($link['title']) . '"';
		if(empty($title)) {
			$title = trim($link['title']);
		}
	} elseif (!empty( $title )) {
		$link_attributes[] = 'title="' . trim($title) . '"';
	}
	if(empty($title)) {
		$wrapper_classes[] = 'gf_banner_link';
	}
}

$banner_class = 'gf-banner-'.random_int( 1000, 9999 );
$banner_css = <<<CSS
	.{$banner_class}:after {
		background-color: {$banner_bg_overlay_color} !important;
	}
	.{$banner_class} .gf-banner-content a h4 {
	    color: {$title_color};
	}
	.{$banner_class} .gf-banner-content a:hover h4 {
	    color: {$title_bottom_line_color};
	}
	.{$banner_class} .gf-banner-content h4:before {
		background-color: {$title_bottom_line_color};
	}
CSS;
GSF()->customCss()->addCss($banner_css);

$banner_bg_css = '';
$img_width = isset($image_arr[1]) ? intval($image_arr[1]) : 0;
$img_height = isset($image_arr[2]) ? intval($image_arr[2]) : 0;
if($height_mode != 'custom') {
    if($height_mode === 'original') {
        $height_mode = ($img_height/$img_width)*100;
    }
    $banner_bg_css =<<<CSS
        .{$banner_class} {
            background-image: url('{$image_src}');
            padding-bottom: {$height_mode}%;
        }
CSS;
} else {

		$banner_bg_css =<<<CSS
			.{$banner_class} {
				background-image: url('{$image_src}');
				height: {$height};
			}
CSS;
}
GSF()->customCss()->addCss($banner_bg_css);
if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-banner'), G5P()->helper()->getAssetUrl('shortcodes/banner/assets/css/banner.min.css'), array(), G5P()->pluginVer());
}
$wrapper_classes[] = $banner_class;
$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
    <?php if(empty($title) && $use_link): ?>
        <a <?php echo implode( ' ', $link_attributes ); ?>></a>
    <?php endif; ?>
    <div class="gf-banner-inner effect-content">
        <?php if (!empty($title)): ?>
            <div class="gf-banner-content block-center">
                <div class="block-center-inner">
                    <?php if($use_link): ?>
                    <a <?php echo implode( ' ', $link_attributes ); ?>>
                        <?php endif; ?>
                        <h4><?php echo esc_html($title); ?></h4>
                        <?php if($use_link): ?>
                    </a>
                <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>