<?php
return array(
	'base' => 'gsf_banner',
	'name' => esc_html__( 'Banner', 'ruby-build-framework' ),
	'icon' => 'fa fa-image',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		G5P()->shortcode()->vc_map_add_title(array('admin_label' => true)),
		array(
			'param_name'        => 'hover_effect',
			'heading'     => esc_html__('Hover Effect', 'ruby-build-framework'),
			'type'      => 'dropdown',
			'std'      => '',
			'value' => array(
				esc_html__('None', 'ruby-build-framework') => '',
				esc_html__('Suprema', 'ruby-build-framework') => 'suprema-effect',
				esc_html__('Layla', 'ruby-build-framework') => 'layla-effect',
				esc_html__('Bubba', 'ruby-build-framework') => 'bubba-effect',
				esc_html__('Jazz', 'ruby-build-framework') => 'jazz-effect'
			)
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__('Background Image', 'ruby-build-framework'),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'param_name' => 'image'
		),
		array(
			'type' => 'vc_link',
			'heading' => esc_html__( 'Link (URL)', 'ruby-build-framework' ),
			'param_name' => 'link',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Height Mode', 'ruby-build-framework' ),
			'param_name' => 'height_mode',
			'value' => array(
				'1:1' => '100',
				esc_html__( 'Original', 'ruby-build-framework' )=> 'original',
				'4:3' => '133.333333333',
				'3:4' => '75',
				'16:9' => '177.777777778',
				'9:16' => '56.25',
				esc_html__( 'Custom', 'ruby-build-framework' )=> 'custom'
			),
			'std' => 'original',
			'dependency' => array('element' => 'banner_bg_image', 'value_not_equal_to' => array('')),
			'description' => esc_html__( 'Sizing proportions for height and width. Select "Original" to scale image without cropping.', 'ruby-build-framework' )
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Height', 'ruby-build-framework' ),
			'param_name' => 'height',
			'std' => '340px',
			'dependency' => array('element' => 'height_mode', 'value' => 'custom'),
			'description' => esc_html__( 'Enter custom height. Not include unit.', 'ruby-build-framework' )
		),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Background Overlay Color', 'ruby-build-framework' ),
            'param_name' => 'banner_bg_overlay_color',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'std' => 'rgba(0,0,0,0.79)',
            'dependency' => array('element' => 'hover_effect', 'value_not_equal_to' => array('')),
            'description' => esc_html__( 'Specify an color for the background overlay.', 'ruby-build-framework' )
        ),
        array(
            'type' => 'gsf_switch',
            'heading' => esc_html__( 'Background Overlay At First', 'ruby-build-framework' ),
            'param_name' => 'bg_overlay_first',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'std' => 'on',
            'dependency' => array('element' => 'banner_bg_overlay_color', 'value_not_equal_to' => array(''))
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Text Color', 'ruby-build-framework' ),
            'param_name' => 'title_color',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'std' => '#fff'
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Title Bottom Line Color', 'ruby-build-framework' ),
            'param_name' => 'title_bottom_line_color',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'std' => '#f9c100'
        ),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);