<?php
/**
 * The template for displaying social-share.php
 * @var $page_permalink
 * @var $page_title
 * @var $layout - Accepts 'classic', 'circle', 'square'
 * @var $show_title
 */
$social_share = G5P()->options()->get_social_share();
unset($social_share['sort_order']);
if (sizeof($social_share) === 0) return;
$wrapper_classes = array(
	'gf-social-icon',
	'gf-inline'
);
if (isset($layout) && !empty($layout) && ($layout !== 'classic')) {
	$wrapper_classes[] = "social-icon-{$layout}";
}
if ($page_permalink === '') {
	$page_permalink = get_permalink();
}

if ($page_title === '') {
	$page_title = get_the_title();
}


$wrapper_class = implode(' ', array_filter($wrapper_classes));
?>
<ul class="<?php echo esc_attr($wrapper_class)?>">
	<?php foreach((array)$social_share as $key => $value) {
		$link = '';
		$icon = '';
		switch ($key) {
			case 'facebook':
				$link = "javascript: window.open('https://www.facebook.com/sharer.php?s=100&amp;p[url]" . $page_permalink . "','_blank', 'width=900, height=450');";
				$icon = 'fa fa-facebook';
				break;
			case 'twitter':
				$by = '';
				$twitter_author_username = G5P()->options()->get_twitter_author_username();
				if ($twitter_author_username !== '') {
					$by = "@{$twitter_author_username}";
				}
				$link  = "javascript: window.open('http://twitter.com/share?text=" . $page_title . $by . "&url=" . $page_permalink . "','_blank', 'width=900, height=450');";
				$icon = 'fa fa-twitter';
				break;
			case 'google':
				$link  = "javascript: window.open('http://plus.google.com/share?url=" . $page_permalink . "','_blank', 'width=500, height=450');";
				$icon = 'fa fa-google-plus';
				break;
			case 'linkedin':
				$link  = "javascript: window.open('http://www.linkedin.com/shareArticle?mini=true&url=" . $page_permalink . "&title=" . $page_title . "','_blank', 'width=500, height=450');";
				$icon = 'fa fa-linkedin';
				break;
			case 'tumblr':
				$link  = "javascript: window.open('http://www.tumblr.com/share/link?url=" . $page_permalink . "&name=" . $page_title . "','_blank', 'width=500, height=450');";
				$icon = 'fa fa-tumblr';
				break;
			case 'pinterest':
				$_img_src = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				$link     = "javascript: window.open('http://pinterest.com/pin/create/button/?url=" . $page_permalink . '&media=' . (($_img_src === false) ? '' :  $_img_src[0]) . "&description=" . $page_title . "','_blank', 'width=900, height=450');";
				$icon = 'fa fa-pinterest';
				break;
			case 'email':
				$link  = "mailto:?subject=" . $page_title . "&body=" . esc_url( $page_permalink );
				$icon = 'fa fa-envelope';
				break;
			case 'telegram':
				$link  = "javascript: window.open('https://telegram.me/share/url?url=" . esc_url( $page_permalink ) . "&text=" . $page_title . "','_blank', 'width=900, height=450');";
				$icon = 'fa fa-send';
				break;
			case 'whatsapp':
				$link  = "whatsapp://send?text=" . esc_attr( $page_title . "  \n\n" . esc_url( $page_permalink ) );
				$icon = 'fa fa-whatsapp';
				break;

		}
	ob_start();
	?>
	<li class="<?php echo esc_attr($key);?>">
		<a class="<?php echo esc_attr($layout === 'circle' ? 'gf-hover-circle' : '') ?>" href="<?php echo ($link); ?>" data-toggle="tooltip" title="<?php echo esc_attr($value)?>" target="_blank" rel="nofollow">
			<i class="<?php echo esc_attr($icon); ?>"></i> <?php if ($show_title === true) { echo esc_html($value);} ?>
		</a>
	</li>
	<?php
		echo ob_get_clean();
	}
	?>
</ul>
