<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('G5P_Inc_ShortCode')) {
	class G5P_Inc_ShortCode
	{
		private static $_instance;
		
		public static function getInstance()
		{
			if (self::$_instance == NULL) {
				self::$_instance = new self();
			}
			
			return self::$_instance;
		}
		
		public function init()
		{
			$this->includes();
			// Auto Loader Class
			spl_autoload_register(array($this, 'autoload_class_file'));
			
			// vc learn map
			add_action('vc_before_mapping', array($this, 'vc_lean_map'));
			
		}
		
		/**
		 * Auto Loader Class
		 *
		 * @param $class_name
		 */
		public function autoload_class_file($class)
		{
			
			$file_name = preg_replace('/^WPBakeryShortCode_gsf_/', '', $class);
			if ($file_name !== $class) {
				$file_name = strtolower($file_name);
				$file_name = str_replace('_', '-', $file_name);
				G5P()->loadFile(G5P()->pluginDir("shortcodes/{$file_name}/{$file_name}.php"));
			}
		}
		
		public function includes()
		{
			G5P()->loadFile(G5P()->pluginDir('shortcodes/shortcode-base.class.php'));
		}
		
		/**
		 * Get Shortcodes category name
		 *
		 * @return string
		 */
		public function get_category_name()
		{
			$current_theme = wp_get_theme();
			return $current_theme['Name'] . ' Shortcodes';
		}
		
		/**
		 * Get List Shortcodes
		 *
		 * @return mixed|void
		 */
		private function get_shortcodes()
		{
			return apply_filters('gsf_shorcodes', array(
				'gsf_banner',
				'gsf_breadcrumbs',
				'gsf_button',
				'gsf_gallery',
				'gsf_google_map',
				'gsf_heading',
				'gsf_menu_column',
				'gsf_page_title',
				'gsf_posts',
				'gsf_social_networks',
				'gsf_video',
				'gsf_call_to_action',
				'gsf_icon_box',
				'gsf_space',
				'gsf_partner_carousel',
				'gsf_testimonials',
				'gsf_job_position',
				'gsf_feature_box',
				'gsf_counter',
				'gsf_timeline',
				'gsf_certificates',
				'gsf_pricing_tables',
                'gsf_slider_container',
			));
		}
		
		public function vc_lean_map()
		{
			$shorcodes = $this->get_shortcodes();
			foreach ($shorcodes as $key) {
				$directory = preg_replace('/^gsf_/', '', $key);
				vc_lean_map($key, null, G5P()->pluginDir('shortcodes/' . str_replace('_', '-', $directory) . '/config.php'));
			}
		}
		
		/**
		 * Get Setting Icon Font
		 *
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_icon_font($args = array())
		{
			$default = array(
				'type'        => 'gsf_icon_picker',
				'heading'     => esc_html__('Icon', 'ruby-build-framework'),
				'param_name'  => 'icon_font',
				'value'       => '',
				'description' => esc_html__('Select icon from library.', 'ruby-build-framework')
			);
			
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_product_narrow_categories($args = array())
		{
			$category = array();
			$categories = get_categories(array('hide_empty' => '1', 'taxonomy' => 'product_cat'));
			if (is_array($categories)) {
				foreach ($categories as $cat) {
					$category[$cat->name] = $cat->slug;
				}
			}
			$default = array(
				'value'       => $category,
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Category', 'ruby-build-framework'),
				'param_name'  => 'category',
				'multiple'    => true,
				'description' => esc_html__('Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_pojects_narrow_categories($args = array())
		{
			$category = array();
			$categories = get_categories(array('hide_empty' => '1', 'taxonomy' => 'portfolio_cat'));
			if (is_array($categories)) {
				foreach ($categories as $cat) {
					$category[$cat->name] = $cat->slug;
				}
			}
			$default = array(
				'value'       => $category,
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Category', 'ruby-build-framework'),
				'param_name'  => 'category',
				'multiple'    => true,
				'description' => esc_html__('Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_our_team_narrow_categories($args = array())
		{
			$category = array();
			$categories = get_categories(array('hide_empty' => '1', 'taxonomy' => 'our_team_cat'));
			if (is_array($categories)) {
				foreach ($categories as $cat) {
					$category[$cat->name] = $cat->slug;
				}
			}
			$default = array(
				'value'       => $category,
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Category', 'ruby-build-framework'),
				'param_name'  => 'category',
				'multiple'    => true,
				'description' => esc_html__('Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_services_narrow_categories($args = array())
		{
			$category = array();
			$categories = get_categories(array('hide_empty' => '1', 'taxonomy' => 'our_service_cat'));
			if (is_array($categories)) {
				foreach ($categories as $cat) {
					$category[$cat->name] = $cat->slug;
				}
			}
			$default = array(
				'value'       => $category,
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Category', 'ruby-build-framework'),
				'param_name'  => 'category',
				'multiple'    => true,
				'description' => esc_html__('Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * Animation Style
		 *
		 * @param bool $label
		 * @return array
		 */
		public function vc_map_add_css_animation($label = true)
		{
			$data = array(
				'type'        => 'animation_style',
				'heading'     => esc_html__('CSS Animation', 'ruby-build-framework'),
				'param_name'  => 'css_animation',
				'admin_label' => $label,
				'value'       => '',
				'settings'    => array(
					'type'   => 'in',
					'custom' => array(
						array(
							'label'  => esc_html__('Default', 'ruby-build-framework'),
							'values' => array(
								esc_html__('Top to bottom', 'ruby-build-framework')      => 'top-to-bottom',
								esc_html__('Bottom to top', 'ruby-build-framework')      => 'bottom-to-top',
								esc_html__('Left to right', 'ruby-build-framework')      => 'left-to-right',
								esc_html__('Right to left', 'ruby-build-framework')      => 'right-to-left',
								esc_html__('Appear from center', 'ruby-build-framework') => 'appear',
							),
						),
					),
				),
				'description' => esc_html__('Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).', 'ruby-build-framework'),
				'group'       => esc_html__('Animation', 'ruby-build-framework')
			);
			return apply_filters('vc_map_add_css_animation', $data, $label);
		}
		
		
		/**
		 * Animation Duration
		 *
		 * @return array
		 */
		public function vc_map_add_animation_duration()
		{
			return array(
				'type'        => 'textfield',
				'heading'     => esc_html__('Animation Duration', 'ruby-build-framework'),
				'param_name'  => 'animation_duration',
				'value'       => '',
				'description' => wp_kses_post(__('Duration in seconds. You can use decimal points in the value. Use this field to specify the amount of time the animation plays. <em>The default value depends on the animation, leave blank to use the default.</em>', 'ruby-build-framework')),
				'group'       => esc_html__('Animation', 'ruby-build-framework')
			);
		}
		
		/**
		 * Animation Delay
		 *
		 * @return array
		 */
		public function vc_map_add_animation_delay()
		{
			return array(
				'type'        => 'textfield',
				'heading'     => esc_html__('Animation Delay', 'ruby-build-framework'),
				'param_name'  => 'animation_delay',
				'value'       => '',
				'description' => esc_html__('Delay in seconds. You can use decimal points in the value. Use this field to delay the animation for a few seconds, this is helpful if you want to chain different effects one after another above the fold.', 'ruby-build-framework'),
				'group'       => esc_html__('Animation', 'ruby-build-framework')
			);
		}
		
		
		/**
		 * Extra Class
		 *
		 * @return array
		 */
		public function vc_map_add_extra_class()
		{
			$args = array(
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Extra class name', 'ruby-build-framework'),
				'param_name'  => 'el_class',
				'tags'        => true,
				'std'         => '',
				'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.', 'ruby-build-framework'),
			);
			$extra_class = &G5P()->helper()->get_extra_class();
			if (is_array($extra_class) && sizeof($extra_class) > 0) {
				$args['value'] = $extra_class;
			}
			return $args;
		}
		
		/**
		 * Design Options
		 *
		 * @return array
		 */
		public function vc_map_add_css_editor()
		{
			return array(
				'type'       => 'css_editor',
				'heading'    => esc_html__('CSS box', 'ruby-build-framework'),
				'param_name' => 'css',
				'group'      => esc_html__('Design Options', 'ruby-build-framework'),
			);
		}
		
		public function vc_map_add_responsive()
		{
			return array(
				'type'        => 'gsf_responsive',
				'heading'     => esc_html__('Responsive', 'ruby-build-framework'),
				'param_name'  => 'responsive',
				'group'       => esc_html__('Responsive Options', 'ruby-build-framework'),
				'description' => esc_html__('Adjust column for different screen sizes. Control visibility settings.', 'ruby-build-framework'),
			);
		}
		
		public function vc_map_add_color_skin($args = array())
		{
			$default = array(
				'type'        => 'dropdown',
				'heading'     => esc_html__('Color Skin', 'ruby-build-framework'),
				'param_name'  => 'color_skin',
				'description' => esc_html__('Select color skin.', 'ruby-build-framework'),
				'value'       => $this->get_color_skin(true),
				'std'         => '',
				'admin_label' => true,
			
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * Get Color Skin
		 *
		 * @param bool $default
		 * @return array
		 */
		public function get_color_skin($default = false)
		{
			$skins = array();
			if ($default) {
				$skins[esc_html__('Inherit', 'ruby-build-framework')] = '';
			}
			$custom_color_skin = G5P()->optionsSkin()->get_color_skin();
			if (is_array($custom_color_skin)) {
				foreach ($custom_color_skin as $key => $value) {
					if (isset($value['skin_name']) && isset($value['skin_id'])) {
						$skins[$value['skin_name']] = $value['skin_id'];
					}
					
				}
			}
			return $skins;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_narrow_category($args = array())
		{
			$category = array();
			$categories = get_categories(array('hide_empty' => '1'));
			if (is_array($categories)) {
				foreach ($categories as $cat) {
					$category[$cat->name] = $cat->slug;
				}
			}
			$default = array(
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Category', 'ruby-build-framework'),
				'param_name'  => 'category',
				'value'       => $category,
				'multiple'    => true,
				'description' => esc_html__('Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_narrow_tag($args = array())
		{
			$tag = array();
			$tags = get_tags(array('hide_empty' => '1'));
			if (is_array($tags)) {
				foreach ($tags as $tg) {
					$tag[$tg->name] = $tg->slug;
				}
			}
			$default = array(
				'type'        => 'gsf_selectize',
				'heading'     => esc_html__('Narrow Tag', 'ruby-build-framework'),
				'param_name'  => 'tag',
				'value'       => $tag,
				'multiple'    => true,
				'description' => esc_html__('Enter tags by names to narrow output).', 'ruby-build-framework'),
				'std'         => ''
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $array
		 * @return array
		 */
		public function switch_array_key_value($array = array())
		{
			$result = array();
			foreach ($array as $key => $value) {
				$result[$value] = $key;
			}
			return $result;
		}
		
		/**
		 * @return array
		 */
		public function get_toggle()
		{
			return array(
				esc_html__('On', 'ruby-build-framework')  => '1',
				esc_html__('Off', 'ruby-build-framework') => '0'
			);
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_title($args = array())
		{
			$default = array(
				'type'       => 'textfield',
				'heading'    => esc_html__('Title', 'ruby-build-framework'),
				'param_name' => 'title'
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_heading_bg_color($args = array())
		{
			$default = array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__('Background Color', 'ruby-build-framework'),
				'param_name'       => 'heading_bg_color',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '#f2bc00',
				'description'      => esc_html__('Specify an color for the background.', 'ruby-build-framework')
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_heading_text_color($args = array())
		{
			$default = array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__('Text Color', 'ruby-build-framework'),
				'param_name'       => 'text_color',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '#fff'
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_heading_border_bottom_width($args = array())
		{
			$default = array(
				'type'             => 'gsf_button_set',
				'heading'          => esc_html__('Border Bottom Width', 'ruby-build-framework'),
				'param_name'       => 'border_bottom_width',
				'value'            => array(
					'1px' => '1px',
					'2px' => '2px'
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '1px'
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_icon_shape($args = array())
		{
			$default = array(
				'type'             => 'gsf_button_set',
				'heading'          => esc_html__('Icon Shape', 'ruby-build-framework'),
				'param_name'       => 'icon_shape',
				'value'            => array(
					esc_html__('Classic', 'ruby-build-framework') => 'icon-classic',
					esc_html__('Circle', 'ruby-build-framework')  => 'icon-circle',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_pagination($args = array())
		{
			$default = array(
				'type'       => 'gsf_switch',
				'heading'    => esc_html__('Show pagination control', 'ruby-build-framework'),
				'param_name' => 'dots',
				'std'        => '',
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_navigation($args = array())
		{
			$default = array(
				'type'       => 'gsf_switch',
				'heading'    => esc_html__('Show navigation control', 'ruby-build-framework'),
				'param_name' => 'nav',
				'std'        => 'on',
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_navigation_position($args = array())
		{
			$default = array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Navigation Position', 'ruby-build-framework'),
				'param_name' => 'nav_position',
				'value'      => array(
					esc_html__('Top Right', 'ruby-build-framework')     => 'nav-top-right',
					esc_html__('Center', 'ruby-build-framework')        => 'nav-center',
					esc_html__('Bottom Left', 'ruby-build-framework')   => 'nav-bottom-left',
					esc_html__('Bottom Center', 'ruby-build-framework') => 'nav-bottom-center',
					esc_html__('Bottom Right', 'ruby-build-framework')  => 'nav-bottom-right'
				),
				'std'        => 'nav-top-right',
				'dependency' => array('element' => 'nav', 'value' => 'on'),
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_navigation_style($args = array())
		{
			$default = array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Navigation Style', 'ruby-build-framework'),
				'param_name' => 'nav_style',
				'value'      => array(
					esc_html__('Square with Icon', 'ruby-build-framework') => 'nav-square-icon',
					esc_html__('Square with Text', 'ruby-build-framework') => 'nav-square-text',
					esc_html__('Circle with Icon', 'ruby-build-framework') => 'nav-circle-icon',
					esc_html__('Circle with Text', 'ruby-build-framework') => 'nav-circle-text',
				),
				'std'        => 'nav-square-icon',
				'dependency' => array('element' => 'nav', 'value' => 'on'),
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		/**
		 * @return array
		 */
		public function get_heading_option()
		{
			return array(
				array(
					'type'             => 'gsf_switch',
					'heading'          => esc_html__('Include Heading', 'ruby-build-framework'),
					'param_name'       => 'include_heading',
					'edit_field_class' => 'vc_col-sm-6 vc_column',
					'std'              => 'on'
				),
				$this->vc_map_add_title(
					array(
						'dependency' => array('element' => 'include_heading', 'value' => 'on'),
						'group'      => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
				$this->vc_map_add_heading_bg_color(
					array(
						'dependency' => array('element' => 'include_heading', 'value' => 'on'),
						'group'      => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
				$this->vc_map_add_heading_text_color(
					array(
						'dependency' => array('element' => 'include_heading', 'value' => 'on'),
						'group'      => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
				$this->vc_map_add_heading_border_bottom_width(
					array(
						'dependency' => array('element' => 'include_heading', 'value' => 'on'),
						'group'      => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
				$this->vc_map_add_icon_font(
					array(
						'edit_field_class' => 'vc_col-sm-6 vc_column',
						'dependency'       => array('element' => 'include_heading', 'value' => 'on'),
						'group'            => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
				$this->vc_map_add_icon_shape(
					array(
						'dependency' => array('element' => 'icon_font', 'value_not_equal_to' => array('')),
						'group'      => esc_html__('Heading Options', 'ruby-build-framework')
					)
				),
			);
		}
		
		/**
		 * @return array
		 */
		public function get_post_filter()
		{
			return array(
				$this->vc_map_add_narrow_category(array(
					'group' => esc_html__('Posts Filter', 'ruby-build-framework')
				)),
				$this->vc_map_add_narrow_tag(array(
					'group' => esc_html__('Posts Filter', 'ruby-build-framework')
				)),
				array(
					'type'        => 'autocomplete',
					'heading'     => esc_html__('Narrow Post', 'ruby-build-framework'),
					'param_name'  => 'ids',
					'settings'    => array(
						'multiple'       => true,
						//'sortable' => true,
						'unique_values'  => true,
						'display_inline' => true
					),
					'save_always' => true,
					'group'       => esc_html__('Posts Filter', 'ruby-build-framework'),
					'description' => esc_html__('Enter List of Posts', 'ruby-build-framework'),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Order by', 'ruby-build-framework'),
					'param_name'  => 'orderby',
					'value'       => array(
						esc_html__('Date', 'ruby-build-framework')                  => 'date',
						esc_html__('Order by post ID', 'ruby-build-framework')      => 'ID',
						esc_html__('Author', 'ruby-build-framework')                => 'author',
						esc_html__('Title', 'ruby-build-framework')                 => 'title',
						esc_html__('Last modified date', 'ruby-build-framework')    => 'modified',
						esc_html__('Post/page parent ID', 'ruby-build-framework')   => 'parent',
						esc_html__('Number of comments', 'ruby-build-framework')    => 'comment_count',
						esc_html__('Menu order/Page Order', 'ruby-build-framework') => 'menu_order',
						esc_html__('Meta value', 'ruby-build-framework')            => 'meta_value',
						esc_html__('Meta value number', 'ruby-build-framework')     => 'meta_value_num',
						esc_html__('Random order', 'ruby-build-framework')          => 'rand',
					),
					'group'       => esc_html__('Posts Filter', 'ruby-build-framework'),
					'description' => esc_html__('Select order type. If "Meta value" or "Meta value Number" is chosen then meta key is required.', 'ruby-build-framework')
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__('Time Filter', 'ruby-build-framework'),
					'param_name' => 'time_filter',
					'value'      => array(
						esc_html__('No Filter', 'ruby-build-framework')               => 'none',
						esc_html__('Today Posts', 'ruby-build-framework')             => 'today',
						esc_html__('Today + Yesterday Posts', 'ruby-build-framework') => 'yesterday',
						esc_html__('This Week Posts', 'ruby-build-framework')         => 'week',
						esc_html__('This Month Posts', 'ruby-build-framework')        => 'month',
						esc_html__('This Year Posts', 'ruby-build-framework')         => 'year'
					),
					'group'      => esc_html__('Posts Filter', 'ruby-build-framework')
				),
				array(
					'type'        => 'gsf_button_set',
					'heading'     => esc_html__('Sorting', 'ruby-build-framework'),
					'param_name'  => 'order',
					'value'       => array(
						esc_html__('Descending', 'ruby-build-framework') => 'DESC',
						esc_html__('Ascending', 'ruby-build-framework')  => 'ASC',
					),
					'std'         => 'DESC',
					'group'       => esc_html__('Posts Filter', 'ruby-build-framework'),
					'description' => esc_html__('Select sorting order.', 'ruby-build-framework'),
				),
				
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__('Meta key', 'ruby-build-framework'),
					'param_name'  => 'meta_key',
					'description' => esc_html__('Input meta key for grid ordering.', 'ruby-build-framework'),
					'group'       => esc_html__('Posts Filter', 'ruby-build-framework'),
					'dependency'  => array(
						'element' => 'orderby',
						'value'   => array('meta_value', 'meta_value_num'),
					),
				)
			);
		}
		
		public function get_post_carousel_layout($inherit = false)
		{
			$config = apply_filters('gsf_post_layout', array(
				'large-image'    => array(
					'label' => esc_html__('Large Image', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-large-image.png'),
				),
				'medium-image'   => array(
					'label' => esc_html__('Medium Image', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-medium-image.png'),
				),
				'medium-image-2' => array(
					'label' => esc_html__('Medium Image 2', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-medium-image-2.png'),
				),
				'grid'           => array(
					'label' => esc_html__('Grid', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-grid.png'),
				),
				'grid-2'         => array(
					'label' => esc_html__('Grid 2', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-grid-2.png'),
				),
				'tall-1'         => array(
					'label' => esc_html__('Tall 1', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-tall-1.png'),
				),
				'tall-2'         => array(
					'label' => esc_html__('Tall 2', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-tall-2.png'),
				),
				'tall-3'         => array(
					'label' => esc_html__('Tall 3', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-tall-3.png'),
				),
			));
			if ($inherit) {
				$config = array(
						'-1' => array(
							'label' => esc_html__('Default', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						),
					) + $config;
			}
			return $config;
		}
		
		public function get_column_responsive($dependency = array())
		{
			$responsive = array(
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Large Devices', 'ruby-build-framework'),
					'description' => esc_html__('Browser Width >= 1200px', 'ruby-build-framework'),
					'param_name'  => 'columns',
					'value'       => G5P()->settings()->get_post_columns(),
					'std'         => 3,
					'group'       => esc_html__('Responsive', 'ruby-build-framework'),
					'dependency' => $dependency
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Medium Devices', 'ruby-build-framework'),
					'param_name'  => 'columns_md',
					'description' => esc_html__('Browser Width < 1200px', 'ruby-build-framework'),
					'value'       => G5P()->settings()->get_post_columns(),
					'std'         => 2,
					'group'       => esc_html__('Responsive', 'ruby-build-framework'),
					'dependency' => $dependency
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Small Devices', 'ruby-build-framework'),
					'param_name'  => 'columns_sm',
					'description' => esc_html__('Browser Width < 992px', 'ruby-build-framework'),
					'value'       => G5P()->settings()->get_post_columns(),
					'std'         => 2,
					'group'       => esc_html__('Responsive', 'ruby-build-framework'),
					'dependency' => $dependency
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Extra Small Devices', 'ruby-build-framework'),
					'param_name'  => 'columns_xs',
					'description' => esc_html__('Browser Width < 768px', 'ruby-build-framework'),
					'value'       => G5P()->settings()->get_post_columns(),
					'std'         => 1,
					'group'       => esc_html__('Responsive', 'ruby-build-framework'),
					'dependency' => $dependency
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__('Extra Extra Small Devices', 'ruby-build-framework'),
					'param_name'  => 'columns_mb',
					'description' => esc_html__('Browser Width < 600px', 'ruby-build-framework'),
					'value'       => G5P()->settings()->get_post_columns(),
					'std'         => 1,
					'group'       => esc_html__('Responsive', 'ruby-build-framework'),
					'dependency' => $dependency
				)
			);
			return $responsive;
		}
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_autoplay_enable($args = array())
		{
			$default = array(
				'type'             => 'gsf_switch',
				'heading'          => esc_html__('Autoplay Enable', 'ruby-build-framework'),
				'param_name'       => 'autoplay',
				'std'              => '',
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			);
			$default = array_merge($default, $args);
			return $default;
		}
		
		
		/**
		 * @param array $args
		 * @return array
		 */
		public function vc_map_add_autoplay_timeout($args = array())
		{
			$default = array(
				'type'             => 'gsf_number',
				'heading'          => esc_html__('Autoplay Timeout', 'ruby-build-framework'),
				'param_name'       => 'autoplay_timeout',
				'std'              => '5000',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'autoplay', 'value' => 'on')
			);
			$default = array_merge($default, $args);
			return $default;
		}
	}
}