<?php
if (!defined('ABSPATH')) {
	exit('Direct script access denied.');
}
if (!class_exists(' G5P_Inc_Settings')) {
	class  G5P_Inc_Settings
	{
		private static $_instance;

		public static function getInstance()
		{
			if (self::$_instance == NULL) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/**
		 * Get Main Layout
		 *
		 * @param bool $default
		 * @return mixed|void
		 */
		public function get_main_layout($default = false)
		{
			$defaults = array();
			if ($default) {
				$defaults[''] = array(
					'label' => esc_html__('Inherit', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
				);
			}
			$config = apply_filters('gsf_options_main_layout', array(
				'wide'     => array(
					'label' => esc_html__('Wide', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/layout-wide.png'),
				),
				'boxed'    => array(
					'label' => esc_html__('Boxed', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/layout-boxed.png'),
				),
				'framed'   => array(
					'label' => esc_html__('Framed', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/layout-framed.png'),
				),
				'bordered' => array(
					'label' => esc_html__('Bordered', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/layout-bordered.png'),
				)
			));

			$config = wp_parse_args($config, $defaults);
			return $config;
		}

		/**
		 * Get Sidebar Layout
		 *
		 * @param bool $inherit
		 * @return mixed|void
		 */
		public function get_sidebar_layout($inherit = false)
		{
			$config = apply_filters('gsf_options_sidebar_layout', array(
				'none'  => array(
					'label' => esc_html__('Full Width', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/sidebar-none.png'),
				),
				'left'  => array(
					'label' => esc_html__('Left Sidebar', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/sidebar-left.png'),
				),
				'right' => array(
					'label' => esc_html__('Right Sidebar', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/sidebar-right.png'),
				)
			));

			if ($inherit) {
				$config = array(
						'' => array(
							'label' => esc_html__('Inherit', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						)
					) + $config;
			}
			return $config;
		}

		/**
		 * Get Sidebar Width
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_sidebar_width($inherit = false)
		{
			$config = apply_filters('gsf_options_sidebar_width', array(
				'small' => esc_html__('Small (1/4)', 'ruby-build-framework'),
				'large' => esc_html__('Large (1/3)', 'ruby-build-framework')
			));
			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}
			return $config;
		}

		/**
		 * Get Toggle
		 *
		 * @param bool $inherit
		 * @return array
		 */
		public function get_toggle($inherit = false)
		{
			$config = array(
				'on'  => esc_html__('On', 'ruby-build-framework'),
				'off' => esc_html__('Off', 'ruby-build-framework')
			);

			if ($inherit) {
				$config = array('' => esc_html__('Inherit', 'ruby-build-framework')) + $config;
			}
			return $config;
		}

		/**
		 * Get Header Customize Nav Required
		 *
		 * @return array
		 */
		public function get_header_customize_nav_required()
		{
			return apply_filters('gsf_options_header_customize_nav_required', array('header-1', 'header-2', 'header-3', 'header-5', 'header-6', 'header-7'));
		}

		/**
		 * Get Header Customize Left Required
		 *
		 * @return array
		 */
		public function get_header_customize_left_required()
		{
			return apply_filters('gsf_options_header_customize_nav_required', array('header-4', 'header-5'));
		}

		/**
		 * Get Header Customize Right Required
		 *
		 * @return array
		 */
		public function get_header_customize_right_required()
		{
			return apply_filters('gsf_options_header_customize_nav_required', array('header-3', 'header-4', 'header-5'));
		}

		/**
		 * Get Search Ajax Post Type
		 *
		 * @return array
		 */
		public function get_search_ajax_popup_post_type()
		{

			$output = array(
				'post' => esc_html__('Post', 'ruby-build-framework'),
				'page' => esc_html__('Page', 'ruby-build-framework'),
			);

			if (class_exists('WooCommerce')) {
				$output['product'] = esc_html__('Product', 'ruby-build-framework');
			}


			return apply_filters('gsf_options_get_search_popup_ajax_post_type', $output);
		}

		/**
		 * Get Maintenance Mode
		 *
		 * @return array
		 */
		public function get_maintenance_mode()
		{
			return apply_filters('gsf_options_maintenance_mode', array(
				'2' => 'On (Custom Page)',
				'1' => 'On (Standard)',
				'0' => 'Off',
			));
		}

		/**
		 * Get Header Layout
		 *
		 * @return array
		 */
		public function get_header_layout()
		{
			return apply_filters('gsf_options_header_layout', array(
				'header-1' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-1.png'),
					'label' => esc_html__('Header 1', 'ruby-build-framework')
				),
				'header-2' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-2.png'),
					'label' => esc_html__('Header 2', 'ruby-build-framework')
				),
				'header-3' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-3.png'),
					'label' => esc_html__('Header 3', 'ruby-build-framework')
				),
				'header-4' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-4.png'),
					'label' => esc_html__('Header 4', 'ruby-build-framework')
				),
				'header-5' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-5.png'),
					'label' => esc_html__('Header 5', 'ruby-build-framework')
				),
				'header-6' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-6.png'),
					'label' => esc_html__('Header 6', 'ruby-build-framework')
				),
				'header-7' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-7.png'),
					'label' => esc_html__('Header 7', 'ruby-build-framework')
				)
			));
		}

		/**
		 * Get Header Customize
		 *
		 * @return array
		 */
		public function get_header_customize()
		{
			$settings = array(
				'search'          => esc_html__('Search', 'ruby-build-framework'),
				'social-networks' => esc_html__('Social Networks', 'ruby-build-framework'),
				'sidebar'         => esc_html__('Sidebar', 'ruby-build-framework'),
				'custom-html'     => esc_html__('Custom Html', 'ruby-build-framework'),
				'canvas-sidebar'  => esc_html__('Canvas Sidebar', 'ruby-build-framework'),
			);
			if (class_exists('WooCommerce')) {
				$settings['shopping-cart'] = esc_html__('Shopping Cart', 'ruby-build-framework');
			}
			return apply_filters('gsf_options_header_customize', $settings);
		}

		/**
		 * Get Header Mobile Layout
		 *
		 * @return array
		 */
		public function get_header_mobile_layout()
		{
			return apply_filters('gsf_options_header_mobile_layout', array(
				'header-1' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-mobile-layout-1.png'),
					'label' => esc_html__('Layout 1', 'ruby-build-framework')
				),
				'header-2' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-mobile-layout-2.png'),
					'label' => esc_html__('Layout 2', 'ruby-build-framework')
				),
				'header-3' => array(
					'img'   => G5P()->pluginUrl('assets/images/theme-options/header-mobile-layout-3.png'),
					'label' => esc_html__('Layout 3', 'ruby-build-framework')
				)
			));
		}




		/**
		 * Get Bottom Bar Layout
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_border_layout($inherit = false)
		{
			$config = apply_filters('gsf_options_border_layout', array(
				'none'      => esc_html__('None', 'ruby-build-framework'),
				'full'      => esc_html__('Full', 'ruby-build-framework'),
				'container' => esc_html__('Container', 'ruby-build-framework')
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}
			return $config;
		}

		/**
		 * Get Loading Animation
		 *
		 * @return array
		 */
		public function get_loading_animation()
		{
			return apply_filters('gsf_options_loading_animation', array(
				''              => esc_html__('None','ruby-build-framework'),
				'chasing-dots'  => esc_html__('Chasing Dots', 'ruby-build-framework'),
				'circle'        => esc_html__('Circle', 'ruby-build-framework'),
				'cube'          => esc_html__('Cube', 'ruby-build-framework'),
				'double-bounce' => esc_html__('Double Bounce', 'ruby-build-framework'),
				'fading-circle' => esc_html__('Fading Circle', 'ruby-build-framework'),
				'folding-cube'  => esc_html__('Folding Cube', 'ruby-build-framework'),
				'pulse'         => esc_html__('Pulse', 'ruby-build-framework'),
				'three-bounce'  => esc_html__('Three Bounce', 'ruby-build-framework'),
				'wave'          => esc_html__('Wave', 'ruby-build-framework'),
			));
		}

		/**
		 * Get Top Drawer Mode
		 *
		 * @return mixed|void
		 */
		public function get_top_drawer_mode()
		{
			return apply_filters('gsf_options_top_drawer_mode', array(
				'hide'   => esc_html__('Hide', 'ruby-build-framework'),
				'toggle' => esc_html__('Toggle', 'ruby-build-framework'),
				'show'   => esc_html__('Show', 'ruby-build-framework')
			));
		}

		/**
		 * Get Color Skin default
		 *
		 * @return mixed|void
		 */
		public function &get_color_skin_default()
		{
			$skin_default = array(
				array(
					'skin_id'          => 'skin-light',
					'skin_name'        => esc_html__('Light', 'ruby-build-framework'),
					'background_color' => '#fff',
					'text_color'       => '#666',
					'heading_color'    => '#333',
					'disable_color'    => '#a1a1a1',
					'border_color'     => '#eee',
					'text_hover_color' => '',
				),
				array(
					'skin_id'          => 'skin-dark',
					'skin_name'        => esc_html__('Dark', 'ruby-build-framework'),
					'background_color' => '#1f1f1f',
					'text_color'       => '#8d8d8d',
					'heading_color'    => '#fff',
					'disable_color'    => '#808080',
					'border_color'     => 'rgba(255,255,255,0.1)',
					'text_hover_color' => '',
				),
			);
			return $skin_default;
		}


		/**
		 * Get Color Skin
		 *
		 * @param bool $default
		 * @return array
		 */
		public function get_color_skin($default = false)
		{
			$skins = array();
			if ($default) {
				$skins[] = esc_html__('Inherit', 'ruby-build-framework');
			}
			$custom_color_skin = G5P()->optionsSkin()->get_color_skin();
			if (is_array($custom_color_skin)) {
				foreach ($custom_color_skin as $key => $value) {
					if (isset($value['skin_name']) && isset($value['skin_id'])) {
						$skins[$value['skin_id']] = $value['skin_name'];
					}

				}
			}
			return $skins;
		}

		public function getPresetPostType()
		{
			$settings = array(
				'page_404' => array(
					'title' => esc_html__('404 Page', 'ruby-build-framework')
				),
				'post'     => array(
					'title'  => esc_html__('Blog', 'ruby-build-framework'),
					'preset' => array(
						'blog'        => array(
							'title' => esc_html__('Blog Listing', 'ruby-build-framework'),
						),
						'single_blog' => array(
							'title'     => esc_html__('Single Blog', 'ruby-build-framework'),
							'is_single' => true,
						)
					)
				)
			);

			if (class_exists('WooCommerce')) {
				$settings = array_merge($settings, array(
					'product' => array(
						'title'  => esc_html__('Woocommerce', 'ruby-build-framework'),
						'preset' => array(
							'archive_product' => array(
								'title'      => esc_html__('Product Listing', 'ruby-build-framework'),
								'category'   => 'product_cat',
								'tag'        => 'product_tag',
								'is_archive' => true,
							),
							'single_product'  => array(
								'title'     => esc_html__('Single Product', 'ruby-build-framework'),
								'is_single' => true,
							)
						)
					)
				));
			}
			return apply_filters('gsf_options_preset', $settings);
		}

		public function get_custom_post_layout_settings()
		{
			$settings = array(
				'search' => array(
					'title' => esc_html__('Search Listing', 'ruby-build-framework')
				)
			);

			return apply_filters('gsf_options_custom_post_layout_settings', $settings);
		}
		
		public function get_social_networks_config()
		{
			$config_arr =  array(
				array(
					'id' => 'social_name',
					'title' => esc_html__('Title', 'ruby-build-framework'),
					'subtitle' => esc_html__('Enter your social network name', 'ruby-build-framework'),
					'type' => 'text',
				),
				array(
					'id' => 'social_id',
					'title' => esc_html__('Unique Social Id', 'ruby-build-framework'),
					'subtitle' => esc_html__('This value is created automatically and it shouldn\'t be edited unless you know what you are doing.', 'ruby-build-framework'),
					'type' => 'text',
					'input_type' => 'unique_id',
					'default' => 'social-'
				),
				array(
					'id' => 'social_icon',
					'title' => esc_html__('Social Network Icon', 'ruby-build-framework'),
					'subtitle' => esc_html__('Specify the social network icon', 'ruby-build-framework'),
					'type' => 'icon',
				),
				array(
					'id' => 'social_link',
					'title' => esc_html__('Social Network Link', 'ruby-build-framework'),
					'subtitle' => esc_html__('Enter your social network link', 'ruby-build-framework'),
					'type' => 'text',
				),
				array(
					'id' => 'social_color',
					'title' => esc_html__('Social Network Color', 'ruby-build-framework'),
					'subtitle' => sprintf(wp_kses_post(__('Specify the social network color. Reference in <a target="_blank" href="%s">brandcolors.net</a>', 'ruby-build-framework')), 'https://brandcolors.net/'),
					'type' => 'color'
				)
			);

			return $config_arr;
		}

		/**
		 * Get social networks default
		 *
		 * @return array
		 */
		public function get_social_networks_default()
		{
			$social_networks = array(
				array(
					'social_name'  => esc_html__('Facebook', 'ruby-build-framework'),
					'social_id'    => 'social-facebook',
					'social_icon'  => 'fa fa-facebook',
					'social_link'  => '',
					'social_color' => '#3b5998'
				),
				array(
					'social_name'  => esc_html__('Twitter', 'ruby-build-framework'),
					'social_id'    => 'social-twitter',
					'social_icon'  => 'fa fa-twitter',
					'social_link'  => '',
					'social_color' => '#1da1f2'
				),
				array(
					'social_name'  => esc_html__('Pinterest', 'ruby-build-framework'),
					'social_id'    => 'social-pinterest',
					'social_icon'  => 'fa fa-pinterest',
					'social_link'  => '',
					'social_color' => '#bd081c'
				),
				array(
					'social_name'  => esc_html__('Dribbble', 'ruby-build-framework'),
					'social_id'    => 'social-dribbble',
					'social_icon'  => 'fa fa-dribbble',
					'social_link'  => '',
					'social_color' => '#00b6e3'
				),
				array(
					'social_name'  => esc_html__('LinkedIn', 'ruby-build-framework'),
					'social_id'    => 'social-linkedIn',
					'social_icon'  => 'fa fa-linkedin',
					'social_link'  => '',
					'social_color' => '#0077b5'
				),
				array(
					'social_name'  => esc_html__('Vimeo', 'ruby-build-framework'),
					'social_id'    => 'social-vimeo',
					'social_icon'  => 'fa fa-vimeo',
					'social_link'  => '',
					'social_color' => '#1ab7ea'
				),
				array(
					'social_name'  => esc_html__('Tumblr', 'ruby-build-framework'),
					'social_id'    => 'social-tumblr',
					'social_icon'  => 'fa fa-tumblr',
					'social_link'  => '',
					'social_color' => '#35465c'
				),
				array(
					'social_name'  => esc_html__('Skype', 'ruby-build-framework'),
					'social_id'    => 'social-skype',
					'social_icon'  => 'fa fa-skype',
					'social_link'  => '',
					'social_color' => '#00aff0'
				),
				array(
					'social_name'  => esc_html__('Google+', 'ruby-build-framework'),
					'social_id'    => 'social-google-plus',
					'social_icon'  => 'fa fa-google-plus',
					'social_link'  => '',
					'social_color' => '#dd4b39'
				),
				array(
					'social_name'  => esc_html__('Flickr', 'ruby-build-framework'),
					'social_id'    => 'social-flickr',
					'social_icon'  => 'fa fa-flickr',
					'social_link'  => '',
					'social_color' => '#ff0084'
				),
				array(
					'social_name'  => esc_html__('YouTube', 'ruby-build-framework'),
					'social_id'    => 'social-youTube',
					'social_icon'  => 'fa fa-youtube',
					'social_link'  => '',
					'social_color' => '#cd201f'
				),
				array(
					'social_name'  => esc_html__('Foursquare', 'ruby-build-framework'),
					'social_id'    => 'social-foursquare',
					'social_icon'  => 'fa fa-foursquare',
					'social_link'  => '',
					'social_color' => '#f94877'
				),
				array(
					'social_name'  => esc_html__('Instagram', 'ruby-build-framework'),
					'social_id'    => 'social-instagram',
					'social_icon'  => 'fa fa-instagram',
					'social_link'  => '',
					'social_color' => '#405de6'
				),
				array(
					'social_name'  => esc_html__('GitHub', 'ruby-build-framework'),
					'social_id'    => 'social-gitHub',
					'social_icon'  => 'fa fa-github',
					'social_link'  => '',
					'social_color' => '#4078c0'
				),
				array(
					'social_name'  => esc_html__('Xing', 'ruby-build-framework'),
					'social_id'    => 'social-xing',
					'social_icon'  => 'fa fa-xing',
					'social_link'  => '',
					'social_color' => '#026466'
				),
				array(
					'social_name'  => esc_html__('Behance', 'ruby-build-framework'),
					'social_id'    => 'social-behance',
					'social_icon'  => 'fa fa-behance',
					'social_link'  => '',
					'social_color' => '#1769ff'
				),
				array(
					'social_name'  => esc_html__('Deviantart', 'ruby-build-framework'),
					'social_id'    => 'social-deviantart',
					'social_icon'  => 'fa fa-deviantart',
					'social_link'  => '',
					'social_color' => '#05cc47'
				),
				array(
					'social_name'  => esc_html__('Sound Cloud', 'ruby-build-framework'),
					'social_id'    => 'social-soundCloud',
					'social_icon'  => 'fa fa-soundcloud',
					'social_link'  => '',
					'social_color' => '#ff8800'
				),
				array(
					'social_name'  => esc_html__('Yelp', 'ruby-build-framework'),
					'social_id'    => 'social-yelp',
					'social_icon'  => 'fa fa-yelp',
					'social_link'  => '',
					'social_color' => '#af0606'
				),
				array(
					'social_name'  => esc_html__('RSS Feed', 'ruby-build-framework'),
					'social_id'    => 'social-rss',
					'social_icon'  => 'fa fa-rss',
					'social_link'  => '',
					'social_color' => '#f26522'
				),
				array(
					'social_name'  => esc_html__('VK', 'ruby-build-framework'),
					'social_id'    => 'social-vk',
					'social_icon'  => 'fa fa-vk',
					'social_link'  => '',
					'social_color' => '#45668e'
				),
				array(
					'social_name'  => esc_html__('Email', 'ruby-build-framework'),
					'social_id'    => 'social-email',
					'social_icon'  => 'fa fa-envelope',
					'social_link'  => '',
					'social_color' => '#4285f4'
				),

			);
			return $social_networks;
		}
		
		/**
		 * Get social networks default
		 *
		 * @return array
		 */
		public function get_social_networks_our_team_default()
		{
			$social_networks = array(
				array(
					'social_name'  => esc_html__('Facebook', 'ruby-build-framework'),
					'social_id'    => 'social-facebook',
					'social_icon'  => 'fa fa-facebook',
					'social_link'  => '',
					'social_color' => '#3b5998'
				),
				array(
					'social_name'  => esc_html__('Twitter', 'ruby-build-framework'),
					'social_id'    => 'social-twitter',
					'social_icon'  => 'fa fa-twitter',
					'social_link'  => '',
					'social_color' => '#1da1f2'
				),
				array(
					'social_name'  => esc_html__('Pinterest', 'ruby-build-framework'),
					'social_id'    => 'social-pinterest',
					'social_icon'  => 'fa fa-pinterest',
					'social_link'  => '',
					'social_color' => '#bd081c'
				),
				array(
					'social_name'  => esc_html__('Dribbble', 'ruby-build-framework'),
					'social_id'    => 'social-dribbble',
					'social_icon'  => 'fa fa-dribbble',
					'social_link'  => '',
					'social_color' => '#00b6e3'
				),
			);
			return $social_networks;
		}
		public function get_social_networks()
		{
			$social_networks = G5P()->options()->get_social_networks();
			$options = array();
			if (is_array($social_networks)) {
				foreach ($social_networks as $social_network) {
					$options[$social_network['social_id']] = $social_network['social_name'];
				}
			}
			return $options;
		}

		/**
		 * Get social share
		 *
		 * @return array
		 */
		public function get_social_share()
		{
			$social_share = array(
				'facebook'  => esc_html__('Facebook', 'ruby-build-framework'),
				'twitter'   => esc_html__('Twitter', 'ruby-build-framework'),
				'google'    => esc_html__('Google +', 'ruby-build-framework'),
				'linkedin'  => esc_html__('Linkedin', 'ruby-build-framework'),
				'tumblr'    => esc_html__('Tumblr', 'ruby-build-framework'),
				'pinterest' => esc_html__('Pinterest', 'ruby-build-framework'),
				'email'     => esc_html__('Email', 'ruby-build-framework'),
				'telegram'  => esc_html__('Telegram', 'ruby-build-framework'),
				'whatsapp'  => esc_html__('WhatsApp', 'ruby-build-framework')
			);
			return $social_share;
		}

		/**
		 * Get Post Layout
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_post_layout($inherit = false)
		{
			$config = apply_filters('gsf_options_post_layout', array(
				'large-image'    => array(
					'label' => esc_html__('Large Image', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-large-image.png'),
				),
				'grid'           => array(
					'label' => esc_html__('Grid', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-grid.png'),
				),
				'masonry'        => array(
					'label' => esc_html__('Masonry', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-masonry.png'),
				)
			));
			if ($inherit) {
				$config = array(
						'' => array(
							'label' => esc_html__('Inherit', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						),
					) + $config;
			}
			return $config;
		}

		public function get_single_post_layout($inherit = false)
		{
			$config = apply_filters('gsf_options_single_post_layout', array(
				'layout-1' => array(
					'label' => esc_html__('Layout 1', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/post-layout-1.png'),
				),
				'layout-2' => array(
					'label' => esc_html__('Layout 2', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/post-layout-2.png'),
				),
				/*
				 * 'layout-2' => array(
					'label' => esc_html__('Layout 2', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/post-layout-2.png'),
				),
				'layout-4' => array(
					'label' => esc_html__('Layout 4', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/post-layout-4.png'),
				),
				'layout-5' => array(
					'label' => esc_html__('Layout 5', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/post-layout-5.png'),
				),*/

			));
			if ($inherit) {
				$config = array(
						'' => array(
							'label' => esc_html__('Inherit', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						),
					) + $config;
			}
			return $config;
		}

		/**
		 * Get Post Columns
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_post_columns($inherit = false)
		{
			$config = apply_filters('gsf_options_post_columns', array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
                '5' => '5',
                '4' => '4',
				'6' => '6'
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;
		}

		/**
		 * Get Post Columns Gap
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_post_columns_gutter($inherit = false)
		{
			$config = apply_filters('gsf_options_post_columns_gutter', array(
				'none'  => esc_html__('None', 'ruby-build-framework'),
				'10' => '10px',
				'20' => '20px',
				'30' => '30px'
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;
		}

		/**
		 * Get Post Paging Mode
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_post_paging_mode($inherit = false)
		{
			$config = apply_filters('gsf_options_post_paging_mode', array(
				'pagination'      => esc_html__('Pagination', 'ruby-build-framework'),
				'pagination-ajax' => esc_html__('Ajax - Pagination', 'ruby-build-framework'),
				'next-prev'       => esc_html__('Ajax - Next Prev', 'ruby-build-framework'),
				'load-more'       => esc_html__('Ajax - Load More', 'ruby-build-framework'),
				'infinite-scroll' => esc_html__('Ajax - Infinite Scroll', 'ruby-build-framework')
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;
		}

		public function get_post_paging_small_mode($inherit = false)
		{
			$config = apply_filters('gsf_options_post_paging_small_mode', array(
				'none'            => esc_html__('None', 'ruby-build-framework'),
				'pagination-ajax' => esc_html__('Ajax - Pagination', 'ruby-build-framework'),
				'next-prev'       => esc_html__('Ajax - Next Prev', 'ruby-build-framework'),
				'load-more'       => esc_html__('Ajax - Load More', 'ruby-build-framework'),
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;
		}

		/**
		 * Get Animation
		 *
		 * @param $inherit
		 * @return array|mixed|void
		 */
		public function get_animation($inherit = false)
		{
			$config = apply_filters('gsf_options_animation', array(
				'none'          => esc_html__('None', 'ruby-build-framework'),
				'top-to-bottom' => esc_html__('Top to bottom', 'ruby-build-framework'),
				'bottom-to-top' => esc_html__('Bottom to top', 'ruby-build-framework'),
				'left-to-right' => esc_html__('Left to right', 'ruby-build-framework'),
				'right-to-left' => esc_html__('Right to left', 'ruby-build-framework'),
				'appear'        => esc_html__('Appear from center', 'ruby-build-framework')
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;
		}

		/**
		 * Get Related Post Algorithm
		 *
		 * @param bool $inherit
		 * @return array|mixed|void
		 */
		public function get_related_post_algorithm($inherit = false)
		{
			$config = apply_filters('gsf_options_related_post_algorithm', array(
				'cat'            => esc_html__('by Category', 'ruby-build-framework'),
				'tag'            => esc_html__('by Tag', 'ruby-build-framework'),
				'author'         => esc_html__('by Author', 'ruby-build-framework'),
				'cat-tag'        => esc_html__('by Category & Tag', 'ruby-build-framework'),
				'cat-tag-author' => esc_html__('by Category & Tag & Author', 'ruby-build-framework'),
				'random'         => esc_html__('Randomly', 'ruby-build-framework')
			));

			if ($inherit) {
				$config = array(
						'' => esc_html__('Inherit', 'ruby-build-framework')
					) + $config;
			}

			return $config;

		}

        /**
         * Get Related Product Algorithm
         *
         * @param bool $inherit
         * @return array|mixed|void
         */
        public function get_related_product_algorithm()
        {
            $config = apply_filters('gsf_options_related_product_algorithm', array(
                'cat'            => esc_html__('by Category', 'ruby-build-framework'),
                'tag'            => esc_html__('by Tag', 'ruby-build-framework'),
                'cat-tag'        => esc_html__('by Category & Tag', 'ruby-build-framework')
            ));
            return $config;

        }


        public function get_product_catalog_layout($inherit = false)
        {
            $config = apply_filters('gsf_options_product_catalog_layout', array(
                'grid' => array(
                    'label' => esc_html__('Grid', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/shop-grid.jpg'),
                ),
            ));
            if ($inherit) {
                $config = array(
                        '' => array(
                            'label' => esc_html__('Inherit', 'ruby-build-framework'),
                            'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
                        ),
                    ) + $config;
            }
            return $config;
        }

        public function get_product_single_layout($inherit = false)
        {
            $config = apply_filters('gsf_options_product_single_layout', array(
                'layout-01' => array(
                    'label' => esc_html__('Layout 01', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/product-single-01.jpg'),
                ),
                /*'layout-02' => array(
                    'label' => esc_html__('Layout 02', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/product-single-02.jpg'),
                ),
                'layout-03' => array(
                    'label' => esc_html__('Layout 03', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/product-single-03.jpg'),
                )*/
            ));
            if ($inherit) {
                $config = array(
                        '' => array(
                            'label' => esc_html__('Inherit', 'ruby-build-framework'),
                            'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
                        ),
                    ) + $config;
            }
            return $config;
        }

        public function get_product_image_hover_effect($inherit = false)
        {
            $config = apply_filters('gsf_product_image_hover_effect',array(
                'none' => esc_html__('None','ruby-build-framework'),
                'change-image' => esc_html__('Change Image','ruby-build-framework'),
                'flip-back' => esc_html__('Flip Back','ruby-build-framework')
            ));

            if ($inherit) {
                $config = array(
                        '' => esc_html__('Inherit', 'ruby-build-framework')
                    ) + $config;
            }

            return $config;
        }

        public function get_portfolio_hover_effect($inherit = false)
        {
            $config = apply_filters('gsf_portfolio_hover_effect',array(
                'none' => esc_html__('None','ruby-build-framework'),
                'suprema' => esc_html__('Suprema','ruby-build-framework'),
                'layla' => esc_html__('Layla','ruby-build-framework'),
                'bubba' => esc_html__('Bubba','ruby-build-framework'),
                'jazz' => esc_html__('Jazz','ruby-build-framework')
            ));

            if ($inherit) {
                $config = array(
                        '' => esc_html__('Inherit', 'ruby-build-framework')
                    ) + $config;
            }

            return $config;
        }

        public function get_portfolio_layout($inherit = false)
        {
            $config = apply_filters('gsf_options_portfolio_layout', array(
                'grid' => array(
                    'label' => esc_html__('Grid', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-grid.png'),
                ),
                'masonry' => array(
                    'label' => esc_html__('Masonry', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-masonry.png'),
                ),
                'metro-1' => array(
                    'label' => esc_html__('Metro 1', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-metro-1.png'),
                ),
                'metro-2' => array(
                    'label' => esc_html__('Metro 2', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-metro-2.png'),
                ),
                'metro-3' => array(
                    'label' => esc_html__('Metro 3', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-metro-3.png'),
                ),
                'metro-4' => array(
                    'label' => esc_html__('Metro 4', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-metro-4.png'),
                ),
                'metro-5' => array(
                    'label' => esc_html__('Metro 5', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-metro-5.png'),
                ),
                'carousel-3d' => array(
                    'label' => esc_html__('Carousel 3D', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-3d-carousel.png'),
                ),
            ));
            if ($inherit) {
                $config = array(
                        '' => array(
                            'label' => esc_html__('Inherit', 'ruby-build-framework'),
                            'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
                        ),
                    ) + $config;
            }
            return $config;
        }
        public function get_portfolio_details_default()
        {
            $configs = array(
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Client','ruby-build-framework'),
                    'id'  => 'portfolio_details_client',
                ),
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Location','ruby-build-framework'),
                    'id'  => 'portfolio_details_location',
                ),
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Gross Building Area','ruby-build-framework'),
                    'id'  => 'portfolio_details_gross_building_area',
                ),
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Year Completed','ruby-build-framework'),
                    'id'  => 'portfolio_details_year_completed',
                ),
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Value','ruby-build-framework'),
                    'id'  => 'portfolio_details_value',
                ),
                array(
                    'type'  => 'text',
                    'title'    => esc_html__('Architect','ruby-build-framework'),
                    'id'  => 'portfolio_details_architect',
                ),

            );
            return apply_filters('gsf_portfolio_details_default',$configs);
        }
		
		public function get_our_team_layout($inherit = false)
		{
			$config = apply_filters('gsf_our_team_portfolio_layout', array(
				'grid' => array(
					'label' => esc_html__('Grid', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-grid.png'),
				),
				'masonry' => array(
					'label' => esc_html__('Masonry', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-masonry.png'),
				),
				'list' => array(
					'label' => esc_html__('List', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/our-team-list.png'),
				),
			));
			if ($inherit) {
				$config = array(
						'' => array(
							'label' => esc_html__('Inherit', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						),
					) + $config;
			}
			return $config;
		}
		
		public function get_our_service_layout($inherit = false)
		{
			$config = apply_filters('gsf_our_service_portfolio_layout', array(
				'grid' => array(
					'label' => esc_html__('Grid', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-grid.png'),
				),
				'masonry' => array(
					'label' => esc_html__('Masonry', 'ruby-build-framework'),
					'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-masonry.png'),
				),
			));
			if ($inherit) {
				$config = array(
						'' => array(
							'label' => esc_html__('Inherit', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
						),
					) + $config;
			}
			return $config;
		}

        public function get_image_ratio($inherit = false)
        {
            $config = apply_filters('gsf_options_image_ratio', array(
                '1x1' => '1:1',
                '4x3' => '4:3',
                '3x4' => '3:4',
                '16x9' => '16:9',
                '9x16' => '9:16',
                'custom' => esc_html__('Custom','ruby-build-framework')
            ));
            if ($inherit) {
                $config = array(
                        '' => esc_html__('Inherit', 'ruby-build-framework'),
                    ) + $config;
            }
            return $config;
        }

        public function get_single_portfolio_layout($inherit = false)
        {
            $config = apply_filters('gsf_options_single_portfolio_layout', array(
                'layout-1' => array(
                    'label' => esc_html__('Layout 1', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/single-portfolio-layout-1.png'),
                ),
                'layout-2' => array(
                    'label' => esc_html__('Layout 2', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/single-portfolio-layout-2.png'),
                ),
                'layout-3' => array(
                    'label' => esc_html__('Layout 3', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/single-portfolio-layout-3.png'),
                ),
                'layout-4' => array(
                    'label' => esc_html__('Layout 4', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/single-portfolio-layout-4.png'),
                ),
                'layout-5' => array(
                    'label' => esc_html__('Layout 5', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/single-portfolio-layout-5.png'),
                ),

            ));
            if ($inherit) {
                $config = array(
                        '' => array(
                            'label' => esc_html__('Inherit', 'ruby-build-framework'),
                            'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
                        ),
                    ) + $config;
            }
            return $config;
        }

        public function get_single_portfolio_gallery_layout($inherit = false)
        {
            $config = apply_filters('gsf_options_single_portfolio_gallery_layout', array(
                'carousel' => array(
                    'label' => esc_html__('Slider', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-gallery-carousel.png'),
                ),
                'thumbnail' => array(
                    'label' => esc_html__('Gallery', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-gallery-thumbnail.png'),
                ),
                'carousel-center' => array(
                    'label' => esc_html__('Slider Center', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-gallery-carousel-center.png'),
                ),
                'grid' => array(
                    'label' => esc_html__('Grid', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-gallery-grid.png'),
                ),
                'carousel-3d' => array(
                    'label' => esc_html__('Slider 3D', 'ruby-build-framework'),
                    'img'   => G5P()->pluginUrl('assets/images/theme-options/portfolio-3d-carousel.png'),
                )
            ));
            if ($inherit) {
                $config = array(
                        '' => array(
                            'label' => esc_html__('Inherit', 'ruby-build-framework'),
                            'img'   => G5P()->pluginUrl('assets/images/theme-options/default.png'),
                        ),
                    ) + $config;
            }
            return $config;
        }

        public function get_portfolio_related_algorithm($inherit = false)
        {
            $config = apply_filters('gsf_options_portfolio_related_algorithm', array(
                'cat'            => esc_html__('by Category', 'ruby-build-framework'),
                'author'         => esc_html__('by Author', 'ruby-build-framework'),
                'cat-author' => esc_html__('by Category & Author', 'ruby-build-framework'),
                'random'         => esc_html__('Randomly', 'ruby-build-framework')
            ));

            if ($inherit) {
                $config = array(
                        '' => esc_html__('Inherit', 'ruby-build-framework')
                    ) + $config;
            }

            return $config;

        }
	}
}