<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (!class_exists('G5P_Inc_Our_Service')) {
	class G5P_Inc_Our_Service
	{
		private static $_instance;
		
		public static function getInstance()
		{
			if (self::$_instance == NULL) {
				self::$_instance = new self();
			}
			
			return self::$_instance;
		}
		
		private $_permalink_optionKey = 'gsf_permalink';
		private $_permalink_post_type_base = 'gsf_our_service_base';
		private $_permalink_category_base = 'gsf_our_service_cat_base';
		//private $_permalink_tag_base = 'gsf_portfolio_tag_base';
		
		private $_permalinks = array();
		
		private $_post_type = 'our_service';
		private $_taxonomy_category = 'our_service_cat';
		
		//private $_taxonomy_tag = 'portfolio_tag';
		
		public function get_post_type()
		{
			return $this->_post_type;
		}
		
		public function get_taxonomy_category()
		{
			return $this->_taxonomy_category;
		}
		
		/*public function get_taxonomy_tag()
		{
			return $this->_taxonomy_tag;
		}*/
		
		public function init()
		{
			$this->_permalinks = $this->get_permalink();

            add_filter('gsf_shorcodes', array($this, 'register_shortcode'));
			//--
			add_filter('g5plus_ruby_build_page_title', array($this, 'page_title'));
			add_action('admin_init', array($this, 'register_permalink'));
			add_action('load-options-permalink.php', array($this, 'save_permalink'));
			
			//--
			// register post-type
			add_filter('gsf_register_post_type', array($this, 'register_post_type'));
			// register taxonomy
			add_filter('gsf_register_taxonomy', array($this, 'register_taxonomy'));
			
			//---
			// add filter category
			add_action('restrict_manage_posts', array($this, 'add_category_filter'));
			add_filter('parse_query', array($this, 'add_category_filter_query'));
			
			//---
			// custom columns all our service
			add_filter("manage_{$this->_post_type}_posts_columns", array($this, 'custom_columns_heading'));
			add_filter("manage_{$this->_post_type}_posts_custom_column", array($this, 'custom_columns'), 10, 2);
			
			//---
			add_action('admin_enqueue_scripts', array($this, 'adminAssets'));
			
			//-- Done
			// Admin bar menus
			if (apply_filters('gsf_show_admin_bar_visit_our_service', true)) {
				add_action('admin_bar_menu', array($this, 'admin_bar_menus'), 32);
			}
			
			//--Done
			//Preset
			add_filter('gsf_options_preset', array($this, 'options_preset'));
			
			// Defined MetaBox
			add_filter('gsf_page_setting_post_type', array($this, 'page_setting'));
			
			// Change Post Per Pages
			add_action('pre_get_posts', array($this, 'change_post_per_page'), 6);
		}

        public function register_shortcode($shortcodes) {
            $shortcodes = array_merge($shortcodes, array(
                'gsf_our_service'
            ));
            sort($shortcodes);
            return $shortcodes;
        }
		
		/*Done*/
		public function adminAssets($hook)
		{
			global $post;
			if ((($hook === 'post-new.php') || ($hook === 'post.php') || ($hook === 'edit.php'))
				&& isset($post)
				&& isset($post->post_type)
				&& ($post->post_type === $this->_post_type)
			) {
				wp_enqueue_style(G5P()->assetsHandle('admin-portfolio'));
			}
		}
		
		/*Done*/
		/**
		 * Register Post Type
		 *
		 * @param $post_types
		 * @return mixed
		 */
		public function register_post_type($post_types)
		{
			$post_types [$this->_post_type] = array(
				'label'         => esc_html__('Services', 'ruby-build-framework'),
				'singular_name' => esc_html__('Services', 'ruby-build-framework'),
				'menu_icon'     => 'dashicons-format-image',
				'menu_position' => 25,
				'rewrite'       => array('slug' => $this->_permalinks['post_type_slug']),
			);
			
			return $post_types;
		}
		/*Done*/
		/**
		 * Register Taxonomies
		 *
		 * @param $taxonomies
		 * @return mixed
		 */
		public function register_taxonomy($taxonomies)
		{
			$taxonomies[$this->_taxonomy_category] = array(
				'post_type'         => $this->_post_type,
				'label'             => esc_html__('Categories', 'ruby-build-framework'),
				'name'              => esc_html__('Services Categories', 'ruby-build-framework'),
				'singular_name'     => esc_html__('Category', 'ruby-build-framework'),
				'rewrite'           => array('slug' => $this->_permalinks['category_slug']),
				'show_admin_column' => true,
			);
			
			/*$taxonomies[$this->_taxonomy_tag] = array(
				'post_type'         => $this->_post_type,
				'label'             => esc_html__('Tags', 'ruby-build-framework'),
				'name'              => esc_html__('Project Tags', 'ruby-build-framework'),
				'singular_name'     => esc_html__('Tag', 'ruby-build-framework'),
				'hierarchical'      => false,
				'rewrite'           => array('slug' => $this->_permalinks['tag_slug']),
				'show_admin_column' => true,
			);*/
			
			return $taxonomies;
		}
		
		/*Done*/
		public function add_category_filter()
		{
			global $typenow;
			if ($typenow === $this->_post_type) {
				$selected = isset($_GET[$this->_taxonomy_category]) ? $_GET[$this->_taxonomy_category] : '';
				$info_taxonomy = get_taxonomy($this->_taxonomy_category);
				wp_dropdown_categories(array(
					'show_option_all' => sprintf(esc_html__('Show All %s', 'ruby-build-framework'), $info_taxonomy->label),
					'taxonomy'        => $this->_taxonomy_category,
					'name'            => $this->_taxonomy_category,
					'orderby'         => 'name',
					'selected'        => $selected,
					'show_count'      => true,
					'hide_empty'      => true,
					'hide_if_empty'   => true
				));
			}
		}
		
		/*Done*/
		public function add_category_filter_query($query)
		{
			global $pagenow;
			$q_vars = &$query->query_vars;
			if ($pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $this->_post_type && isset($q_vars[$this->_taxonomy_category]) && is_numeric($q_vars[$this->_taxonomy_category]) && $q_vars[$this->_taxonomy_category] != 0) {
				$term = get_term_by('id', $q_vars[$this->_taxonomy_category], $this->_taxonomy_category);
				$q_vars[$this->_taxonomy_category] = $term->slug;
			}
		}
		
		/*Done*/
		public function register_permalink()
		{
			add_settings_field(
				$this->_permalink_post_type_base,
				esc_html__('Services base', 'ruby-build-framework'),
				array($this, 'permalink_post_type_base_callback'),
				'permalink',
				'optional'
			);
			
			add_settings_field(
				$this->_permalink_category_base,
				esc_html__('Services category base', 'ruby-build-framework'),
				array($this, 'permalink_cat_callback'),
				'permalink',
				'optional'
			);
			
			/*add_settings_field(
				$this->_permalink_tag_base,
				esc_html__('Our service tag base','ruby-build-framework'),
				array( $this, 'permalink_tag_callback' ),
				'permalink',
				'optional'
			);*/
			
			
		}
		/*Done*/
		public function permalink_post_type_base_callback()
		{
			?>
			<input type="text" name="<?php echo esc_attr($this->_permalink_post_type_base) ?>" placeholder="services"
				   class="regular-text code" value="<?php echo esc_attr($this->_permalinks['post_type_base']) ?>">
			<?php
		}
		
		/*Done*/
		public function permalink_cat_callback()
		{
			?>
			<input type="text" name="<?php echo esc_attr($this->_permalink_category_base) ?>"
				   placeholder="services-category" class="regular-text code"
				   value="<?php echo esc_attr($this->_permalinks['category_base']) ?>">
			<?php
		}
		
		/*Done*/
		public function get_permalink()
		{
			$permalinks = wp_parse_args((array)get_option($this->_permalink_optionKey, array()), array(
				'post_type_base' => '',
				'category_base'  => '',
				//'tag_base'       => '',
			));
			
			// Ensure rewrite slugs are set.
			$permalinks['post_type_slug'] = untrailingslashit(empty($permalinks['post_type_base']) ? _x('our-service', 'slug', 'ruby-build-framework') : $permalinks['post_type_base']);
			$permalinks['category_slug'] = untrailingslashit(empty($permalinks['category_base']) ? _x('our-service-category', 'slug', 'ruby-build-framework') : $permalinks['category_base']);
			//$permalinks['tag_slug'] = untrailingslashit(empty($permalinks['tag_base']) ? _x('project-tag', 'slug', 'ruby-build-framework') : $permalinks['tag_base']);
			return $permalinks;
		}
		
		/*Done*/
		public function save_permalink()
		{
			if (!is_admin()) {
				return;
			}
			if (isset($_POST['permalink_structure'])) {
				$permalinks = (array)get_option($this->_permalink_optionKey, array());
				$permalinks['post_type_base'] = sanitize_title_with_dashes(trim($_POST[$this->_permalink_post_type_base]));
				$permalinks['category_base'] = sanitize_title_with_dashes(trim($_POST[$this->_permalink_category_base]));
				//$permalinks['tag_base'] = sanitize_title_with_dashes(trim($_POST[$this->_permalink_tag_base]));
				update_option($this->_permalink_optionKey, $permalinks);
			}
		}
		
		/*Done*/
		public function custom_columns_heading($columns)
		{
			$myCustomColumns['cb'] = $columns['cb'];
			$myCustomColumns['thumbnail'] = "<span class='gsf-columns-icon dashicons dashicons-format-image'></span>";
			esc_html__('Thumbnail', 'ruby-build-framework');
			$myCustomColumns['title'] = $columns['title'];
			$myCustomColumns['taxonomy-' . $this->_taxonomy_category] = esc_html__('Categories', 'ruby-build-framework');
			//$myCustomColumns['taxonomy-' . $this->_taxonomy_tag] = esc_html__('Tags', 'ruby-build-framework');
			$myCustomColumns['date'] = $columns['date'];
			return $myCustomColumns;
		}
		
		/*Done*/
		public function custom_columns($columns, $post_id)
		{
			if (($columns === 'thumbnail') && has_post_thumbnail($post_id)) {
				echo '<a href="' . esc_url(get_edit_post_link($post_id)) . '">';
				the_post_thumbnail('thumbnail');
				echo '</a>';
			}
		}
		
		/*Done*/
		public function admin_bar_menus($wp_admin_bar)
		{
			if (!is_admin() || !is_user_logged_in()) {
				return;
			}
			
			if (!is_user_member_of_blog() && !is_super_admin()) {
				return;
			}
			
			$wp_admin_bar->add_node(array(
				'parent' => 'site-name',
				'id'     => 'g5p-view-our-service',
				'title'  => esc_html__('Visit Services', 'ruby-build-framework'),
				'href'   => get_post_type_archive_link($this->_post_type)
			));
		}
		
		/*Done*/
		public function options_preset($settings)
		{
			$settings[$this->_post_type] = array(
				'title'  => esc_html__('Services', 'ruby-build-framework'),
				'preset' => array(
					'archive_our_service' => array(
						'title'      => esc_html__('Services Listing', 'ruby-build-framework'),
						'category'   => $this->_taxonomy_category,
						//'tag'        => $this->_taxonomy_tag,
						'is_archive' => true,
					),
					'single_our_service'  => array(
						'title'     => esc_html__('Single Services', 'ruby-build-framework'),
						'is_single' => true,
					)
				)
			);
			return $settings;
		}
		
		/* Done*/
		public function change_post_per_page($q)
		{
			if (!is_admin() && $q->is_main_query() && ($q->is_post_type_archive($this->_post_type) || $q->is_tax(get_object_taxonomies($this->_post_type)))) {
				$our_service_per_page = intval(G5P()->options()->get_our_service_per_page());
				$our_service_per_page_custom = intval(isset($_GET['posts_per_page']) ? $_GET['posts_per_page'] : '');
				if ($our_service_per_page_custom > 0 || $our_service_per_page_custom == -1) {
					$our_service_per_page = $our_service_per_page_custom;
				}
				if ($our_service_per_page > 0 || $our_service_per_page == -1) {
					$q->set('posts_per_page', $our_service_per_page);
				}
			}
		}
		
		public function page_setting($post_type)
		{
			$post_type[] = $this->_post_type;
			return $post_type;
		}
		
		public function page_title($page_title)
		{
			if (is_post_type_archive('our_service')) {
				if (!$page_title) {
					$page_title = get_the_archive_title();
					$index = strpos($page_title, ':');
					$page_title= substr($page_title,$index+1);
				}
				$custom_page_title = G5P()->metaBox()->get_page_title_content();
				if ($custom_page_title) {
					$page_title = $custom_page_title;
				}
				
			} elseif (is_singular('our_service')) {
				global $single_service_title;
				$page_title = get_the_title(get_the_ID());
				$single_service_title = $page_title;
			}
			return $page_title;
		}
		
	}
}