<?php
if (!class_exists('G5P_Inc_Options_Skin')) {
	class G5P_Inc_Options_Skin
	{
		private static $_instance;

		public static function getInstance()
		{
			if (self::$_instance == NULL) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}
		
		public function get_color_skin(){ return $this->getOptions('color_skin'); }
		public function getOptions($key) {
			if (function_exists('GSF')) {
				$option = &GSF()->adminThemeOption()->getOptions('gsf_ruby_build_skin_options');
			} else {
				$option = &$this->getDefault();
			}
			if (isset($option[$key])) {
				return $option[$key];
			}
			$option = &$this->getDefault();
			if (isset($option[$key])) {
				return $option[$key];
			}
			return '';
		}
		
		public function setOptions($key, $value) {
			if (function_exists('GSF')) {
				$option = &GSF()->adminThemeOption()->getOptions('gsf_ruby_build_skin_options');
			} else {
				$option = &$this->getDefault();
			}
			$option[$key] = $value;
		}
		
		public function &getDefault() {
			$default = array (
				'color_skin' =>
					array (
						0 =>
							array (
								'skin_id' => 'skin-light',
								'skin_name' => 'Light',
								'background_color' => '#fff',
								'text_color' => '#666',
								'heading_color' => '#333',
								'disable_color' => '#a1a1a1',
								'border_color' => '#eee',
								'text_hover_color' => '',
							),
						1 =>
							array (
								'skin_id' => 'skin-dark',
								'skin_name' => 'Dark',
								'background_color' => '#1f1f1f',
								'text_color' => '#8d8d8d',
								'heading_color' => '#fff',
								'disable_color' => '#808080',
								'border_color' => 'rgba(255,255,255,0.1)',
								'text_hover_color' => '',
							),
					),
			);
			return $default;
		}
	}
}