<?php
if (!defined('ABSPATH')) {
    exit('Direct script access denied.');
}

if (!class_exists('G5P_Inc_Config_Meta_Boxes')) {
    class G5P_Inc_Config_Meta_Boxes
    {
	    /*
	 * loader instances
	 */
	    private static $_instance;

	    public static function getInstance()
	    {
		    if (self::$_instance == NULL) {
			    self::$_instance = new self();
		    }

		    return self::$_instance;
	    }

        public function init()
        {
            // Defined Theme Options
            add_filter('gsf_meta_box_config', array($this, 'register_meta_boxes'));
        }

	    public function getPostType() {
		    return apply_filters('gsf_page_setting_post_type', array('page'));
	    }

        public function register_meta_boxes($configs)
        {
            $prefix = G5P()->getMetaPrefix();

            /**
             * CUSTOM PAGE SETTINGS
             */
            $configs['gsf_page_setting'] = array(
                'name' => esc_html__('Page Settings', 'ruby-build-framework'),
                'post_type' => $this->getPostType(),
                'layout' => 'inline',
                'section' => array(
                    array(
                        'id' =>  "{$prefix}section_general",
                        'title' => esc_html__('Layout', 'ruby-build-framework'),
                        'icon' => 'dashicons dashicons-editor-table',
                        'fields' => array(
                            G5P()->configOptions()->get_config_preset(array('id' => "{$prefix}page_preset")),
                            array(
                                'id' => "{$prefix}group_layout",
                                'type' => 'group',
                                'title' => esc_html__('Layout','ruby-build-framework'),
                                'fields' => array(
                                    array(
                                        'id' => "{$prefix}main_layout",
                                        'title' => esc_html__('Site Layout', 'ruby-build-framework'),
                                        'type' => 'image_set',
                                        'options' => G5P()->settings()->get_main_layout(true),
                                        'default' => '',
                                    ),

                                    G5P()->configOptions()->get_config_toggle(array(
                                        'id' => "{$prefix}content_full_width",
                                        'title' => esc_html__('Content Full Width', 'ruby-build-framework'),
                                        'subtitle' => esc_html__('Turn On this option if you want to expand the content area to full width.', 'ruby-build-framework'),
                                        'default' => '',
                                    ),true),

                                    G5P()->configOptions()->get_config_toggle(array(
                                        'id' => "{$prefix}custom_content_padding",
                                        'title' => esc_html__('Custom Content Padding','ruby-build-framework'),
                                        'subtitle' => esc_html__('Turn On this option if you want to custom content padding.', 'ruby-build-framework'),
                                        'default' => ''
                                    )),

                                    array(
                                        'id' => "{$prefix}content_padding",
                                        'title' => esc_html__('Content Padding', 'ruby-build-framework'),
                                        'subtitle' => esc_html__('Set content padding', 'ruby-build-framework'),
                                        'type' => 'spacing',
                                        'default' => array('left' => 0, 'right' => 0, 'top' => 50, 'bottom' => 50),
                                        'required' => array("{$prefix}custom_content_padding",'=','on')
                                    ),

                                    G5P()->configOptions()->get_config_sidebar_layout(array(
                                        'id' => "{$prefix}sidebar_layout",
                                    ),true),
                                    G5P()->configOptions()->get_config_sidebar(array(
                                        'id' => "{$prefix}sidebar",
                                        'required' => array("{$prefix}sidebar_layout",'!=','none')
                                    )),
                                )
                            ),

                            array(
                                'id' => "{$prefix}group_page_title",
                                'type' => 'group',
                                'title' => esc_html__('Page Title','ruby-build-framework'),
                                'fields' => array(
                                    G5P()->configOptions()->get_config_toggle(array(
                                        'title' => esc_html__('Page Title Enable','ruby-build-framework'),
                                        'id' => "{$prefix}page_title_enable"
                                    ),true),
                                    G5P()->configOptions()->get_config_content_block(array(
                                        'id' => "{$prefix}page_title_content_block",
                                        'desc' => esc_html__('Specify the Content Block to use as a page title content.', 'ruby-build-framework'),
                                        'required' => array("{$prefix}page_title_enable", '!=', 'off')
                                    ),true),

                                    array(
                                        'title'       => esc_html__('Custom Page title', 'ruby-build-framework'),
                                        'id'          => "{$prefix}page_title_content",
                                        'type'        => 'text',
                                        'default'     => '',
                                        'required' => array("{$prefix}page_title_enable", '!=', 'off'),
                                        'desc'        => esc_html__('Enter custom page title for this page', 'ruby-build-framework')
                                    )
                                )
                            ),
                            array(
                                'title'        => esc_html__('Custom Css Class', 'ruby-build-framework'),
                                'id'          => "{$prefix}css_class",
                                'type'        => 'selectize',
                                'tags' => true,
                                'default'         => '',
                                'desc'        => esc_html__('Enter custom class for this page', 'ruby-build-framework')
                            )
                        )
                    ),
                    array(
                        'id' => "{$prefix}section_menu",
                        'title' => esc_html__('Menu', 'ruby-build-framework'),
                        'icon' => 'dashicons dashicons-menu',
                        'fields' => array(
                            array(
                                'id' => "{$prefix}page_menu",
                                'title' => esc_html__('Page Menu', 'ruby-build-framework'),
                                'type' => 'selectize',
                                'allow_clear' => true,
                                'placeholder' => esc_html__('Select Menu', 'ruby-build-framework'),
                                'desc' => esc_html__('Optionally you can choose to override the menu that is used on the page', 'ruby-build-framework'),
                                'data' => 'menu'
                            ),
                            array(
                                'id' => "{$prefix}page_mobile_menu",
                                'title' => esc_html__('Page Mobile Menu', 'ruby-build-framework'),
                                'type' => 'selectize',
                                'allow_clear' => true,
                                'placeholder' => esc_html__('Select Menu', 'ruby-build-framework'),
                                'desc' => esc_html__('Optionally you can choose to override the menu mobile that is used on the page', 'ruby-build-framework'),
                                'data' => 'menu'
                            ),
                            G5P()->configOptions()->get_config_toggle(array(
                                'id' => "{$prefix}is_one_page",
                                'title' => esc_html__('Is One Page', 'ruby-build-framework'),
                                'desc' => esc_html__('Set page style is One Page', 'ruby-build-framework'),
                            ))
                        )
                    ),

                ),
            );


	        /**
	         * CUSTOME POST SETTING
	         */
	        $configs['gsf_post_setting'] = array(
		        'name' => esc_html__('Post Settings', 'ruby-build-framework'),
		        'post_type' => array('post'),
		        'layout' => 'inline',
		        'section' => array(
			        array(
                        'id' => "{$prefix}section_post_general",
                        'title' => esc_html__('General', 'ruby-build-framework'),
                        'icon' => 'dashicons dashicons-admin-site',
				        'fields' => array(
                            array(
                                'id' => "gf_format_video_embed",
                                'title' => esc_html__('Featured Video/Audio Code','ruby-build-framework'),
                                'subtitle' => esc_html__('Paste YouTube, Vimeo or self hosted video URL then player automatically will be generated.','ruby-build-framework'),
                                'type' => 'textarea'
                            ),
                            array(
                                'id' => "gf_format_audio_embed",
                                'title' => esc_html__('Featured Video/Audio Code','ruby-build-framework'),
                                'subtitle' => esc_html__('Paste YouTube, Vimeo or self hosted video URL then player automatically will be generated.','ruby-build-framework'),
                                'type' => 'textarea'
                            ),
                            array(
                                'id' => "gf_format_gallery_images",
                                'title' => esc_html__('Featured Gallery','ruby-build-framework'),
                                'subtitle' => esc_html__('Select images for featured gallery. (Apply for post format gallery)','ruby-build-framework'),
                                'type' => 'gallery'
                            ),
                            array(
                                'id' => "gf_format_link_text",
                                'title' => esc_html__('Featured Link Text','ruby-build-framework'),
                                'subtitle' => esc_html__('Enter featured link text. (Apply for post format link)','ruby-build-framework'),
                                'type' => 'text'
                            ),
                            array(
                                'id' => "gf_format_link_url",
                                'title' => esc_html__('Featured Link URL','ruby-build-framework'),
                                'subtitle' => esc_html__('Enter featured link url. (Apply for post format link)','ruby-build-framework'),
                                'type' => 'text'
                            ),
                            array(
                                'id' => "gf_format_quote_content",
                                'title' => esc_html__('Featured Quote Content','ruby-build-framework'),
                                'subtitle' => esc_html__('Enter featured quote content','ruby-build-framework'),
                                'type' => 'textarea'
                            ),
                            array(
                                'id' => "gf_format_quote_author_text",
                                'title' => esc_html__('Featured Quote Author Name','ruby-build-framework'),
                                'subtitle' => esc_html__('Enter featured quote author name','ruby-build-framework'),
                                'type' => 'text'
                            ),
                            array(
                                'id' => "gf_format_quote_author_url",
                                'title' => esc_html__('Featured Quote Author URL','ruby-build-framework'),
                                'subtitle' => esc_html__('Enter featured quote author url','ruby-build-framework'),
                                'type' => 'text'
                            ),
					        array(
						        'id' => "{$prefix}single_post_layout",
						        'title' => esc_html__('Post Layout', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Specify your post layout', 'ruby-build-framework'),
						        'type' => 'image_set',
						        'options' => G5P()->settings()->get_single_post_layout(true),
						        'default' => ''
					        ),
                            G5P()->configOptions()->get_config_toggle(array(
                                'id' => "{$prefix}single_reading_process_enable",
                                'title' => esc_html__('Reading Process', 'ruby-build-framework'),
                                'subtitle' => esc_html__('Turn Off this option if you want to hide reading process on single blog', 'ruby-build-framework'),
                                'default' => ''
                            ), true),
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_tag_enable",
						        'title' => esc_html__('Tags', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn Off this option if you want to hide tags on single blog', 'ruby-build-framework'),
						        'default' => ''
					        ), true),
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_share_enable",
						        'title' => esc_html__('Share', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn Off this option if you want to hide share on single blog', 'ruby-build-framework'),
						        'default' => ''
					        ), true),
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_navigation_enable",
						        'title' => esc_html__('Navigation', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn Off this option if you want to hide navigation on single blog', 'ruby-build-framework'),
						        'default' => ''
					        ), true),
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_author_info_enable",
						        'title' => esc_html__('Author Info', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn Off this option if you want to hide author info area on single blog', 'ruby-build-framework'),
						        'default' => ''
					        ), true)
				        )
			        ),
			        array(
				        'id' =>  "{$prefix}section_post_related",
				        'title' => esc_html__('Related Posts', 'ruby-build-framework'),
				        'icon' => 'dashicons dashicons-images-alt2',
				        'fields' => array(
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_related_post_enable",
						        'title' => esc_html__('Related Posts', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn Off this option if you want to hide related posts area on single blog', 'ruby-build-framework'),
						        'default' => ''
					        ), true),
					        array(
						        'id' => "{$prefix}single_related_post_algorithm",
						        'title' => esc_html__('Related Posts Algorithm', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Specify the algorithm of related posts', 'ruby-build-framework'),
						        'type' => 'select',
						        'options' => G5P()->settings()->get_related_post_algorithm(true),
						        'default' => '',
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', ''))
					        ),
					        G5P()->configOptions()->get_config_toggle(array(
						        'id' => "{$prefix}single_related_post_carousel_enable",
						        'title' => esc_html__('Carousel Mode', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Turn On this option if you want to enable carousel mode', 'ruby-build-framework'),
						        'default' => '',
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', ''))
					        ), true),
					        array(
						        'id' => "{$prefix}single_related_post_per_page",
						        'title' => esc_html__('Posts Per Page', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Enter number of posts per page you want to display', 'ruby-build-framework'),
						        'type' => 'text',
						        'input_type' => 'number',
						        'default' => G5P()->options()->get_single_related_post_per_page(),
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', ''))
					        ),
					        array(
						        'id' => "{$prefix}single_related_post_columns_gutter",
						        'title' => esc_html__('Post Columns Gutter', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Specify your horizontal space between post.', 'ruby-build-framework'),
						        'type' => 'select',
						        'options' => G5P()->settings()->get_post_columns_gutter(true),
						        'default' => '',
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', ''))
					        ),
					        array(
						        'id' => "{$prefix}single_related_post_columns_group",
						        'title' => esc_html__('Post Columns', 'ruby-build-framework'),
						        'type' => 'group',
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', '')),
						        'fields' => array(
							        array(
								        'id' => "{$prefix}single_related_post_columns_row_1",
								        'type' => 'row',
								        'col' => 3,
								        'fields' => array(
									        array(
										        'id' => "{$prefix}single_related_post_columns",
										        'title' => esc_html__('Large Devices', 'ruby-build-framework'),
										        'desc' => esc_html__('Specify your post columns on large devices (>= 1200px)', 'ruby-build-framework'),
										        'type' => 'select',
										        'options' => G5P()->settings()->get_post_columns(true),
										        'default' => '',
										        'layout' => 'full',
									        ),
									        array(
										        'id' => "{$prefix}single_related_post_columns_md",
										        'title' => esc_html__('Medium Devices', 'ruby-build-framework'),
										        'desc' => esc_html__('Specify your post columns on medium devices (>= 992px)', 'ruby-build-framework'),
										        'type' => 'select',
										        'options' => G5P()->settings()->get_post_columns(true),
										        'default' => '',
										        'layout' => 'full',
									        ),
									        array(
										        'id' => "{$prefix}single_related_post_columns_sm",
										        'title' => esc_html__('Small Devices', 'ruby-build-framework'),
										        'desc' => esc_html__('Specify your post columns on small devices (>= 768px)', 'ruby-build-framework'),
										        'type' => 'select',
										        'options' => G5P()->settings()->get_post_columns(true),
										        'default' => '',
										        'layout' => 'full',
									        ),
									        array(
										        'id' => "{$prefix}single_related_post_columns_xs",
										        'title' => esc_html__('Extra Small Devices ', 'ruby-build-framework'),
										        'desc' => esc_html__('Specify your post columns on extra small devices (< 768px)', 'ruby-build-framework'),
										        'type' => 'select',
										        'options' => G5P()->settings()->get_post_columns(true),
										        'default' => '',
										        'layout' => 'full',
									        )
								        )
							        ),
						        )
					        ),
					        array(
						        'id' => "{$prefix}single_related_post_paging",
						        'title' => esc_html__('Post Paging', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Specify your post paging mode', 'ruby-build-framework'),
						        'type' => 'select',
						        'options' => G5P()->settings()->get_post_paging_small_mode(true),
						        'default' => '',
						        'required' => array(
                                    array("{$prefix}single_related_post_enable",'in',array('on', '')),
                                    array("{$prefix}single_related_post_carousel_enable",'!=','on')
                                )
					        ),
					        array(
						        'id' => "{$prefix}single_related_post_animation",
						        'title' => esc_html__('Animation', 'ruby-build-framework'),
						        'subtitle' => esc_html__('Specify your post animation', 'ruby-build-framework'),
						        'type' => 'select',
						        'options' => G5P()->settings()->get_animation(true),
						        'default' => '',
						        'required' => array("{$prefix}single_related_post_enable",'in',array('on', ''))
					        )
				        )
			        ),
                    array(
                        'id' =>  "{$prefix}section_layout",
                        'title' => esc_html__('Layout', 'ruby-build-framework'),
                        'icon' => 'dashicons dashicons-editor-table',
                        'fields' => array(
                            G5P()->configOptions()->get_config_preset(array('id' => "{$prefix}page_preset")),
                            array(
                                'id' => "{$prefix}group_layout",
                                'type' => 'group',
                                'title' => esc_html__('Layout','ruby-build-framework'),
                                'fields' => array(
                                    array(
                                        'id' => "{$prefix}main_layout",
                                        'title' => esc_html__('Site Layout', 'ruby-build-framework'),
                                        'type' => 'image_set',
                                        'options' => G5P()->settings()->get_main_layout(true),
                                        'default' => '',
                                    ),

                                    G5P()->configOptions()->get_config_toggle(array(
                                        'id' => "{$prefix}content_full_width",
                                        'title' => esc_html__('Content Full Width', 'ruby-build-framework'),
                                        'subtitle' => esc_html__('Turn On this option if you want to expand the content area to full width.', 'ruby-build-framework'),
                                        'default' => '',
                                    ),true),

                                    G5P()->configOptions()->get_config_toggle(array(
                                        'id' => "{$prefix}custom_content_padding",
                                        'title' => esc_html__('Custom Content Padding','ruby-build-framework'),
                                        'subtitle' => esc_html__('Turn On this option if you want to custom content padding.', 'ruby-build-framework'),
                                        'default' => ''
                                    )),

                                    array(
                                        'id' => "{$prefix}content_padding",
                                        'title' => esc_html__('Content Padding', 'ruby-build-framework'),
                                        'subtitle' => esc_html__('Set content padding', 'ruby-build-framework'),
                                        'type' => 'spacing',
                                        'default' => array('left' => 0, 'right' => 0, 'top' => 50, 'bottom' => 50),
                                        'required' => array("{$prefix}custom_content_padding",'=','on')
                                    ),

                                    G5P()->configOptions()->get_config_sidebar_layout(array(
                                        'id' => "{$prefix}sidebar_layout",
                                    ),true),
                                    G5P()->configOptions()->get_config_sidebar(array(
                                        'id' => "{$prefix}sidebar",
                                        'required' => array("{$prefix}sidebar_layout",'!=','none')
                                    )),
                                )
                            ),

                            array(
                                'id' => "{$prefix}group_page_title",
                                'type' => 'group',
                                'title' => esc_html__('Page Title','ruby-build-framework'),
                                'fields' => array(
                                    G5P()->configOptions()->get_config_toggle(array(
                                        'title' => esc_html__('Page Title Enable','ruby-build-framework'),
                                        'id' => "{$prefix}page_title_enable"
                                    ),true),
                                    G5P()->configOptions()->get_config_content_block(array(
                                        'id' => "{$prefix}page_title_content_block",
                                        'desc' => esc_html__('Specify the Content Block to use as a page title content.', 'ruby-build-framework'),
                                        'required' => array("{$prefix}page_title_enable", '!=', 'off')
                                    ),true),

                                    array(
                                        'title'       => esc_html__('Custom Page title', 'ruby-build-framework'),
                                        'id'          => "{$prefix}page_title_content",
                                        'type'        => 'text',
                                        'default'     => '',
                                        'required' => array("{$prefix}page_title_enable", '!=', 'off'),
                                        'desc'        => esc_html__('Enter custom page title for this page', 'ruby-build-framework')
                                    )
                                )
                            ),
                            array(
                                'title'        => esc_html__('Custom Css Class', 'ruby-build-framework'),
                                'id'          => "{$prefix}css_class",
                                'type'        => 'selectize',
                                'tags' => true,
                                'default'         => '',
                                'desc'        => esc_html__('Enter custom class for this page', 'ruby-build-framework')
                            )
                        )
                    ),
                    array(
                        'id' => "{$prefix}section_menu",
                        'title' => esc_html__('Menu', 'ruby-build-framework'),
                        'icon' => 'dashicons dashicons-menu',
                        'fields' => array(
                            array(
                                'id' => "{$prefix}page_menu",
                                'title' => esc_html__('Page Menu', 'ruby-build-framework'),
                                'type' => 'selectize',
                                'allow_clear' => true,
                                'placeholder' => esc_html__('Select Menu', 'ruby-build-framework'),
                                'desc' => esc_html__('Optionally you can choose to override the menu that is used on the page', 'ruby-build-framework'),
                                'data' => 'menu'
                            ),
                            array(
                                'id' => "{$prefix}page_mobile_menu",
                                'title' => esc_html__('Page Mobile Menu', 'ruby-build-framework'),
                                'type' => 'selectize',
                                'allow_clear' => true,
                                'placeholder' => esc_html__('Select Menu', 'ruby-build-framework'),
                                'desc' => esc_html__('Optionally you can choose to override the menu mobile that is used on the page', 'ruby-build-framework'),
                                'data' => 'menu'
                            ),
                            G5P()->configOptions()->get_config_toggle(array(
                                'id' => "{$prefix}is_one_page",
                                'title' => esc_html__('Is One Page', 'ruby-build-framework'),
                                'desc' => esc_html__('Set page style is One Page', 'ruby-build-framework'),
                            ))
                        )
                    ),
		        )
	        );

            return $configs;
        }
    }
}