<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
if ( !class_exists( 'G5P_Core_Custom_Editor' ) ) {
    class G5P_Core_Custom_Editor
    {
        /**
         * The instance of this object
         *
         * @var null|object
         */
        private static $_instance;

        /**
         * Init G5P_Core_Custom_Editor
         *
         * @return G5P_Core_Custom_Editor|null|object
         */
        public static function getInstance()
        {
            if ( self::$_instance == NULL ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        public function init()
        {
            add_filter('mce_buttons', array($this, 'custom_editor_register_buttons'));
            add_filter('mce_external_plugins', array($this, 'custom_editor_register_tinymce_javascript'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        }

        public function enqueue_scripts()
        {
			wp_enqueue_script(G5P()->assetsHandle('custom-editor'), G5P()->helper()->getAssetUrl('core/custom-editor/assets/js/custom-editor.min.js'), array( 'jquery' ), G5P()->pluginVer(), true);
            wp_localize_script( G5P()->assetsHandle('custom-editor'), 'custom_editor_var',
                array(
                    'menu_name' => esc_html__('Customs', 'ruby-build-framework'),
                    'blockquote_text' => array(
                        esc_html__('Blockquote', 'ruby-build-framework'),
                        esc_html__('Blockquote - Center', 'ruby-build-framework'),
                        is_rtl() ? esc_html__('Blockquote - Right', 'ruby-build-framework') : esc_html__('Blockquote - Left', 'ruby-build-framework'),
                        is_rtl() ? esc_html__('Blockquote - Left', 'ruby-build-framework') : esc_html__('Blockquote - Right', 'ruby-build-framework'),
                    ),
                    'content_padding_text' => array(
                        esc_html__('Content Paddings', 'ruby-build-framework'),
                        esc_html__('Content ⇠', 'ruby-build-framework'),
                        esc_html__('⇢ Content', 'ruby-build-framework'),
                        esc_html__('⇢ Content ⇠', 'ruby-build-framework'),
                        esc_html__('⇢ Content ⇠⇠', 'ruby-build-framework'),
                        esc_html__('⇢⇢ Content ⇠', 'ruby-build-framework'),
                        esc_html__('⇢⇢ Content ⇠⇠', 'ruby-build-framework'),
                        esc_html__('⇢⇢⇢ Content ⇠⇠⇠', 'ruby-build-framework')
                    ),
                    'dropcap_text' => array(
                        esc_html__('Dropcap', 'ruby-build-framework'),
                        esc_html__('Dropcap - Simple', 'ruby-build-framework'),
                        esc_html__('Dropcap - Square', 'ruby-build-framework'),
                        esc_html__('Dropcap - Square Outline', 'ruby-build-framework'),
                        esc_html__('Dropcap - Cirlce', 'ruby-build-framework'),
                        esc_html__('Dropcap - Circle Outline', 'ruby-build-framework')
                    ),
                    'highlighted_text' => array(
                        esc_html__('Highlighted Text', 'ruby-build-framework'),
                        esc_html__('Highlighted Yellow', 'ruby-build-framework'),
                        esc_html__('Highlighted Red', 'ruby-build-framework')
                    ),
                    'column_text' => array(
                        esc_html__('Columns', 'ruby-build-framework'),
                        esc_html__('2 Columns', 'ruby-build-framework'),
                        esc_html__('3 Columns', 'ruby-build-framework'),
                        esc_html__('4 Columns', 'ruby-build-framework')
                    ),
                    'custom_list_text' => array(
                        esc_html__('Custom List', 'ruby-build-framework'),
                        esc_html__('Check List', 'ruby-build-framework'),
                        esc_html__('Star List', 'ruby-build-framework'),
                        esc_html__('Edit List', 'ruby-build-framework'),
                        esc_html__('Folder List', 'ruby-build-framework'),
                        esc_html__('File List', 'ruby-build-framework'),
                        esc_html__('Heart List', 'ruby-build-framework'),
                        esc_html__('Asterisk List', 'ruby-build-framework')
                    ),
                    'divider_text' => array(
                        esc_html__('Drives', 'ruby-build-framework'),
                        esc_html__('Drive Full', 'ruby-build-framework'),
                        esc_html__('Drive Small', 'ruby-build-framework'),
                        esc_html__('Drive Tiny', 'ruby-build-framework'),
                        esc_html__('Drive Large', 'ruby-build-framework')
                    ),
                    'alert_text' => array(
                        esc_html__('Alerts', 'ruby-build-framework'),
                        esc_html__('Alert Simple', 'ruby-build-framework'),
                        esc_html__('Alert Success', 'ruby-build-framework'),
                        esc_html__('Alert Info', 'ruby-build-framework'),
                        esc_html__('Alert Warning', 'ruby-build-framework'),
                        esc_html__('Alert Danger', 'ruby-build-framework'),
                    ),
                    'white_text' => esc_html__('White Text', 'ruby-build-framework')
                )
            );
            wp_enqueue_style(G5P()->assetsHandle('custom-editor'), G5P()->helper()->getAssetUrl('core/custom-editor/assets/css/custom-editor.min.css'), array(), G5P()->pluginVer());
        }

        public function custom_editor_register_buttons( $buttons )
        {
            array_push( $buttons, 'custom_editor', 'separator' );
            return $buttons;
        }

        public function custom_editor_register_tinymce_javascript( $plugin_array )
        {
            $plugin_array['custom_editor'] = G5P()->pluginUrl() . 'core/custom-editor/assets/js/custom-editor-menu.js';
            return $plugin_array;
        }
    }
}