<?php
/**
 * The template for displaying post-navigation.php
 */
$single_navigation_enable = g5plusRubyBuild()->options()->get_single_navigation_enable();
if ($single_navigation_enable !== 'on') return;
?>
<nav class="gf-post-navigation">
	<?php
	$prev_post = get_adjacent_post(false, '', true);
	$prev_post_classes = array('post-prev');
	if (is_object($prev_post)) {
		$prev_post_img = wp_get_attachment_image_src(get_post_thumbnail_id($prev_post), 'full');
		if (is_array($prev_post_img)) {
			$prev_post_img_src = $prev_post_img[0];
			$prev_post_bg_class = "post-prev-{$prev_post->ID}";
			$prev_post_background = <<<CSS
				.{$prev_post_bg_class} {
					background-image: url('{$prev_post_img_src}');
				}
CSS;
			g5plusRubyBuild()->custom_css()->addCss($prev_post_background);
			$prev_post_classes[] = $prev_post_bg_class;
			$prev_post_classes[] = 'post-nav-bg';
		}
	}
	$prev_post_class = implode(' ', $prev_post_classes);
	?>
	<div class="<?php echo esc_attr($prev_post_class); ?>">
		<?php if (is_object($prev_post)): ?>
			<span><a href="<?php the_permalink($prev_post) ?>" title="<?php esc_html_e('Previous Article', 'g5plus-ruby-build') ?>"><?php esc_html_e('Previous Article', 'g5plus-ruby-build') ?></a></span>
			<h3 class="gf-post-title">
				<a href="<?php the_permalink($prev_post) ?>" title="<?php echo esc_attr($prev_post->post_title); ?>"><?php echo esc_html($prev_post->post_title); ?></a>
			</h3>
		<?php else: ?>
			<span><?php esc_html_e('No Older Articles', 'g5plus-ruby-build') ?></span>
		<?php endif; ?>
	</div>
	<?php
	$next_post = get_adjacent_post(false, '', false);
	$next_post_classes = array('post-next');
	if (is_object($next_post)) {
		$next_post_img = wp_get_attachment_image_src(get_post_thumbnail_id($next_post), 'full');
		if (is_array($next_post_img)) {
			$next_post_img_src = $next_post_img[0];
			$next_post_bg_class = "post-next-{$next_post->ID}";
			$next_post_background = <<<CSS
					.{$next_post_bg_class} {
						background-image: url('{$next_post_img_src}');
					}
CSS;
			g5plusRubyBuild()->custom_css()->addCss($next_post_background);
			$next_post_classes[] = $next_post_bg_class;
			$next_post_classes[] = 'post-nav-bg';
		}
	}
	$next_post_class = implode(' ', $next_post_classes);

	?>
	<div class="<?php echo esc_attr($next_post_class) ?>">
		<?php if (is_object($next_post)): ?>
			<span><a href="<?php the_permalink($next_post) ?>" title="<?php esc_html_e('Next Article', 'g5plus-ruby-build') ?>"><?php esc_html_e('Next Article', 'g5plus-ruby-build') ?></a></span>
			<h3 class="gf-post-title">
			<a href="<?php the_permalink($next_post) ?>"
			   title="<?php echo esc_attr($next_post->post_title); ?>"><?php echo esc_html($next_post->post_title); ?></a>
			</h3>
		<?php else: ?>
			<span><?php esc_html_e('No Newer Articles', 'g5plus-ruby-build') ?></span>
		<?php endif; ?>
	</div>
</nav>
