<?php
/**
 * @var $image_ratio
 * @var $image_size
 * @var $post_class
 * @var $post_inner_class
 * @var $placeholder_enable
 * @var $post_attributes
 * @var $post_inner_attributes
 */
?>
<article <?php echo implode(' ', $post_attributes); ?> <?php post_class($post_class) ?>>
    <div <?php echo implode(' ', $post_inner_attributes); ?> class="<?php echo esc_attr($post_inner_class); ?>">
        <?php
            g5plusRubyBuild()->portfolio()->render_thumbnail_markup(array(
                'image_size'         => $image_size,
                'image_ratio'        => $image_ratio,
                'placeholder_enable' => $placeholder_enable
            ));
        ?>
        <div class="portfolio-content block-center">
            <div class="block-center-inner">
                <div class="portfolio-action mg-bottom-20">
                    <?php g5plusRubyBuild()->helper()->getTemplate('portfolio/loop/post-zoom') ?>
                    <?php g5plusRubyBuild()->helper()->getTemplate('portfolio/loop/post-link') ?>
                </div>
                <?php g5plusRubyBuild()->helper()->getTemplate('portfolio/loop/post-title') ?>
                <?php g5plusRubyBuild()->helper()->getTemplate('portfolio/loop/post-category'); ?>
            </div>
        </div>
    </div>
</article>
