<?php
/**
 * The template for displaying top-bar
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 */
$top_bar_enable = g5plusRubyBuild()->options()->get_mobile_top_bar_enable();
if ($top_bar_enable !== 'on') return;
$content_block = g5plusRubyBuild()->options()->get_mobile_top_bar_content_block();
$content_block = g5plusRubyBuild()->helper()->content_block($content_block);
?>
<div class="mobile-top-bar">
	<?php if (!empty($content_block)) {
		echo wp_kses_post($content_block);
	} else { ?>
		<div class="gf-content-block-none dark text-center">
			<?php printf(wp_kses_post(__('Please specify the <b>Content Block</b> to use as a top bar content in <a title="Theme Options" href="%s">Theme Options</a>', 'g5plus-ruby-build')), admin_url('themes.php?page=gf-options')); ?>
		</div>
	<?php } ?>
</div>
