<?php
/**
 * The template for displaying header-customize
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 * @var $customize_location
 * @var $canvas_position
 */
$header_customize = g5plusRubyBuild()->options()->getOptions("header_customize_{$customize_location}");
unset($header_customize['sort_order']);
//if (sizeof($header_customize) == 0) return;
$wrap_classes = array(
	'header-customize',
	"header-customize-{$customize_location}",
	'gf-inline'
);

$custom_css = g5plusRubyBuild()->options()->getOptions("header_customize_{$customize_location}_custom_css");
if (!empty($custom_css)) {
	$wrap_classes[] = $custom_css;
}


$wrap_class = implode(' ', array_filter($wrap_classes));
?>
<ul class="<?php echo esc_attr($wrap_class); ?>">
	<?php if (is_array($header_customize)) : ?>
		<?php foreach ($header_customize as $item): ?>
			<li class="customize-<?php echo esc_attr($item); ?>">
				<?php g5plusRubyBuild()->helper()->getTemplate("header/customize-item/{$item}", array('customize_location' => $customize_location, 'canvas_position' => $canvas_position)); ?>
			</li>
		<?php endforeach; ?>
	<?php endif; ?>
</ul>
