<?php
if (!defined('ABSPATH')) {
	exit('Direct script access denied.');
}
if (!class_exists('G5Plus_Inc_Our_Service')) {
	class G5Plus_Inc_Our_Service
	{
		private static $_instance;
		
		public static function getInstance()
		{
			if (self::$_instance == NULL) {
				self::$_instance = new self();
			}
			
			return self::$_instance;
		}

        private $_post_type = 'our_service';
        private $_taxonomy_category = 'our_service_cat';

        public function get_post_type()
        {
            return $this->_post_type;
        }

        public function get_taxonomy_category()
        {
            return $this->_taxonomy_category;
        }
		
		public function init()
		{
			add_filter('g5plus_ruby_build_post_layout_matrix', array($this, 'layout_matrix'), 10, 4);
		}
		
		public function render_thumbnail_markup($args = array())
		{
			$defaults = array(
				'post_id'            => get_the_ID(),
				'image_size'         => 'thumbnail',
				'placeholder_enable' => true,
				'image_mode'         => 'background',
				'image_ratio'        => ''
			);
			$defaults = wp_parse_args($args, $defaults);
			g5plusRubyBuild()->helper()->getTemplate('our-service/thumbnail', $defaults);
		}
		
		public function layout_matrix($matrix, $columns_class, $columns_gutter, $columns)
		{
			$matrix[$this->get_post_type()] = array(
				'grid'    => array(
					'image_size'         => g5plusRubyBuild()->options()->get_our_service_image_size(),
					'placeholder_enable' => true,
					'columns_gutter'     => $columns_gutter,
					'isotope'            => array(
						'itemSelector' => 'article',
						'layoutMode'   => 'fitRows',
					),
					'layout'             => array(
						array('columns' => $columns_class, 'template' => 'grid')
					)
				),
				'masonry' => array(
					'columns_gutter' => $columns_gutter,
					'isotope'        => array(
						'itemSelector' => 'article',
						'layoutMode'   => 'masonry',
					),
					'layout'         => array(
						array('columns' => $columns_class, 'template' => 'grid')
					)
				),
			);
			
			if (in_array(5, $columns)) {
				unset($matrix[$this->get_post_type()]['grid']['isotope']);
			}
			return $matrix;
		}
		
		public function get_layout_settings()
		{
			return array(
				'post_layout'            => g5plusRubyBuild()->options()->get_our_service_layout(),
				'post_columns'           => array(
					'lg' => intval(g5plusRubyBuild()->options()->get_our_service_columns()),
					'md' => intval(g5plusRubyBuild()->options()->get_our_service_columns_md()),
					'sm' => intval(g5plusRubyBuild()->options()->get_our_service_columns_sm()),
					'xs' => intval(g5plusRubyBuild()->options()->get_our_service_columns_xs()),
					'mb' => intval(g5plusRubyBuild()->options()->get_our_service_columns_mb()),
				),
				'post_columns_gutter'    => intval(g5plusRubyBuild()->options()->get_our_service_columns_gutter()),
				'post_paging'            => g5plusRubyBuild()->options()->get_our_service_paging(),
				'post_animation'         => g5plusRubyBuild()->options()->get_our_service_animation(),
				'itemSelector'           => 'article',
				'category_filter_enable' => false,
				'post_type'              => $this->get_post_type(),
				'taxonomy'               => $this->get_taxonomy_category()
			);
		}
		
		public function archive_markup($query_args = null, $settings = null)
		{
			global $wp_query;
			if (isset($settings['tabs']) && isset($settings['tabs'][0]['query_args'])) {
				$query_args = $settings['tabs'][0]['query_args'];
			}
			
			if (!isset($query_args)) {
				$settings['isMainQuery'] = true;
			}
			
			$settings = wp_parse_args($settings, $this->get_layout_settings());
			g5plusRubyBuild()->blog()->set_layout_settings($settings);
			
			if (isset($query_args)) {
				$query_args = g5plusRubyBuild()->query()->get_main_query_vars($query_args);
				$is_category = is_category();
				query_posts($query_args);
				$wp_query->is_category = $is_category;
			}
			
			if (isset($settings['category_filter_enable']) && $settings['category_filter_enable'] === true) {
				add_action('g5plus_ruby_build_before_archive_wrapper', array(g5plusRubyBuild()->blog(), 'category_filter_markup'));
			}
			
			if (isset($settings['tabs'])) {
				add_action('g5plus_ruby_build_before_archive_wrapper', array(g5plusRubyBuild()->blog(), 'tabs_markup'));
			}
			
			g5plusRubyBuild()->helper()->getTemplate('our-service/archive');
			
			if (isset($settings['tabs'])) {
				remove_action('g5plus_ruby_build_before_archive_wrapper', array(g5plusRubyBuild()->blog(), 'tabs_markup'));
			}
			
			if (isset($settings['category_filter_enable']) && $settings['category_filter_enable'] === true) {
				remove_action('g5plus_ruby_build_before_archive_wrapper', array(g5plusRubyBuild()->blog(), 'category_filter_markup'));
			}
			
			g5plusRubyBuild()->blog()->unset_layout_settings();
			
			if (isset($query_args)) {
				wp_reset_query();
			}
			
		}
		
		public function the_permalink($post = 0)
		{
			the_permalink($post);
		}
		public function the_excerpt($post = 0)
		{
			the_excerpt($post);
		}
		
	}
}