<?php
if (!class_exists('G5Plus_Inc_MetaBox_Our_Team')) {
    class G5Plus_Inc_MetaBox_Our_Team {
        private static $_instance;
        public static function getInstance() {
            if (self::$_instance == NULL) { self::$_instance = new self(); }
            return self::$_instance;
        }
		public function get_our_team_job($id = ''){ return $this->getMetaValue('our_team_job', $id); }
		public function get_our_team_details_job_experience($id = ''){ return $this->getMetaValue('our_team_details_job_experience', $id); }
		public function get_social_networks($id = ''){ return $this->getMetaValue('social_networks', $id); }
		public function getMetaValue($meta_key, $id = '') {
			if ($id === '') {
				$id = get_the_ID();
			}
		
			$value = get_post_meta($id, $meta_key, true);
			if ($value === '') {
				$default = &$this->getDefault();
				if (isset($default[$meta_key])) {
					$value = $default[$meta_key];
				}
			}
			return $value;
		}
	
	
		public function &getDefault() {
			$default = array (
				'our_team_job' => '',
				'our_team_details_job_experience' => '',
				'social_networks' =>
					array (
						0 =>
							array (
								'social_name' => 'Facebook',
								'social_id' => 'social-facebook',
								'social_icon' => 'fa fa-facebook',
								'social_link' => '',
								'social_color' => '#3b5998',
							),
						1 =>
							array (
								'social_name' => 'Twitter',
								'social_id' => 'social-twitter',
								'social_icon' => 'fa fa-twitter',
								'social_link' => '',
								'social_color' => '#1da1f2',
							),
						2 =>
							array (
								'social_name' => 'Pinterest',
								'social_id' => 'social-pinterest',
								'social_icon' => 'fa fa-pinterest',
								'social_link' => '',
								'social_color' => '#bd081c',
							),
						3 =>
							array (
								'social_name' => 'Dribbble',
								'social_id' => 'social-dribbble',
								'social_icon' => 'fa fa-dribbble',
								'social_link' => '',
								'social_color' => '#00b6e3',
							),
					),
			);
            return $default;
        }
    }
}