<?php

trait Accounts
{

	public function add_new_fb_account_with_at()
	{
		$accessToken = _post('access_token' , '' , 'string');
		if( empty( $accessToken) )
		{
			response(false);
		}

		$getAppDetails = wpDB()->get_row("SELECT * FROM " . wpTable('apps') . " WHERE is_standart=3 AND driver='fb' LIMIT 1" , ARRAY_A);

		if( !$getAppDetails )
		{
			response(false , ['error_msg' => esc_html__('No FB App found!' , 'fs-poster')]);
		}

		require_once LIB_DIR . "fb/FacebookLib.php";

		$accessToken = FacebookLib::extractAccessToken($accessToken);

		if( $accessToken['status'] == false )
		{
			response(false , $accessToken['message']);
		}

		$accessToken = $accessToken['access_token'];

		$data = FacebookLib::authorizeFbUser( $getAppDetails['id'] , $accessToken );

		response(true , ['data' => $data]);
	}

	public function delete_account()
	{
		if( !(isset($_POST['id']) && is_numeric($_POST['id']) && $_POST['id'] > 0) )
		{
			exit();
		}
		$id = (int)$_POST['id'];

		$checkAccount = wpFetch('accounts' , $id);
		if( !$checkAccount )
		{
			response(false , esc_html__('Account not found!' , 'fs-poster'));
		}
		else if( $checkAccount['user_id'] != get_current_user_id() )
		{
			response(false , esc_html__('You do not have a permission to delete this account!' , 'fs-poster'));
		}

		wpDB()->delete(wpTable('accounts') , ['id' => $id]);

		wpDB()->delete(wpTable('account_access_tokens') , ['account_id' => $id]);

		wpDB()->delete(wpTable('account_nodes') , ['account_id' => $id]);

		response(true);
	}

	public function get_accounts()
	{
		$name = _post('name' , '' , 'string');

		$supported = ['fb' , 'twitter' , 'instagram' , 'linkedin', 'google', 'vk', 'pinterest' , 'reddit' , 'tumblr'];
		if( empty($name) || !in_array( $name , $supported ) )
		{
			response(false);
		}

		ob_start();
		require( VIEWS_DIR . 'app_menus/account/' . $name . '.php' );
		$viewOutput = ob_get_clean();

		response(true , [
			'html' => htmlspecialchars($viewOutput)
		]);
	}

	public function account_activity_change()
	{
		if(!( isset($_POST['checked']) && ( $_POST['checked'] == '1' || $_POST['checked'] == '0')
			&& isset($_POST['id']) && is_numeric($_POST['id']) && $_POST['id'] > 0))
		{
			response(false);
		}

		$id = (int)$_POST['id'];
		$checked = (int)$_POST['checked'];

		wpDB()->update(wpTable('accounts') , [
			'is_active' => $checked
		] , [
			'id' => $id,
			'user_id' => get_current_user_id()
		]);

		response(true);
	}

	public function add_instagram_account()
	{
		$username = _post('username' , '' , 'string');
		$password = _post('password' , '' , 'string');

		if( empty($username) || empty($password) )
		{
			response(false, ['error_msg' => esc_html__('Please enter the instagram username and password!' , 'fs-poster')]);
		}

		require_once LIB_DIR . "instagram/Instagram.php";

		$ig = Instagram::login($username , $password);
		if( $ig['status'] == 'challange' )
		{
			response(true , ['do' => 'challange' , 'message' => $ig['message']]);
		}
		else if( $ig['status'] == 'error' )
		{
			response(false , substr($ig['message'] , strpos($ig['message'] , ':')+2) );
		}
		else if( !isset($ig['ig']) )
		{
			response(false);
		}

		$ig = $ig['ig'];

		$data = $ig->people->getSelfInfo()->asArray();
		$data = $data['user'];

		$sqlData = [
			'user_id'           =>  get_current_user_id(),
			'profile_id'        =>  $ig->account_id,
			'username'          =>  $username,
			'password'          =>  $password,
			'driver'            =>  'instagram',
			'name'              =>  isset($data['full_name']) ? $data['full_name'] : '',
			'is_active'         =>  1,
			'followers_count'   =>  isset($data['follower_count']) ? $data['follower_count'] : '0',
			'friends_count'     =>  isset($data['following_count']) ? $data['following_count'] : '0',
			'profile_pic'       =>  isset($data['profile_pic_url']) ? $data['profile_pic_url'] : ''
		];

		$checkIfExists = wpFetch('accounts' , ['user_id' => get_current_user_id() , 'profile_id' => $ig->account_id]);
		if( $checkIfExists )
		{
			wpDB()->update(wpTable('accounts') , $sqlData , ['id' => $checkIfExists['id']]);
		}
		else
		{
			wpDB()->insert(wpTable('accounts') , $sqlData);
		}

		response(true);
	}

	public function confirm_instagram_challange()
	{
		$username = _post('username' , '' , 'string');
		$password = _post('password' , '' , 'string');
		$code = _post('code' , '' , 'string');

		if( empty($username) || empty($password) || empty($code) )
		{
			response(false, ['error_msg' => esc_html__('Please enter the instagram username and password!' , 'fs-poster')]);
		}

		require_once LIB_DIR . 'instagram/ChallangePass.php';

		if( ChallangePass::confirmChallange( $username , $code ) )
		{
			$this->add_instagram_account();
		}
	}


	public function add_vk_account()
	{
		$accessToken = _post('at' , '' , 'string');
		$app = _post('app' , '0' , 'int');

		if( empty($accessToken) )
		{
			response(false , ['error_msg' => esc_html__('Access token is empty!' , 'fs-poster')]);
		}

		preg_match('/access_token\=([^\&]+)/' , $accessToken , $accessToken2);

		if( isset($accessToken2[1]) )
		{
			$accessToken = $accessToken2[1];
		}

		$getApp = wpFetch('apps' , ['driver' => 'vk' , 'app_id' => $app]);

		require_once LIB_DIR . "vk/Vk.php";

		$result = Vk::authorizeVkUser((int)$getApp['id'] , $accessToken);

		if( isset($result['error']) )
		{
			response(false , $result['error']);
		}

		response(true);
	}

	public function pinterest_account_board_change()
	{
		$accountId = _post('account_id' , '0' , 'num');
		$board = _post('board' , '' , 'string');

		if( empty($board) || !($accountId > 0) )
		{
			response(false);
		}

		$boardId = mb_substr($board , 0 , mb_strpos($board , ':' , 0 , 'UTF-8') , 'UTF-8');
		$boardName = mb_substr($board , mb_strpos($board , ':' , 0 , 'UTF-8') + 1 , null , 'UTF-8');

		$board = json_encode(['board' => ['id' => $boardId , 'name' => $boardName]]);

		wpDB()->update(wpTable('accounts') , ['options' => $board] , [
			'user_id'   =>  get_current_user_id(),
			'id'        =>  $accountId
		]);

		response(true);
	}

	public function reddit_account_subreddit_change()
	{
		$accountId = _post('account_id' , '0' , 'num');
		$subreddit = _post('subreddit' , '' , 'string');

		if( !($accountId > 0) )
		{
			response(false);
		}

		$subreddit = json_encode(['subreddit' => $subreddit]);

		wpDB()->update(wpTable('accounts') , ['options' => $subreddit] , [
			'user_id'   =>  get_current_user_id(),
			'id'        =>  $accountId
		]);

		response(true);
	}

}