function validateUsername(username)
{
	if (username == '') return false;
	if (username.lenght < 6 && username.lenght > 15) return false;
	
	pattern = /^[A-Za-z0-9][A-Za-z0-9_]{5,14}$/; //Allow only lowercase letters, digits and the underscore (except in the first position). With a minimum of 6 characters (1+5), and a maximum of 15 (1+14).
	if (username.match(pattern)) return true;
	return false;
}

function createCategory(diverror, bsubmit, idfather)
{
	$(bsubmit).attr('disabled','true');

	namecategory = $('#namecategory').val();
	if (namecategory == '') {
		openandclose(diverror,admin_txt_error_name_category,1700);
		$('#namecategory').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-categories/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&idf=' + idfather + '&ncat=' + encodeURIComponent(namecategory),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					if (idfather == 0) {
						self.location = siteurl + 'admin/pages/categories';
					} else {
						self.location = siteurl + 'admin/pages/categories/c:' + idfather;
					}
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateCategory(diverror, bsubmit, divitem, divform, idcat, idfather)
{
	$(bsubmit).attr('disabled','true');

	namecategory = $('#namecategory' + idcat).val();
	if (namecategory == '') {
		openandclose(diverror,admin_txt_error_name_category,1700);
		$('#namecategory' + idcat).focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-categories/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&idc=' + idcat + '&idf=' + idfather + '&ncat=' + encodeURIComponent(namecategory),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					$('#txtcat_' + idcat).html(namecategory);
					$('#namecategory' + idcat).val(namecategory);
					$(divform).slideUp('slow', function(){
						$(divitem).slideDown('slow');
					});
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000);
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function deleteCategory(diverror, divitem, idcat, idfather)
{
	if (confirm(msgalertdelete)) {

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-categories/r:' + Math.round(Math.random()*1000),
		data: 'todo=3&idc=' + idcat + '&idf=' + idfather,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					break;
				case '1':
					$(divitem).fadeOut(500, function() { $(divitem).remove(); });
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
		} //end error
	}); // end ajax	
	
	}
}

/**********************************************************************/

function updateAdsBasic(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	adsbasic1=$.trim($('#adsbasic1').val());

	adsbasic2=$.trim($('#adsbasic2').val());
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-adsbasic/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&adsb1=' + encodeURIComponent(adsbasic1) + '&adsb2=' + encodeURIComponent(adsbasic2),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateLanguage(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	language=$.trim($('#language').val());
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-language/r:' + Math.round(Math.random()*1000),
		data: 'l=' + language,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/

function updateTheme(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	theme=$.trim($('#theme').val());
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-theme/r:' + Math.round(Math.random()*1000),
		data: 't=' + theme,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/

function updateStatusUser(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	mstatus = $('#mstatus').val();
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&st=' + mstatus + '&uid=' + uidd,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/


function updateverified(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	mverified = $('#mverified').val();
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
		data: 'todo=4&mv=' + mverified + '&uid=' + uidd,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/


function updateInfoUser(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	uemail = $.trim($('#uemail').val());
	if (!emailvalidate(uemail)) {
		openandclose(diverror,uinfo_msg01,1700);		
		$('#uemail').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000); 
		return;
	}
	
	uusername = $.trim($('#uusername').val());
	if (!validateUsername(uusername)) {
		openandclose(diverror,uinfo_msg02,1700);		
		$('#uusername').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000); 
		return;
	}

	ufirstname = $.trim($('#ufirstname').val());
	/*if (ufirstname == '') {
		$('#ufirstname').val(ufirstname);
		openandclose(diverror,uinfo_msg03,1700);
		$('#ufirstname').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}*/

	ulastname = $.trim($('#ulastname').val());
	/*if (ulastname == '') {
		$('#ulastname').val(ulastname);
		openandclose(diverror,uinfo_msg04,1700);
		$('#ulastname').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}
	*/
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
		data: 'todo=5&ue=' + uemail + '&uid=' + uidd + '&uu=' + uusername + '&ufn=' + encodeURIComponent(ufirstname) + '&uln=' + encodeURIComponent(ulastname),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/

function updatePass(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	npassw = $('#npassw').val();
	if (npassw == '') {
		openandclose(diverror,pass_msg1,1700);
		$('#npassw').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	npassw2 = $('#npassw2').val();
	if (npassw2 == '') {
		openandclose(diverror,pass_msg2,1700);
		$('#npassw2').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	if (npassw != npassw2) {
		openandclose(diverror,pass_msg3,1700);
		$('#npassw2').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
		data: 'todo=6&np=' + CryptoJS.MD5(npassw) + '&uid=' + uidd,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					$('#npassw').val('');
					$('#npassw2').val('');
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 					
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/


function updateLevel(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	level=$('#level').val();
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&lv=' + level + '&uid=' + uidd,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/**********************************************************************/

function deleteUser(diverror,divok,bsubmit)
{
	
	if (confirm(msgalert)) {	
	
		$(bsubmit).attr('disabled','true');
		
		$.ajax({
			type: 'POST',
			url: siteurl + 'ajax/admin-details/r:' + Math.round(Math.random()*1000),
			data: 'todo=3&uid=' + uidd,
			success: function(resp){
				switch(resp.charAt(0)){
					case '0':
						openandclose(diverror,resp.substring(3),2000);
						setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
						break;
					case '1':
						self.location = siteurl + 'admin/users';
						break;
				}
			},
			error: function(){
				openandclose(diverror,admin_norequest,2000);
				setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
			} //end error
		}); // end ajax		
		
	}
}

/**********************************************************************/

function updateGeneral(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	titlesite=$.trim($('#titlesite').val());
	if (titlesite == '') {
		$('#titlesite').val(titlesite);
		openandclose(diverror,txt_error1,1700);
		$('#titlesite').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}
	
	descsite=$.trim($('#descsite').val());
	if (descsite == '') {
		$('#descsite').val(descsite);
		openandclose(diverror,txt_error2,1700);
		$('#descsite').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}
	
	keywsite=$.trim($('#keywsite').val());
	if (keywsite == '') {
		$('#keywsite').val(keywsite);
		openandclose(diverror,txt_error3,1700);
		$('#keywsite').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}

	protected = $('#protected').val();

	language = $('#language').val();
	
	spages = $('#spages').val();
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-general/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&ts=' + encodeURIComponent(titlesite) + '&ds=' + encodeURIComponent(descsite) + '&ks=' + encodeURIComponent(keywsite) + '&prt=' + protected + '&lng=' + language + '&spg=' + spages,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateUserNotficactions(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	notievents = $('#notievents').val();
	notieventsinterval = $('#notieventsinterval').val();

	notimsg = $('#notimsg').val();
	notieventsintervalmsg = $('#notieventsintervalmsg').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-general/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&ne=' + notievents + '&ine=' + notieventsinterval + '&nm=' + notimsg + '&inm=' + notieventsintervalmsg,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateUserChats(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	numchatstart = $('#numchatstart').val();
	intervalmsgchat = $('#intervalmsgchat').val();
	chatemoticons = $('#chatemoticons').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-general/r:' + Math.round(Math.random()*1000),
		data: 'todo=3&ncs=' + numchatstart + '&imc=' + intervalmsgchat + '&ce=' + chatemoticons,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updatePosts(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	numphotospost = $('#numphotospost').val();
	numcommentsperpost = $('#numcommentsperpost').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-general/r:' + Math.round(Math.random()*1000),
		data: 'todo=5&npp=' + numphotospost + '&ncpp=' + numcommentsperpost,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateShowItems(diverror,divok,bsubmit)
{
	$(bsubmit).attr('disabled','true');

	numactivities = $('#numactivities').val();
	numfollowers = $('#numfollowers').val();
	numfollowing = $('#numfollowing').val();
	numnotifications = $('#numnotifications').val();
	numitemmsg = $('#numitemmsg').val();
	numfavorites = $('#numfavorites').val();
	numsearch = $('#numsearch').val();
	numcomments = $('#numcomments').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-general/r:' + Math.round(Math.random()*1000),
		data: 'todo=4&na=' + numactivities + '&nfs=' + numfollowers + '&nfg=' + numfollowing + '&nn=' + numnotifications + '&nim=' + numitemmsg + '&nf=' + numfavorites + '&ns=' + numsearch + '&nc=' + numcomments,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function updateSections(diverror, divok, bsubmit, page)
{
	$(bsubmit).attr('disabled','true');
	
	if (page == 1) {
		txtabout=$.trim($('#txtabout').val());
		if (txtabout == '') {
			$('#txtabout').val(txtabout);
			openandclose(diverror,admin_txt_error,1700);
			$('#txtabout').focus();
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
			return;
		}
		txtdata = '&txtpage=' + encodeURIComponent(txtabout);
	}

	if (page == 2) {
		txtprivacy=$.trim($('#txtprivacy').val());
		if (txtprivacy == '') {
			$('#txtprivacy').val(txtprivacy);
			openandclose(diverror,admin_txt_error,1700);
			$('#txtprivacy').focus();
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
			return;
		}
		txtdata = '&txtpage=' + encodeURIComponent(txtprivacy);
	}
	
	if (page == 3) {
		txttermsofuse=$.trim($('#txttermsofuse').val());
		if (txttermsofuse == '') {
			$('#txttermsofuse').val(txttermsofuse);
			openandclose(diverror,admin_txt_error,1700);
			$('#txttermsofuse').focus();
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
			return;
		}
		txtdata = '&txtpage=' + encodeURIComponent(txttermsofuse);
	}
	
	if (page == 4) {
		txtdisclaimer=$.trim($('#txtdisclaimer').val());
		if (txtdisclaimer == '') {
			$('#txtdisclaimer').val(txtdisclaimer);
			openandclose(diverror,admin_txt_error,1700);
			$('#txtdisclaimer').focus();
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
			return;
		}
		txtdata = '&txtpage=' + encodeURIComponent(txtdisclaimer);
	}
	
	if (page == 5) {
		txtcontact=$.trim($('#txtcontact').val());
		if (txtcontact == '') {
			$('#txtcontact').val(txtcontact);
			openandclose(diverror,admin_txt_error,1700);
			$('#txtcontact').focus();
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
			return;
		}
		txtdata = '&txtpage=' + encodeURIComponent(txtcontact);
	}
	
	
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-sections/r:' + Math.round(Math.random()*1000),
		data: 'todo=' + page + txtdata,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}


/**********************************************************************/

function createPlan(diverror, bsubmit)
{
	$(bsubmit).attr('disabled','true');

	nameplan = $('#nameplan').val();
	if (nameplan == '') {
		openandclose(diverror,error_planname,1700);
		$('#nameplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	actionplan = $('#actionplan').val();

	quantity = $('#quantity').val();
	if (quantity == '') {
		openandclose(diverror,error_quantity,1700);
		$('#quantity').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	if (isNaN(quantity)) {
		openandclose(diverror,error_quantitynumber,1700);
		$('#quantity').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	priceplan = $('#priceplan').val();
	if (priceplan == '') {
		openandclose(diverror,error_price,1700);
		$('#priceplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	if (isNaN(priceplan)) {
		openandclose(diverror,error_pricenumber,1700);
		$('#priceplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}


	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-plans/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&np=' + encodeURIComponent(nameplan) + '&tap=' + actionplan + '&pp=' + priceplan + '&q=' + quantity,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					self.location = siteurl + 'admin/ads/plans';
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/


function updatePlan(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');

	nameplan = $('#nameplan').val();
	if (nameplan == '') {
		openandclose(diverror,error_planname,1700);
		$('#nameplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	actionplan = $('#actionplan').val();

	quantity = $('#quantity').val();
	if (quantity == '') {
		openandclose(diverror,error_quantity,1700);
		$('#quantity').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	if (isNaN(quantity)) {
		openandclose(diverror,error_quantitynumber,1700);
		$('#quantity').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	priceplan = $('#priceplan').val();
	if (priceplan == '') {
		openandclose(diverror,error_price,1700);
		$('#priceplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	if (isNaN(priceplan)) {
		openandclose(diverror,error_pricenumber,1700);
		$('#priceplan').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-plans/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&np=' + encodeURIComponent(nameplan) + '&tap=' + actionplan + '&pp=' + priceplan + '&q=' + quantity + '&idp=' + idp,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/**********************************************************************/

function deletePlan(divitem, idplan)
{
	if (confirm(msgalertdelete)) {

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-plans/r:' + Math.round(Math.random()*1000),
		data: 'todo=3&idp=' + idplan,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					alert(resp.substring(3));
					break;
				case '1':
					$(divitem).fadeOut(500, function() { $(divitem).remove(); });
					break;
			}
		},
		error: function(){
			alert(admin_norequest);
		} //end error
	}); // end ajax	
	
	}
}

/**********************************************************************/

function updateAds(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	headline = $('#headline').val();
	if (headline == '') {
		openandclose(diverror, txt_err_headline, 1700);
		$('#headline').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	description1 = $('#description1').val();
	if (description1 == '') {
		openandclose(diverror, txt_err_descrip1, 1700);
		$('#description1').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	description2 = $('#description2').val();
	if (description2 == '') {
		openandclose(diverror, txt_err_descrip2, 1700);
		$('#description2').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	displayurl = $('#displayurl').val();
	if (displayurl == '') {
		openandclose(diverror, txt_err_displayu, 1700);
		$('#displayurl').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	destinationurl = $('#destinationurl').val();
	if (destinationurl == '') {
		openandclose(diverror, txt_err_destinau, 1700);
		$('#destinationurl').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-ads/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&codad=' + codad + '&h=' + encodeURIComponent(headline) + '&ld1=' + encodeURIComponent(description1) + '&ld2=' + encodeURIComponent(description2) + '&urldisp=' + encodeURIComponent(displayurl) + '&urldest=' + encodeURIComponent(destinationurl),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/***********************************************************************/


function activateNow(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	cPlan = $('#valCPlan').val();

	if (cPlan == '') {
		openandclose(diverror, txt_err_plan, 1700);
		setTimeout(function() {$(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-ads/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&codad=' + codad + '&cp=' + cPlan,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/***********************************************************************/

function updateStatus(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	statusad = $('#statusad').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-ads/r:' + Math.round(Math.random()*1000),
		data: 'todo=3&codad=' + codad + '&st=' + statusad,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/***********************************************************************/


function updateConfiguration(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	emailpaypal = $('#emailpaypal').val();
	if (!emailvalidate(emailpaypal)) {
		openandclose(diverror, txterror_empay, 1700);
		$('#emailpaypal').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	emailpaypalnotifications = $('#emailpaypalnotifications').val();
	if (!emailvalidate(emailpaypalnotifications)) {
		openandclose(diverror, txterror_emapaynot, 1700);
		$('#emailpaypalnotifications').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-configuration/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&empay=' + emailpaypal + '&empaynot=' + emailpaypalnotifications,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax		
}

/***********************************************************************/

function ignoreReport(divitem, idreport)
{
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-reports/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&idr=' + idreport,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					alert(resp.substring(3));
					break;
				case '1':
					$(divitem).fadeOut(500, function() { $(divitem).remove(); });
					break;
			}
		},
		error: function(){
			alert(admin_norequest);
		} //end error
	}); // end ajax	
}

/***********************************************************************/

function deletePostReport(divitem, codpost)
{
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-reports/r:' + Math.round(Math.random()*1000),
		data: 'todo=2&cp=' + codpost,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					alert(resp.substring(3));
					break;
				case '1':
					$(divitem).fadeOut(500, function() { $(divitem).remove(); });
					break;
			}
		},
		error: function(){
			alert(admin_norequest);
		} //end error
	}); // end ajax	
}

/***********************************************************************/

function deleteCommentReport(divitem, idcomment, idownerpost, iddenunciado, idpost, idreport, idinformante)
{
	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-reports/r:' + Math.round(Math.random()*1000),
		data: 'todo=3&idc=' + idcomment + '&idowp=' + idownerpost + '&idden=' + iddenunciado + '&idp=' + idpost + '&idr=' + idreport + '&idi=' + idinformante,
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					alert(resp.substring(3));
					break;
				case '1':
					$(divitem).fadeOut(500, function() { $(divitem).remove(); });
					break;
			}
		},
		error: function(){
			alert(admin_norequest);
		} //end error
	}); // end ajax	
}


/***********************************************************************/

function loadcategorypages(idcat, msgcategory, msgsubcategory, divcategories, divsubcategories ){
	$(divcategories).html('<option value="0">' + msgcategory + '</option>');
	$(divcategories).attr('disabled','true');
	$(divsubcategories).html('<option value="0">' + msgsubcategory + '</option>');
	$.ajax({
		type: 'POST',
		url:  siteurl + "ajax/dashboard-getcategories/r:" + Math.round(Math.random()*1000),
		data: 'idcat=' + idcat,
		success: function(h){
			switch(h.charAt(0)){
				case '0':
					break;
				case '1':
					$(divcategories).html(h.substring(3));
					$(divcategories).removeAttr('disabled');
					break;
			}
		},
		error: function(){
		} //end error
	}); // end ajax
}

function loadsubcategorypages(idcat, idsubcat, msgcsubcategory, divsubcategories) {	
	$(divsubcategories).html('<option value="0">' + msgcsubcategory + '</option>');
	$(divsubcategories).attr('disabled','true');
	$.ajax({
		type: 'POST',
		url: siteurl + "ajax/dashboard-getsubcategories/r:" + Math.round(Math.random()*1000),
		data: 'idcat=' + idcat + '&idsubcat=' + idsubcat,
		success: function(h){
			switch(h.charAt(0)){
				case '0':
					break;
				case '1':
					$(divsubcategories).html(h.substring(3));
					$(divsubcategories).removeAttr('disabled');
					break;
			}
		},
		error: function(){
		} //end error
	}); // end ajax	
}

/***********************************************************************/

function updatePage(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	idcat = $('#pagecategory').val();
	if (idcat == '-1') {
		openandclose(diverror, txt_choose_category, 1700);
		$('#pagecategory').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}

	idsubcat = $('#pagesubcategory').val();
	if (idsubcat == '-1') {
		openandclose(diverror, txt_choose_subcategory, 1700);
		$('#pagesubcategory').focus();
		setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 2000);
		return;
	}

	titlepage = $('#titlepage').val();
	if (titlepage == '') {
		openandclose(diverror, txt_enter_title, 1700);
		$('#titlepage').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	descriptionpage = $('#descriptionpage').val();
	
	statuspage = $('#statuspage').val();
	pverified = $('#pverified').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-pages/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&idc=' + idcat + '&idsc=' + idsubcat + '&stat=' + statuspage + '&pverif=' + pverified + '&tp=' + encodeURIComponent(titlepage) + '&cp=' + cpage + '&dp=' + encodeURIComponent(descriptionpage),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}

/***********************************************************************/

function updateGroup(diverror, divok, bsubmit)
{
	$(bsubmit).attr('disabled','true');
	
	privacygroup = $('#privacygroup').val();

	namegroup = $('#namegroup').val();
	if (namegroup == '') {
		openandclose(diverror, txt_enter_name, 1700);
		$('#namegroup').focus();
		setTimeout(function() { $(bsubmit).removeAttr('disabled'); }, 2000);
		return;
	}
	
	descriptiongroup = $('#descriptiongroup').val();
	
	statusgroup = $('#statusgroup').val();

	$.ajax({
		type: 'POST',
		url: siteurl + 'ajax/admin-groups/r:' + Math.round(Math.random()*1000),
		data: 'todo=1&priv=' + privacygroup + '&stat=' + statusgroup + '&ng=' + encodeURIComponent(namegroup) + '&cg=' + cgroup + '&dg=' + encodeURIComponent(descriptiongroup),
		success: function(resp){
			switch(resp.charAt(0)){
				case '0':
					openandclose(diverror,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
				case '1':
					openandclose(divok,resp.substring(3),2000);
					setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
					break;
			}
		},
		error: function(){
			openandclose(diverror,admin_norequest,2000);
			setTimeout(function() {$(bsubmit).removeAttr('disabled');}, 3000); 
		} //end error
	}); // end ajax	
	
}


/***********************************************************************/