<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain user data profile
	$D->u = $this->network->get_user_by_id(intval($this->params->iduser));
	if( !$D->u ) {
		$this->redirect('dashboard');
	}
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/

	// needed before proceeding
	require_once('_all-required-profile.php');
	
	/*************************************************************************/
	
	$D->nameUserProfile = (empty($D->u->firstname) || empty($D->u->lastname))?$D->u->username:($D->u->firstname.' '.$D->u->lastname);

	// If allowed, it loaded data required for this section
	if ($D->show_profile==1) {
		
		$sqlPostsHiddens = '';
		if ($D->is_logged == 1) {
			$sqlPostsHiddens = ' SELECT iditem FROM hiddens WHERE typeitem=1 AND iduser='.$this->user->id;
			$sqlPostsHiddens = ' posts.idpost NOT IN ('.$sqlPostsHiddens.') AND ';
		}
		
		if ($D->friendship == 1 || $D->is_my_profile) {
			$cadSee = ' (who_see=0 OR who_see=1) ';
		} else {
			$cadSee = ' who_see=0 ';
		}
		
		$D->totalposts = $this->db2->fetch_field("
		SELECT count(idpost) 
		FROM posts, users 
		WHERE ".$sqlPostsHiddens."
		typepost='video' 
		AND users.iduser=posts.iduser 
		AND posted_in=0 
		AND id_wall=".$D->u->iduser." 
		AND ".$cadSee);
		
		$r = $this->db2->query("
		SELECT posts.*, username, firstname, lastname, avatar, users.iduser, users.code as ucode 
		FROM posts, users 
		WHERE ".$sqlPostsHiddens."
		typepost='video' 
		AND users.iduser=posts.iduser 
		AND posted_in=0 
		AND id_wall=".$D->u->iduser."  
		AND ".$cadSee." 
		ORDER BY posts.whendate DESC 
		LIMIT 0,".$C->NUM_ACTIVITIES_PAGE);
	
		$D->numitems = $this->db2->num_rows();
		
		$D->htmlResult = '';

		while( $obj = $this->db2->fetch_object($r) ) {
			
			$D->isMyPost = FALSE;
			if ($D->is_logged == 1) {
				$D->isMyPost = $obj->iduser == $this->user->id ? TRUE : FALSE;
			}
			
			$D->a_date = $obj->whendate;
			$D->codeUser = $obj->ucode;
			
			$D->isOnlyOne = $D->isWithOther = 0;
			
			if ($obj->posted_in == 0) {
				if ($obj->iduser == $obj->id_wall) {
					$D->isOnlyOne = 1;
					$D->codeUser = $obj->ucode;
					$D->userName = $obj->username;
					$D->nameUser = (empty($obj->firstname) || empty($obj->lastname))?$obj->username:($obj->firstname.' '.$obj->lastname);
					$D->userAvatar = $obj->avatar;
				}
				
				if ($obj->iduser != $obj->id_wall) {
					$D->isWithOther = 1;
					$D->codeUser = $obj->ucode;
					$D->userName = $obj->username;
					$D->nameUser = (empty($obj->firstname) || empty($obj->lastname))?$obj->username:($obj->firstname.' '.$obj->lastname);
					$D->userAvatar = $obj->avatar;
	
					$wallsec = $this->network->infoBasicWall($obj->posted_in, $obj->id_wall);
					$D->other_code = $wallsec->code;
					$D->other_userName = $wallsec->username;
					$D->other_nameUser = (empty($wallsec->firstname) || empty($wallsec->lastname))?$wallsec->username:($wallsec->firstname.' '.$wallsec->lastname);
					$D->postInMyWall = FALSE;
					if ($D->is_logged == 1) {
						$D->postInMyWall = $obj->id_wall == $this->user->id ? TRUE : FALSE;
					}
				}
			}
			
			$D->idpost = $obj->idpost;
			$D->codepost = $this->network->getCodePost($D->idpost);
			$onePost = new post($D->codepost);
			$D->idUser = $onePost->iduser;
			$D->typepost = $onePost->typepost;
			$D->numlikes = $onePost->numlikes;
			$D->numcommentstotal = $onePost->numcomments;
			$D->post = stripslashes($onePost->post);
			$D->typepost = $onePost->typepost;
			$D->valueattach = $onePost->valueattach;
			$D->whosee = $onePost->whosee;
			
			// see if the favorite is for the observer
			$D->liketoUser = 0;
			if ($D->is_logged == 1) {
				if ($onePost->likeOfUser($this->user->id) > 0) $D->liketoUser = 1;
			}
			
			$D->htmlcommentspost = '';
			$D->totalcomments = $onePost->numComments();
			$allcommentspost = $onePost->getComments(0,$C->NUM_COMMENTS_PER_POST);
			$D->numcomments = count($allcommentspost);
			
			$allcommentspost = array_reverse($allcommentspost);	
			
			foreach($allcommentspost as $onecomment){
				$D->o_comment = stripslashes($onecomment->comment);
				$D->o_username = stripslashes($onecomment->username);
				$D->o_firstname = stripslashes($onecomment->firstname);
				$D->o_lastname = stripslashes($onecomment->lastname);
				$D->o_ucode = $onecomment->ucode;
				$D->o_nameUser = (empty($D->o_firstname) || empty($D->o_lastname))?stripslashes($D->o_username):(stripslashes($D->o_firstname).' '.stripslashes($D->o_lastname));
				$D->o_whendate = $onecomment->whendate;
				$D->o_avatar =  empty($onecomment->avatar)?$C->AVATAR_DEFAULT:$onecomment->avatar;
				$D->o_idcomment = $onecomment->idcomment;
				$D->o_idUser = $onecomment->iduser;
				$D->o_idpost = $D->idpost;
				$D->o_idUserOwner = $D->idUser;
				$D->o_codepost = $D->codepost;
				$D->htmlcommentspost .= $this->load_template('__onecomment-post.php', FALSE);
			}
			unset($onecomment);
			
			$D->htmlResult .= $this->load_template('__one-post.php', FALSE);
			unset($onePost);
		}
	}

	/*************************************************************************/
	
	$D->nameUser = 	$D->nameUserProfile;

	$D->page_title = $D->nameUser.' - '.$this->lang('profile_videos_title').' - '.$C->SITE_TITLE;
	
	$D->optionactive = 6;	
	$this->load_template('videos.php');
?>