<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}

	// Obtain group data profile
	$D->group = $this->network->get_group_by_id(intval($this->params->idgroup));
	if( !$D->group ) $this->redirect('dashboard');
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/

	// needed before proceeding
	require_once('_all-required-group.php');
	
	/*************************************************************************/	


	$D->codpost = '';
	if ($this->param('codpost')) {
		$D->codpost = $this->param('codpost');
		if (!$this->network->verifiedPostinGroup($D->codpost,$D->group->idgroup)) $this->redirect($C->SITE_URL.$D->group->url);
	} else {
		$this->redirect($C->SITE_URL.$D->group->url);
	}

	$theactivity = $this->db2->fetch("SELECT idpost, posts.iduser, posts.whendate, posted_in, id_wall, who_see, username, firstname, lastname, avatar, users.code as ucode FROM posts, users WHERE posts.code='".$D->codpost."' AND posted_in=2 AND users.iduser=posts.iduser LIMIT 1");
	
	if (!$theactivity) $this->redirect($C->SITE_URL.$D->group->url);

	$D->whosee = $theactivity->who_see;
	
	if ($D->whosee == 2) {
		if ($D->is_logged!=1 || !$D->is_my_group) $this->redirect($C->SITE_URL.$D->group->url);
	}
	
	if ($D->whosee == 1) {
		if ($D->is_logged != 1) $this->redirect($C->SITE_URL.$D->group->url);
		if (!$D->is_my_group) {
			if ($D->membership != 1) $this->redirect($C->SITE_URL.$D->group->url);	
		}
	}

	$D->nameUser = stripslashes($D->group->name_group);
	
	$D->htmlResult = '';

	$D->a_date = $theactivity->whendate;
	
	$D->isaPage = $D->isOnlyOne = $D->isaGroup = $D->isWithOther = 0;

	// is a post of a group
	if ($theactivity->posted_in == 2) {
		$D->isaGroup = 1; 

		$D->codeUser = $theactivity->ucode;
		$D->userName = $theactivity->username;
		$D->nameUser = (empty($theactivity->firstname) || empty($theactivity->lastname))?$theactivity->username:($theactivity->firstname.' '.$theactivity->lastname);
		$D->userAvatar = $theactivity->avatar;

		$wallsec = $this->network->infoBasicWall($theactivity->posted_in, $theactivity->id_wall);
		//is a group
		$D->other_code = $wallsec->code;
		$D->other_url = $wallsec->url;
		$D->other_name = stripslashes($wallsec->name_group);
		
	}
	
	$D->idpost = $theactivity->idpost;
	$D->codepost = $D->codpost;
	$onePost = new post($D->codepost);
	$D->idUser = $onePost->iduser;
	$D->typepost = $onePost->typepost;
	$D->numlikes = $onePost->numlikes;
	$D->numcommentstotal = $onePost->numcomments;
	$D->post = stripslashes($onePost->post);
	$D->valueattach = $onePost->valueattach;
	$D->whosee = $onePost->whosee;
	
	$D->idpostShared = $D->idpost;
			
	$D->isShare=0;
	if ($D->typepost == 'share') {
		$infop = explode(':',$D->valueattach);
		$D->idpostShared = $infop[0];
		$D->isShare=1;
	}
	
	// see if the favorite is for the observer
	$D->liketoUser = 0;
	if ($D->is_logged == 1) {
		if ($onePost->likeOfUser($this->user->id) > 0) $D->liketoUser = 1;
	}
	
	$D->htmlcommentspost = '';
	$D->totalcomments = $onePost->numComments();
	$allcommentspost = $onePost->getComments(0,$C->NUM_COMMENTS_PER_POST);
	$D->numcomments = count($allcommentspost);
	
	$allcommentspost = array_reverse($allcommentspost);	
	
	foreach($allcommentspost as $onecomment){
		$D->o_comment = stripslashes($onecomment->comment);
		$D->o_username = stripslashes($onecomment->username);
		$D->o_firstname = stripslashes($onecomment->firstname);
		$D->o_lastname = stripslashes($onecomment->lastname);
		$D->o_ucode = $onecomment->ucode;
		$D->o_nameUser = (empty($D->o_firstname) || empty($D->o_lastname))?stripslashes($D->o_username):(stripslashes($D->o_firstname).' '.stripslashes($D->o_lastname));
		$D->o_whendate = $onecomment->whendate;
		$D->o_avatar =  empty($onecomment->avatar)?$C->AVATAR_DEFAULT:$onecomment->avatar;
		$D->o_idcomment = $onecomment->idcomment;
		$D->o_idUser = $onecomment->iduser;
		$D->o_idpost = $D->idpost;
		$D->o_idUserOwner = $D->idUser;
		$D->o_codepost = $D->codepost;
		$D->htmlcommentspost .= $this->load_template('__onecomment-post.php', FALSE);
	}
	unset($onecomment);
	
	$D->htmlpostshare = '';
	if ($D->isShare == 1) {

		$D->codepostSh = $this->network->getCodePost($D->idpostShared);
		$onePostSh = new post($D->codepostSh);
		if (!$onePostSh->error) {
			$D->a_dateSh = $onePostSh->whendate;
			$D->idUserSh = $onePostSh->iduser;
			$D->typepostSh = $onePostSh->typepost;
			$D->postSh = stripslashes($onePostSh->post);
			$D->valueattachSh = $onePostSh->valueattach;
			$D->whoseeSh = $onePostSh->whosee;

			$usSh = $this->network->get_user_by_id($D->idUserSh);
			
			$D->isaPageSh = $D->isOnlyOneSh = $D->isaGroupSh = $D->isWithOtherSh = 0;
			
			if ($onePostSh->posted_in == 0) {
				$D->codeUserSh = $usSh->code;
				$D->userNameSh = $usSh->username;
				$D->nameUserSh = (empty($usSh->firstname) || empty($usSh->lastname))?$usSh->username:($usSh->firstname.' '.$usSh->lastname);
				$D->userAvatarSh = $usSh->avatar;

				if ($onePostSh->iduser == $onePostSh->id_wall) {
					$D->isOnlyOneSh = 1;
				} else {
					$D->isWithOtherSh = 1;
					$wallsec = $this->network->infoBasicWall($onePostSh->posted_in, $onePostSh->id_wall);
					$D->other_codeSh = $wallsec->code;
					$D->other_userNameSh = $wallsec->username;
					$D->other_nameUserSh = (empty($wallsec->firstname) || empty($wallsec->lastname))?$wallsec->username:($wallsec->firstname.' '.$wallsec->lastname);
				}
			}
			
			// is a post of a page
			if ($onePostSh->posted_in == 1) {
				$D->isaPageSh = 1;
				$D->idPageSh = $onePostSh->id_wall;
				$thePage = $this->db2->fetch('SELECT code, url, avatar_page, title FROM pages WHERE idpage='.$D->idPageSh.' LIMIT 1');
				$D->pUserNameSh = $thePage->url;
				$D->pCodeSh = $thePage->code;
				$D->pAvatarSh = $thePage->avatar_page;
				$D->pTitleSh = stripslashes($thePage->title);
			}
			
			if ($onePostSh->posted_in == 2) { $D->isaGroupSh = 1; }


			$D->htmlpostshare .= $this->load_template('__one-share-post.php', FALSE);//'Share';
		} else {
			$D->idpostShared = $D->idpost;
			$D->htmlpostshare .= $this->load_template('__one-share-post-nofound.php', FALSE);
		}
		unset($onePostSh);
	}
	
	if ($D->typepost == 'album') {
		$infoalbum = $this->db1->fetch('SELECT * FROM albums WHERE idpost='.$D->idpost.' LIMIT 1');
		$D->codealbum = $infoalbum->code;
		$D->idalbum = $infoalbum->idalbum;
		
		$allPhotos = $this->db1->fetch_all('SELECT photo FROM albums_photos WHERE idalbum='.$D->idalbum.' ORDER BY whendate DESC');
		$totalPhotos = count($allPhotos);
		$D->valueattach = '';
		foreach ($allPhotos as $onePhoto) {
			$D->valueattach .= $onePhoto->photo.',';
		}
		$D->valueattach = trim($D->valueattach,',');
		$D->cadextra = $this->lang('global_txt_addphotos').' '.$totalPhotos.' '.($totalPhotos==1?$this->lang('global_txt_addphotos_photo'):$this->lang('global_txt_addphotos_photos'));
		
	}
	
	if ($D->isShare == 1) $D->htmlResult .= $this->load_template('__one-post-shared.php', FALSE);
	else $D->htmlResult .= $this->load_template('__one-post.php', FALSE);

	unset($onePost);

	/*************************************************************************/

	$D->page_title = $D->nameUser.' - '.$this->lang('profile_posts_title').' - '.$C->SITE_TITLE;
	
	$D->optionactive = 0;	
	$this->load_template('posts-group.php');
?>