<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain page data profile
	$D->page = $this->network->get_page_by_id(intval($this->params->idpage));
	if( !$D->page ) $this->redirect('home');

	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/
	
	// needed before proceeding
	require_once('_all-required-page.php');
	
	/*************************************************************************/
	
	$D->htmlResult = '';
	
	$sqlPostsHiddens = '';
	if ($D->is_logged == 1) {
		$sqlPostsHiddens = ' SELECT iditem FROM hiddens WHERE typeitem=1 AND iduser='.$this->user->id;
		$sqlPostsHiddens = ' posts.idpost NOT IN ('.$sqlPostsHiddens.') AND ';
	}

	$D->totalactivities = $this->db2->fetch_field('
	SELECT count(idpost) 
	FROM posts, users 
	WHERE '.$sqlPostsHiddens.' 
	(users.iduser=posts.iduser) 
	AND posted_in=1 
	AND id_wall='.$D->page->idpage);		
	
	$theposts = $this->db2->fetch_all('
	SELECT DISTINCT idpost, posts.code as pcode, whendate, posted_in, id_wall, typepost, valueattach, numlikes, numcomments, post, who_see, username, firstname, lastname, avatar, users.iduser as uiduser, users.code as ucode, verified 
	FROM posts, users 
	WHERE '.$sqlPostsHiddens.' 
	(users.iduser=posts.iduser) 
	AND posted_in=1 
	AND id_wall='.$D->page->idpage.' 
	ORDER BY whendate DESC 
	LIMIT 0,'.$C->NUM_ACTIVITIES_PAGE);

	$D->numactivities = count($theposts);

	foreach($theposts as $onepost) {
		
		$D->isMyPost = FALSE;
		if ($D->is_logged == 1) {
			$D->isMyPost = $onepost->uiduser == $this->user->id ? TRUE : FALSE;
		}			
		
		$D->isaPage = $D->isOnlyOne = $D->isaGroup = $D->isWithOther = 0;
		
		if ($onepost->posted_in == 0) {
			$D->codeUser = $onepost->ucode;
			$D->userName = $onepost->username;
			$D->nameUser = (empty($onepost->firstname) || empty($onepost->lastname))?$onepost->username:($onepost->firstname.' '.$onepost->lastname);
			$D->userAvatar = $onepost->avatar;

			if ($onepost->uiduser == $onepost->id_wall) {
				$D->isOnlyOne = 1;
			} else {
				$D->isWithOther = 1;
				$wallsec = $this->network->infoBasicWall($onepost->posted_in, $onepost->id_wall);
				$D->other_code = $wallsec->code;
				$D->other_userName = $wallsec->username;
				$D->other_nameUser = (empty($wallsec->firstname) || empty($wallsec->lastname))?$wallsec->username:($wallsec->firstname.' '.$wallsec->lastname);
			}
		}
		
		// is a post of a page
		if ($onepost->posted_in == 1) {
			$D->isaPage = 1;
			$D->idPage = $onepost->id_wall;
			$thePage = $this->db2->fetch('SELECT code, url, avatar_page, title FROM pages WHERE idpage='.$D->idPage.' LIMIT 1');
			$D->pUserName = $thePage->url;
			$D->pCode = $thePage->code;
			$D->pAvatar = $thePage->avatar_page;
			$D->pTitle = stripslashes($thePage->title);
		}
		
		if ($onepost->posted_in == 2) { $D->isaGroup = 1; }

		$D->a_date = $onepost->whendate;
		$D->codeUser = $onepost->ucode;
		$D->valueattach = $onepost->valueattach;

		$D->typepost = $onepost->typepost;
		$D->idpost = $onepost->idpost;			
		$D->isShare=0;
		
		if ($D->typepost == 'share') {
			$infop = explode(':',$D->valueattach);
			$D->idpostShared = $infop[0];
			$D->idpost = $onepost->idpost;
			$D->isShare=1; 
		} else {
			$D->idpost = $onepost->idpost;
			$D->idpostShared = $onepost->idpost;
		}

		$D->codepost = $onepost->pcode;
		$D->idUser = $onepost->uiduser;
		$D->numlikes = $onepost->numlikes;
		$D->numcommentstotal = $onepost->numcomments;
		$D->post = stripslashes($onepost->post);
		$D->whosee = $onepost->who_see;

		// see if the favorite is for the observer
		$D->liketoUser = 0;
		if ($D->is_logged == 1) {
			if ($this->network->PostLiketoUser($this->user->id, $D->idpost) > 0) $D->liketoUser = 1;
		}
		
		$D->htmlcommentspost = '';
		$D->totalcomments = $onepost->numcomments;
		$allcommentspost = $this->network->getCommentsPost(0,$C->NUM_COMMENTS_PER_POST, $D->idpost);
		$D->numcomments = count($allcommentspost);
		
		$allcommentspost = array_reverse($allcommentspost);	
		
		foreach($allcommentspost as $onecomment){
			$D->o_comment = stripslashes($onecomment->comment);
			$D->o_username = stripslashes($onecomment->username);
			$D->o_firstname = stripslashes($onecomment->firstname);
			$D->o_lastname = stripslashes($onecomment->lastname);
			$D->o_ucode = $onecomment->ucode;
			$D->o_nameUser = (empty($D->o_firstname) || empty($D->o_lastname))?stripslashes($D->o_username):(stripslashes($D->o_firstname).' '.stripslashes($D->o_lastname));
			$D->o_whendate = $onecomment->whendate;
			$D->o_avatar =  empty($onecomment->avatar)?$C->AVATAR_DEFAULT:$onecomment->avatar;
			$D->o_idcomment = $onecomment->idcomment;
			$D->o_idUser = $onecomment->iduser;
			$D->o_idpost = $D->idpost;
			$D->o_idUserOwner = $D->idUser;
			$D->o_codepost = $D->codepost;
			$D->htmlcommentspost .= $this->load_template('__onecomment-post.php', FALSE);
		}
		unset($onecomment);


		$D->htmlpostshare = '';
		if ($D->isShare == 1) {

			$D->codepostSh = $this->network->getCodePost($D->idpostShared);
			$onePostSh = new post($D->codepostSh);
			if (!$onePostSh->error) {
				$D->a_dateSh = $onePostSh->whendate;
				$D->idUserSh = $onePostSh->iduser;
				$D->typepostSh = $onePostSh->typepost;
				$D->postSh = stripslashes($onePostSh->post);
				$D->valueattachSh = $onePostSh->valueattach;
				$D->whoseeSh = $onePostSh->whosee;

				$usSh = $this->network->get_user_by_id($D->idUserSh);
				$D->userNameSh = $usSh->username;
				$D->nameUserSh = (empty($usSh->firstname) || empty($usSh->lastname))?$usSh->username:($usSh->firstname.' '.$usSh->lastname);
				$D->codeUserSh = $usSh->code;
				$D->userAvatarSh = $usSh->avatar;
				
				$D->withOtherSh = 0;
				if ($onePostSh->id_wall != $onePostSh->uiduser && $onePostSh->posted_in == 0) {
					$wallsecSh = $this->network->infoBasicWall($onePostSh->posted_in, $onePostSh->id_wall);
					$D->other_codeSh = $wallsecSh->code;
					$D->other_userNameSh = $wallsecSh->username;
					$D->other_nameUserSh = (empty($wallsecSh->firstname) || empty($wallsecSh->lastname))?$wallsecSh->username:($wallsecSh->firstname.' '.$wallsecSh->lastname);
					$D->withOtherSh = 1;
				}				

				$D->htmlpostshare .= $this->load_template('__one-share-post.php', FALSE);//'Share';
			} else {
				$D->idpostShared = $D->idpost;
				$D->htmlpostshare .= $this->load_template('__one-share-post-nofound.php', FALSE);
			}
			unset($onePostSh);
		}
		
		if ($D->isShare == 1) $D->htmlResult .= $this->load_template('__one-post-shared.php', FALSE);
		else $D->htmlResult .= $this->load_template('__one-post.php', FALSE);

	}
	
	unset($theposts, $onepost);

	//show creation day of page
	if ($D->totalactivities<=$C->NUM_ACTIVITIES_PAGE) $D->htmlResult .= $this->load_template('__page-info-register.php', FALSE);
	///////////////////////////////////////

	/*************************************************************************/


	$D->page_title = $D->titlePage.' - '.$C->SITE_TITLE;
		
	$D->optionactive = 1;
	$this->load_template('page.php');
?>