<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain group data profile
	$D->group = $this->network->get_group_by_id(intval($this->params->idgroup));
	if( !$D->group ) $this->redirect('dashboard');
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/
	
	// needed before proceeding
	require_once('_all-required-group.php');
	
	/*************************************************************************/
	
	if ($D->show_profile == 1) {
	
		//We load the likes
		$D->totalmembers = $this->db2->fetch_field('
		SELECT count(groups_members.iduser) FROM users, groups_members 
		WHERE 
		groups_members.iduser=users.iduser 
		AND status=1
		AND groups_members.idgroup='.$D->group->idgroup);
		
		$r = $this->db2->query('
		SELECT users.iduser, code, firstname, lastname, username, avatar, num_posts, num_friends, verified 
		FROM users, groups_members 
		WHERE 
		groups_members.iduser=users.iduser 
		AND status=1
		AND groups_members.idgroup='.$D->group->idgroup.' 
		ORDER BY when_accepted DESC 
		LIMIT 0,'.$C->NUM_MEMBERS_PAGE);
	
		$D->nummembers = $this->db2->num_rows();
	
		$D->htmlMembers = '';
		
		while( $obj = $this->db2->fetch_object($r) ) {
			$D->isThisUserVerified = $obj->verified==1?TRUE:FALSE;
			$D->f_name = (empty($obj->firstname) || empty($obj->lastname))?stripslashes($obj->username):(stripslashes($obj->firstname).' '.stripslashes($obj->lastname));
			$D->f_codeuser = $obj->code;
			$D->f_avatar = $obj->avatar;
			$D->f_numfriends = $obj->num_friends;
			$D->f_username = $obj->username;
			$D->htmlMembers .= $this->load_template('__group-one-member.php', FALSE);
		}
		
		unset($r, $obj);
		
	} else {
		$this->redirect($C->SITE_URL); // group is secret
	}

	/*************************************************************************/
	
	$D->page_title = $D->nameGroup.' - '.$C->SITE_TITLE;
	
	$D->optionactive = 0;

	$this->load_template('members.php');
?>