<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain page data profile
	$D->page = $this->network->get_page_by_id(intval($this->params->idpage));
	if( !$D->page ) $this->redirect('home');
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/
	
	// needed before proceeding
	require_once('_all-required-page.php');
	
	/*************************************************************************/


	//We load the likes
	$D->totallikes = $this->db2->fetch_field('
	SELECT count(pages_likes.iduser) FROM users, pages_likes 
	WHERE 
	pages_likes.iduser=users.iduser 
	AND pages_likes.idpage='.$D->page->idpage);
	
	$r = $this->db2->query('
	SELECT users.iduser, code, firstname, lastname, username, avatar, num_posts, num_friends, verified 
	FROM users, pages_likes 
	WHERE 
	pages_likes.iduser=users.iduser 
	AND pages_likes.idpage='.$D->page->idpage.' 
	ORDER BY whendate DESC 
	LIMIT 0,'.$C->NUM_LIKES_PAGE);

	$D->numlikes = $this->db2->num_rows();

	$D->htmlLikes = '';
	
	while( $obj = $this->db2->fetch_object($r) ) {
		$D->isThisUserVerified = $obj->verified==1?TRUE:FALSE;
		$D->f_name = (empty($obj->firstname) || empty($obj->lastname))?stripslashes($obj->username):(stripslashes($obj->firstname).' '.stripslashes($obj->lastname));
		$D->f_codeuser = $obj->code;
		$D->f_avatar = $obj->avatar;
		$D->f_numfriends = $obj->num_friends;
		$D->f_username = $obj->username;
		$D->htmlLikes .= $this->load_template('__page-one-like.php', FALSE);
	}
	
	unset($r, $obj);

	/*************************************************************************/
	
	$D->page_title = $D->titlePage.' - '.$C->SITE_TITLE;
	
	$D->optionactive = 0;

	$this->load_template('likes.php');
?>