<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain user data profile
	$D->u = $this->network->get_user_by_id(intval($this->params->iduser));
	if( !$D->u ) {
		$this->redirect('dashboard');
	}
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/
	
	// needed before proceeding
	require_once('_all-required-profile.php');
	
	/*************************************************************************/

	// If allowed, it loaded data required for this section
	if ($D->show_profile==1) {

		//We load the friends
		$D->totalfriends = $this->db2->fetch_field('SELECT count(iduser) FROM users, friends WHERE accepted<>0 AND ((user1=iduser AND user2='.$D->u->iduser.') OR (user1='.$D->u->iduser.' AND user2=iduser))');
		
		$r = $this->db2->query('SELECT iduser, code, firstname, lastname, username, avatar, num_posts, num_friends, verified FROM users, friends WHERE  accepted<>0 AND ((user1=iduser AND user2='.$D->u->iduser.') OR (user1='.$D->u->iduser.' AND user2=iduser)) ORDER BY accepted DESC LIMIT 0,'.$C->NUM_FRIENDS_PAGE);

		$D->numfriends = $this->db2->num_rows();

		$D->htmlFriends = '';
		
		while( $obj = $this->db2->fetch_object($r) ) {
			$D->isThisUserVerified = $obj->verified==1?TRUE:FALSE;
			$D->f_name = (empty($obj->firstname) || empty($obj->lastname))?stripslashes($obj->username):(stripslashes($obj->firstname).' '.stripslashes($obj->lastname));
			$D->f_codeuser = $obj->code;
			$D->f_avatar = $obj->avatar;
			$D->f_numfriends = $obj->num_friends;
			$D->f_username = $obj->username;
			$D->htmlFriends .= $this->load_template('__profile-one-friend.php', FALSE);
		}
		
		unset($r, $obj);
	}

	/*************************************************************************/
	
	$D->page_title = $D->nameUser.' - '.$this->lang('profile_friends_title').' - '.$C->SITE_TITLE;
	
	$D->optionactive = 0;

	$this->load_template('friends.php');
?>