<?php

	if( !$this->network->id ) {
		$this->redirect('home');
	}
	
	// We check if the site is open to all
	if ($C->PROTECT_OUTSIDE_PAGES && !$this->user->is_logged) {
		$this->redirect('home');
	}
	
	// Obtain user data profile
	$D->u = $this->network->get_user_by_id(intval($this->params->iduser));
	if( !$D->u ) {
		$this->redirect('dashboard');
	}
	
	/*************************************************************************/
	// needed before proceeding
	require_once('_all-required-language.php');
	
	/*************************************************************************/

	$this->load_langfile('global/global.php');	
	$this->load_langfile('outside/profile.php');

	/*************************************************************************/

	// needed before proceeding
	require_once('_all-required-profile.php');
	
	/*************************************************************************/

	$D->optionactive = 7;
	$D->page_title = $D->nameUser.' - '.$this->lang('profile_albums_title').' - '.$C->SITE_TITLE;

	if ($D->show_profile==1) {
		
		$D->codalbum = '';
		if ($this->param('codalbum')) $D->codalbum = $this->param('codalbum');
	
		if (!empty($D->codalbum)) {
			
			if ($D->friendship == 1 || $D->is_my_profile) {
				$cadSee = ' (who_see=0 OR who_see=1) ';
			} else {
				$cadSee = ' who_see=0 ';
			}
			
			$D->codalbum = $this->db2->e($D->codalbum);
			$r = $this->db2->query("
			SELECT * FROM albums 
			WHERE code='".$D->codalbum."' 
			AND iduser=".$D->u->iduser." 
			AND ".$cadSee." 
			LIMIT 1");
			
			if (!$obj = $this->db2->fetch_object($r)) $this->redirect($C->SITE_URL.$D->u->username.'/albums');
			else $D->album = $obj;
			
			$D->idalbum = $D->album->idalbum;
			$D->whosee = $D->album->who_see;
			$D->namealbum = stripslashes($D->album->namealbum);
	
			//We load the photos of albums
			$D->totalphotos = $this->db2->fetch_field('SELECT COUNT(idalbum) FROM albums_photos WHERE idalbum='.$D->idalbum);
			$r = $this->db2->query('SELECT * FROM albums_photos WHERE idalbum='.$D->idalbum.' ORDER BY whendate DESC LIMIT 0,'.$C->NUM_PHOTOS_PAGE);
		
			$D->numphotos = $this->db2->num_rows();
			
			$D->htmlPhotosAlbums = '';
			
			while( $obj = $this->db2->fetch_object($r) ) {
				$D->codephoto = $obj->code;
				$D->idphoto = $obj->idphoto;
				$D->photofile = $obj->photo;
				$D->htmlPhotosAlbums .= $this->load_template('__one-photo-albums-profile.php', FALSE);
			}
				
			unset($r, $obj);	

			$this->load_template('albums-details.php');

		} else {
		
			$D->htmlResult = '';
	
			if ($D->friendship == 1 || $D->is_my_profile) {
				$cadSee = ' (who_see=0 OR who_see=1) ';
			} else {
				$cadSee = ' who_see=0 ';
			}
			
			$D->totalalbums = $this->db2->fetch_field('
			SELECT count(idalbum) 
			FROM albums 
			WHERE 
			iduser='.$D->u->iduser.' 
			AND '.$cadSee);		
			
			$thealbums = $this->db2->fetch_all('
			SELECT * 
			FROM albums  
			WHERE 
			iduser='.$D->u->iduser.' 
			AND '.$cadSee.' 
			ORDER BY created DESC 
			LIMIT 0,'.$C->NUM_ALBUMS_PAGE);
	
			$D->numalbums = count($thealbums);
			
			$D->htmlAlbums = '';
			
			foreach($thealbums as $onealbum) {
				$D->namealbum = stripslashes($onealbum->namealbum);
				$D->numphotos = $onealbum->numphotos;
				$D->codealbum = $onealbum->code;
				$D->idalbum = $onealbum->idalbum;
				$D->whosee = $onealbum->who_see;
				
				if ($D->numphotos > 0) {
					$D->coveralbum = $this->db1->fetch_field('SELECT photo FROM albums_photos WHERE idalbum='.$D->idalbum.' ORDER BY whendate DESC LIMIT 1');
				}
				
				$D->isMyAlbum = FALSE;
				if ($D->is_logged == 1) {
					$D->isMyAlbum = $onealbum->iduser == $this->user->id ? TRUE : FALSE;
				}
				
				$D->htmlAlbums .= $this->load_template('__one-albums-profile.php', FALSE);
			}
			
			unset($onealbum);

			$this->load_template('albums.php');

		}
		
		
	} else {
		
		$this->load_template('albums.php');
	
	}
?>