<?php
	
	class user
	{
		public $id;
		public $network;
		public $is_logged;
		public $info;
		public $sess;
		
		public function __construct()
		{
			$this->id	= FALSE;
			$this->network	= & $GLOBALS['network'];
			$this->db1		= & $GLOBALS['db1'];
			$this->db2		= & $GLOBALS['db2'];
			$this->info		= new stdClass;
			$this->is_logged	= FALSE;
			$this->sess		= array();
		}
		
		public function load()
		{
			if( ! $this->network->id ) {
				return FALSE;
			}
			
			global $C;
			$this->_session_start();
			if( isset($this->sess['IS_LOGGED'], $this->sess['LOGGED_USER']) && $this->sess['IS_LOGGED'] && $this->sess['LOGGED_USER'] ) { 
				$u	= & $this->sess['LOGGED_USER'];
				$u	= $this->network->get_user_by_id($u->iduser);
				if( ! $u ) {
					return FALSE;
				}
				if( $this->network->id && $this->network->id == $u->network_id ) {
					$this->is_logged	= TRUE;
					$this->info	= & $u;
					$this->id	= $this->info->iduser;
					$this->db2->query('UPDATE users SET lastclick="'.time().'" WHERE iduser='.$this->id.' LIMIT 1');

					if( $this->info->active == 0 ) {
						$this->logout();
						return FALSE;
					}
					return $this->id;
				}
			}
			return FALSE;
		}
		
		private function _session_start()
		{
			if( ! $this->network->id ) {
				return FALSE;
			}
			if( ! isset($_SESSION['NETWORKS_USR_DATA_FRL']) ) {
				$_SESSION['NETWORKS_USR_DATA_FRL']	= array();
			}
			if( ! isset($_SESSION['NETWORKS_USR_DATA_FRL'][$this->network->id]) ) {
				$_SESSION['NETWORKS_USR_DATA_FRL'][$this->network->id]	= array();
			}
			$this->sess	= & $_SESSION['NETWORKS_USR_DATA_FRL'][$this->network->id];
		}
		
		public function login($login, $pass)
		{
			global $C;
			if( ! $this->network->id ) {
				return FALSE;
			}
			if( $this->is_logged ) {
				return FALSE;
			}
			if( empty($login) ) {
				return FALSE;
			}
			$login = $this->db2->escape($login);
			$pass = $this->db2->escape($pass);
			
			
			// First check if there is a user with email or username
			$r = $this->db2->query("SELECT iduser, password, salt FROM users WHERE (email='".$login."' OR username='".$login."') AND active=1 LIMIT 1");

			if( ! $obj = $this->db2->fetch_object() ) {
				return FALSE;
			}

			$password = $obj->password;
			$salt = $obj->salt;

			$enteredkey = hash('sha512', $salt.$pass);

			if ($password != $enteredkey) return FALSE;
			
			$this->info	= $this->network->get_user_by_id($obj->iduser, TRUE);
			if( ! $this->info ) {
				return FALSE;
			}
			$this->is_logged = TRUE;
			$this->sess['IS_LOGGED'] = TRUE;
			$this->sess['LOGGED_USER'] = & $this->info;
			$this->id = $this->info->iduser;
			
			$ip	= $this->db2->escape( ip2long($_SERVER['REMOTE_ADDR']) );
			$this->db2->query('UPDATE users SET previousaccess=lastaccess, ippreviousaccess=iplastaccess, lastaccess="'.time().'", iplastaccess="'.$ip.'", lastclick="'.time().'" WHERE iduser='.$this->id.' LIMIT 1');

			$this->sess['total_pageviews']	= 0;
			return TRUE;
		}
		
		public function loginSocial($login, $oauth)
		{
			global $C;
			if( ! $this->network->id ) {
				return FALSE;
			}
			if( $this->is_logged ) {
				return FALSE;
			}
			if( empty($login) ) {
				return FALSE;
			}
			$login = $this->db2->escape($login);			
			
			// First check if there is a user with email or username
			$r = $this->db2->query("SELECT iduser FROM users WHERE (email='".$login."' OR username='".$login."') AND auth='".$oauth."' AND active=1 LIMIT 1");

			if( ! $obj = $this->db2->fetch_object() ) {
				return FALSE;
			}
			
			$this->info	= $this->network->get_user_by_id($obj->iduser, TRUE);
			if( ! $this->info ) {
				return FALSE;
			}
			$this->is_logged = TRUE;
			$this->sess['IS_LOGGED'] = TRUE;
			$this->sess['LOGGED_USER'] = & $this->info;
			$this->id = $this->info->iduser;
			
			$ip	= $this->db2->escape( ip2long($_SERVER['REMOTE_ADDR']) );
			$this->db2->query('UPDATE users SET previousaccess=lastaccess, ippreviousaccess=iplastaccess, lastaccess="'.time().'", iplastaccess="'.$ip.'", lastclick="'.time().'" WHERE iduser='.$this->id.' LIMIT 1');

			$this->sess['total_pageviews']	= 0;
			return TRUE;
		}
		
				
		public function logout()
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$this->db2->query('UPDATE users SET lastclick=0 WHERE iduser='.$this->id.' LIMIT 1');
			$this->sess['IS_LOGGED']	= FALSE;
			$this->sess['LOGGED_USER']	= NULL;
			unset($this->sess['IS_LOGGED']);
			unset($this->sess['LOGGED_USER']);
			$this->id	= FALSE;
			$this->info	= new stdClass;
			$this->is_logged	= FALSE;
		}
		
		public function follow($whom_id, $how=TRUE)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($whom_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			if ($this->friendship($whom_id) != 1) return FALSE;
			
			$f	= $this->network->verifies_follower($this->id, $whom_id);
			if( $f && $how==TRUE ) {
				return TRUE;
			}
			
			if( !$f && $how==FALSE ) {
				return TRUE;
			}
			
			if( $how == TRUE ) {
				$this->db2->query('INSERT INTO relations SET subscriber='.$this->id.', leader='.$whom_id.', rltdate="'.time().'"');
				$this->db2->query('UPDATE users SET num_followers=num_followers+1, num_notifications=num_notifications+1 WHERE iduser="'.$whom_id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_following=num_following+1, num_activities=num_activities+1 WHERE iduser="'.$this->id.'" LIMIT 1');
				
				$this->db2->query('INSERT INTO activities SET iduser='.$this->id.', action=1, iduser2='.$whom_id.', iditem=0, date="'.time().'"');
				$this->db2->query("INSERT INTO notifications SET notif_type=1, to_user_id=".$whom_id.", from_user_id=".$this->id.", date='".time()."'");				
			} else {
				$this->db2->query('DELETE FROM relations WHERE subscriber='.$this->id.' AND type_leader=0 AND leader='.$whom_id);
				$this->db2->query('UPDATE users SET num_followers=num_followers-1  WHERE iduser="'.$whom_id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_following=num_following-1, num_activities=num_activities-1 WHERE iduser="'.$this->id.'" LIMIT 1');

				$this->db2->query("DELETE FROM activities WHERE iduser=".$this->id." AND action=1 AND iduser2=".$whom_id);
				$this->db2->query("DELETE FROM notifications WHERE notif_type=1 AND to_user_id=".$whom_id." AND from_user_id=".$this->id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $whom->num_notifications) $numdeleted = $whom->num_notifications;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.'  WHERE iduser="'.$whom_id.'" LIMIT 1');
			}
			
			return TRUE;
		}
		
		public function if_follow_user($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE leader='.$user_id.' AND type_leader=0 AND subscriber='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}
		
		public function if_user_follows_me($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE leader='.$this->id.' AND type_leader=0 AND subscriber='.$user_id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}
		
		public function if_follow_page($idpage)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE leader='.$idpage.' AND type_leader=1 AND subscriber='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}
		
		public function if_like_page($idpage)
		{
			if( ! $this->is_logged ) {
				return 0;
			}
			$res = $this->db2->fetch_field('SELECT id FROM pages_likes WHERE idpage='.$idpage.' AND iduser='.$this->id.' LIMIT 1');
			return $res? 1 : 0;
		}

		public function if_admin_page($idpage)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch_field('SELECT id FROM pages_admin WHERE idpage='.$idpage.' AND iduser='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}

		public function if_admin_group($idgroup)
		{
			if( ! $this->is_logged ) return FALSE;

			$res = $this->db2->fetch_field('SELECT id FROM groups_members WHERE idgroup='.$idgroup.' AND is_admin=1 AND iduser='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}

		public function if_iam_member_group($idgroup)
		{
			if( ! $this->is_logged ) return FALSE;

			$res = $this->db2->fetch_field('SELECT id FROM groups_members WHERE idgroup='.$idgroup.' AND status=1 AND iduser='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}

		public function if_follow_group($idgroup)
		{
			if( ! $this->is_logged ) return FALSE;

			$res = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE leader='.$idgroup.' AND type_leader=2 AND subscriber='.$this->id.' LIMIT 1');
			return $res? TRUE : FALSE;
		}
				
		public function write_pageview()
		{
			global $C;
			
			if( ! $this->is_logged || ! $C->write_page_view_is_active ) {
				return FALSE;
			}
			$this->sess['total_pageviews']	++;
			$dt	= date('Y-m-d H');
			$this->db2->query('UPDATE users_pageviews SET pageviews=pageviews+1 WHERE iduser="'.$this->id.'" AND date="'.$dt.'" LIMIT 1');
			if( $this->db2->affected_rows() == 0 ) {
				$this->db2->query('INSERT INTO users_pageviews SET pageviews=1, iduser="'.$this->id.'", date="'.$dt.'" ');
			}
		}
		
		public function get_saved_searches($force_refresh=FALSE)
		{
			if( ! $this->is_logged ) {
				return array();
			}	
			global $C;
			
			$data = array();
			$this->db2->query('SELECT id, search_key, search_string FROM searches WHERE user_id="'.$this->id.'" ORDER BY id DESC');
			while($tmp = $this->db2->fetch_object()) {
				$tmp->search_key	= stripslashes($tmp->search_key);
				$tmp->search_string	= stripslashes($tmp->search_string);
				$data[$tmp->id]		= $tmp;
			}
			
			return $data;
		}

		
		public function friendship($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch('SELECT * FROM friends WHERE (user1='.$user_id.' AND user2='.$this->id.') OR (user2='.$user_id.' AND user1='.$this->id.') LIMIT 1');
			
			$friendsh = 0; // No, they are not friends.
			if ($res) {
				if ($res->accepted != 0) $friendsh = 1; // Yes, they are friends.
				else {
					if ($res->user1 == $this->id) $friendsh = 2; // You've sent a friend request.
					else if ($res->user1 == $user_id) $friendsh = 3; // He has sent you a friend request.
				}
			}
			
			return $friendsh;
		}
		
		
		public function sendFriendRequest($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($user_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			$f	= $this->network->verifyFriendship($this->id, $user_id, 1);
			if( $f ) {
				return FALSE;
			}

			$this->db2->query('INSERT INTO friends SET user1='.$this->id.', user2='.$user_id.', shipdate="'.time().'"');

			$this->db2->query('UPDATE users SET num_notifications=num_notifications+1 WHERE iduser="'.$user_id.'" LIMIT 1');
			$this->db2->query('UPDATE users SET num_activities=num_activities+1 WHERE iduser="'.$this->id.'" LIMIT 1');

			$this->db2->query('INSERT INTO activities SET iduser='.$this->id.', action=6, iduser2='.$user_id.', iditem=0, typeitem=0, date="'.time().'"');
			$this->db2->query("INSERT INTO notifications SET notif_type=5, notif_object_type=0, to_user_id=".$user_id.", from_user_id=".$this->id.", date='".time()."'");				

			return TRUE;
		}
		
		public function deleteRequestFriend($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($user_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			$f	= $this->network->verifyFriendship($this->id, $user_id, 2);
			if( !$f ) {
				return FALSE;
			}
						
			$this->db2->query('DELETE FROM friends WHERE user2='.$this->id.' AND user1='.$user_id);
			
			$this->db2->query('UPDATE users SET num_activities=num_activities-1 WHERE iduser="'.$user_id.'" LIMIT 1');

			$this->db2->query("DELETE FROM activities WHERE iduser2=".$this->id." AND action=6 AND iduser=".$user_id);
			
			$this->db2->query("DELETE FROM notifications WHERE notif_type=5 AND to_user_id=".$this->id." AND from_user_id=".$user_id);
			$numdeleted = $this->db2->affected_rows();
			if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
			$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');			

			return TRUE;
		}

		public function cancelRequestFriend($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($user_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			$f	= $this->network->verifyFriendship($this->id, $user_id, 3);
			if( !$f ) {
				return FALSE;
			}
			
			$num_notifications_user_id = $this->db2->fetch_field('SELECT num_notifications FROM users WHERE iduser='.$user_id.' LIMIT 1');
						
			$this->db2->query('DELETE FROM friends WHERE user1='.$this->id.' AND user2='.$user_id);
			
			$this->db2->query('UPDATE users SET num_activities=num_activities-1 WHERE iduser="'.$this->id.'" LIMIT 1');

			$this->db2->query("DELETE FROM activities WHERE iduser=".$this->id." AND action=6 AND iduser2=".$user_id);
			
			$this->db2->query("DELETE FROM notifications WHERE notif_type=5 AND to_user_id=".$user_id." AND from_user_id=".$this->id);
			$numdeleted = $this->db2->affected_rows();
			if ($numdeleted > $num_notifications_user_id) $numdeleted = $num_notifications_user_id;
			$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$user_id.'" LIMIT 1');			

			return TRUE;
		}

		public function confirmRequestFriend($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($user_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			$f	= $this->network->verifyFriendship($this->id, $user_id, 4);
			if( !$f ) {
				return FALSE;
			}

			//friending
			$this->db2->query('UPDATE friends SET accepted="'.time().'" WHERE user2='.$this->id.' AND user1='.$user_id);
			
			$this->db2->query("DELETE FROM notifications WHERE notif_type=5 AND to_user_id=".$this->id." AND from_user_id=".$user_id);
			$numdeleted = $this->db2->affected_rows();
			if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
			$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');

			$this->db2->query('UPDATE users SET num_friends=num_friends+1, num_notifications=num_notifications+1 WHERE iduser="'.$user_id.'" LIMIT 1');
			$this->db2->query('UPDATE users SET num_friends=num_friends+1, num_activities=num_activities+1 WHERE iduser="'.$this->id.'" LIMIT 1');

			$this->db2->query('INSERT INTO activities SET iduser='.$this->id.', action=7, iduser2='.$user_id.', iditem=0, typeitem=0, date="'.time().'"');
			$this->db2->query("INSERT INTO notifications SET notif_type=6, notif_object_type=0, to_user_id=".$user_id.", from_user_id=".$this->id.", date='".time()."'");				

			//Following
			$this->db2->query('INSERT INTO relations SET subscriber='.$this->id.', leader='.$user_id.', rltdate="'.time().'"');
			$this->db2->query('INSERT INTO relations SET subscriber='.$user_id.', leader='.$this->id.', rltdate="'.time().'"');
			
			$this->db2->query('UPDATE users SET num_followers=num_followers+1, num_following=num_following+1, num_activities=num_activities+1, num_notifications=num_notifications+1 WHERE iduser="'.$user_id.'" LIMIT 1');
			
			$this->db2->query('UPDATE users SET num_followers=num_followers+1, num_following=num_following+1, num_activities=num_activities+1, num_notifications=num_notifications+1 WHERE iduser="'.$this->id.'" LIMIT 1');
			
			$this->db2->query('INSERT INTO activities SET iduser='.$this->id.', action=1, iduser2='.$user_id.', iditem=0, date="'.time().'"');
			$this->db2->query('INSERT INTO activities SET iduser='.$user_id.', action=1, iduser2='.$this->id.', iditem=0, date="'.time().'"');
			
			$this->db2->query("INSERT INTO notifications SET notif_type=1, to_user_id=".$user_id.", from_user_id=".$this->id.", date='".time()."'");
			$this->db2->query("INSERT INTO notifications SET notif_type=1, to_user_id=".$this->id.", from_user_id=".$user_id.", date='".time()."'");

			return TRUE;
		}


		public function unFriend($user_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$whom	= $this->network->get_user_by_id($user_id);
			if( ! $whom ) {
				return FALSE;
			}
			
			$f	= $this->network->verifyFriendship($this->id, $user_id, 5);
			if( !$f ) {
				return FALSE;
			}

			$therearefriend = $this->db2->fetch_field('SELECT id FROM friends WHERE user2='.$this->id.' AND user1='.$user_id.' LIMIT 1');
			if ($therearefriend) {

				$this->db2->query('DELETE FROM friends WHERE user2='.$this->id.' AND user1='.$user_id.' LIMIT 1');
			
				$this->db2->query("DELETE FROM notifications WHERE notif_type=6 AND to_user_id=".$user_id." AND from_user_id=".$this->id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $whom->num_notifications) $numdeleted = $whom->num_notifications;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$user_id.'" LIMIT 1');
	
				$this->db2->query('UPDATE users SET num_friends=num_friends-1, num_activities=num_activities-1 WHERE iduser="'.$user_id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_friends=num_friends-1, num_activities=num_activities-1 WHERE iduser="'.$this->id.'" LIMIT 1');
				
				$this->db2->query("DELETE FROM activities WHERE action=7 AND iduser=".$this->id." AND iduser2=".$user_id.' LIMIT 1');
				$this->db2->query("DELETE FROM activities WHERE action=6 AND iduser=".$user_id." AND iduser2=".$this->id.' LIMIT 1');

			}

			$therearefriend = $this->db2->fetch_field('SELECT id FROM friends WHERE user2='.$user_id.' AND user1='.$this->id.' LIMIT 1');
			if ($therearefriend) {

				$this->db2->query('DELETE FROM friends WHERE user2='.$user_id.' AND user1='.$this->id.' LIMIT 1');
			
				$this->db2->query("DELETE FROM notifications WHERE notif_type=6 AND to_user_id=".$this->id." AND from_user_id=".$user_id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');
	
				$this->db2->query('UPDATE users SET num_friends=num_friends-1, num_activities=num_activities-1 WHERE iduser="'.$this->id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_friends=num_friends-1, num_activities=num_activities-1 WHERE iduser="'.$user_id.'" LIMIT 1');
				
				$this->db2->query("DELETE FROM activities WHERE action=7 AND iduser=".$user_id." AND iduser2=".$this->id.' LIMIT 1');
				$this->db2->query("DELETE FROM activities WHERE action=6 AND iduser=".$this->id." AND iduser2=".$user_id.' LIMIT 1');

			}

			// delete following
			$therearefollow = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE subscriber='.$this->id.' AND type_leader=0 AND leader='.$user_id.' LIMIT 1');
			if ($therearefollow) {

				$this->db2->query('DELETE FROM relations WHERE subscriber='.$this->id.' AND type_leader=0 AND leader='.$user_id);
				
				$this->db2->query('UPDATE users SET num_followers=num_followers-1  WHERE iduser="'.$user_id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_following=num_following-1, num_activities=num_activities-1 WHERE iduser="'.$this->id.'" LIMIT 1');

				$this->db2->query("DELETE FROM activities WHERE iduser=".$this->id." AND action=1 AND iduser2=".$user_id);
				$this->db2->query("DELETE FROM notifications WHERE notif_type=1 AND to_user_id=".$user_id." AND from_user_id=".$this->id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $whom->num_notifications) $numdeleted = $whom->num_notifications;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$user_id.'" LIMIT 1');

			}
			
			$therearefollow = $this->db2->fetch_field('SELECT idrelation FROM relations WHERE subscriber='.$user_id.' AND type_leader=0 AND leader='.$this->id.' LIMIT 1');
			if ($therearefollow) {

				$this->db2->query('DELETE FROM relations WHERE subscriber='.$user_id.' AND type_leader=0 AND leader='.$this->id);

				$this->db2->query('UPDATE users SET num_followers=num_followers-1  WHERE iduser="'.$this->id.'" LIMIT 1');
				$this->db2->query('UPDATE users SET num_following=num_following-1, num_activities=num_activities-1 WHERE iduser="'.$user_id.'" LIMIT 1');

				$this->db2->query("DELETE FROM activities WHERE iduser=".$user_id." AND action=1 AND iduser2=".$this->id);
				$this->db2->query("DELETE FROM notifications WHERE notif_type=1 AND to_user_id=".$this->id." AND from_user_id=".$user_id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');
				
			}

			return TRUE;
		}
		
		
		public function membership($group_id)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			$res = $this->db2->fetch('SELECT * FROM groups_members WHERE idgroup='.$group_id.' AND iduser='.$this->id.' LIMIT 1');
			
			$membership = 0; // No, no is member.
			if ($res) {
				if ($res->status != 0) $membership = 1; // Yes, is member.
				else {
					if ($res->iduser == $this->id) $membership = 2; // You've sent a member request.
				}
			}
			return $membership;
		}

		public function sendMemberRequest($idgroup)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}

			$numReg = $this->db1->fetch_field('SELECT count(id) FROM groups_members WHERE iduser='.$this->id.' AND idgroup='.$idgroup);
			if ($numReg != 0) return FALSE;
			else {
				$res = $this->db1->fetch_field('SELECT count(idgroup) FROM groups WHERE idgroup='.$idgroup);
				if ($res == 0) return FALSE;
	
				$res = $this->db1->fetch_field('SELECT count(id) FROM groups_members WHERE idgroup='.$idgroup.' AND iduser='.$this->id);
				if ($res != 0) return FALSE;
				
				$idcreator = $this->db1->fetch_field('SELECT idcreator FROM groups WHERE idgroup='.$idgroup);
	
				$this->db2->query('INSERT INTO groups_members SET iduser='.$this->id.', idgroup='.$idgroup.', when_request="'.time().'"');
	
				$this->db2->query('UPDATE users SET num_notifications=num_notifications+1 WHERE iduser='.$idcreator.' LIMIT 1');
	
				$this->db2->query("INSERT INTO notifications SET notif_type=10, notif_object_type=4, notif_object_id=".$idgroup.", to_user_id=".$idcreator.", from_user_id=".$this->id.", date='".time()."'");				
	
				return TRUE;
			}
		}
		
		public function cancelMemberRequest($idgroup)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}

			$numReg = $this->db1->fetch_field('SELECT count(id) FROM groups_members WHERE status=0 AND iduser='.$this->id.' AND idgroup='.$idgroup);
			if ($numReg == 0) return FALSE;
			else {
							
				$this->db2->query('DELETE FROM groups_members WHERE iduser='.$this->id.' AND idgroup='.$idgroup);
				
				$idcreator = $this->db1->fetch_field('SELECT idcreator FROM groups WHERE idgroup='.$idgroup);
				$num_notifications_user_id = $this->db2->fetch_field('SELECT num_notifications FROM users WHERE iduser='.$idcreator.' LIMIT 1');
				
				$this->db2->query("DELETE FROM notifications WHERE notif_type=10 AND notif_object_type=4 AND notif_object_id=".$idgroup." AND to_user_id=".$idcreator." AND from_user_id=".$this->id);
				$numdeleted = $this->db2->affected_rows();
				if ($numdeleted > $num_notifications_user_id) $numdeleted = $num_notifications_user_id;
				$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$idcreator.'" LIMIT 1');			
	
				return TRUE;
			}
		}
		
		
		public function leaveGroup($idgroup)
		{
			if( ! $this->is_logged ) {
				return FALSE;
			}
			
			$numReg = $this->db1->fetch_field('SELECT count(id) FROM groups_members WHERE status=1 AND iduser='.$this->id.' AND idgroup='.$idgroup);
			if ($numReg == 0) return FALSE;
			else {
				$this->db2->query('DELETE FROM groups_members WHERE status=1 AND iduser='.$this->id.' AND idgroup='.$idgroup.' LIMIT 1');
							
				
				$hayNotif = $this->db1->fetch_field('SELECT count(idnotification) FROM notifications WHERE notif_type=12 AND notif_object_type=4 AND notif_object_id='.$idgroup.' AND to_user_id='.$this->id);

				
				if ($hayNotif > 0) {
					$this->db1->query("DELETE FROM notifications WHERE notif_type=12 AND notif_object_type=4 AND to_user_id=".$this->id.' AND notif_object_id='.$idgroup);
					$numdeleted = $this->db1->affected_rows();
					
					if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
					$this->db1->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');
					
				} else {

				

					$this->db2->query("DELETE FROM notifications WHERE notif_type=11 AND notif_object_type=4 AND to_user_id=".$this->id." AND from_user_id=".$idgroup);
					$numdeleted = $this->db2->affected_rows();
					if ($numdeleted > $this->info->num_notifications) $numdeleted = $this->info->num_notifications;
					$this->db2->query('UPDATE users SET num_notifications=num_notifications-'.$numdeleted.' WHERE iduser="'.$this->id.'" LIMIT 1');
				
				}
				


				$this->db2->query('UPDATE groups SET num_members=num_members-1 WHERE idgroup='.$idgroup.' LIMIT 1');
				
				$this->db2->query('DELETE FROM relations WHERE subscriber='.$this->id.' AND type_leader=2 AND leader='.$idgroup);
				if ($this->db2->affected_rows()>0) $this->db2->query('UPDATE groups SET num_followers=num_followers-1 WHERE idgroup='.$idgroup.' LIMIT 1');
							
				return TRUE;
			}
		}
		
	}
	
?>