<?php
	
	class network
	{
		public $id;
		public $info;
		public $is_private;
		public $is_public;
		
		public function __construct()
		{
			$this->id	= FALSE;
			$this->C	= new stdClass;
			$this->info	= new stdClass;
			$this->db1		= & $GLOBALS['db1'];
			$this->db2		= & $GLOBALS['db2'];
		}

		public function load()
		{
			if( $this->id ) {
				return FALSE;
			}
			$this->load_network_settings();
			$this->info	= (object) array(
				'id'	=> 1,
			);
			$this->is_private	= FALSE;
			$this->is_public	= TRUE;
			$this->id	= $this->info->id;
			return $this->id;
		}

		public function load_network_settings()
		{
			$db	= &$this->db1;
			$r	= $db->query('SELECT * FROM settings', FALSE);
			while($obj = $db->fetch_object($r)) {
				$this->C->{$obj->word}	= stripslashes($obj->value);
			}
			
			global $C;
			foreach($this->C as $k=>$v) {
				$C->$k	= & $this->C->$k;
			}
			
			if( !isset($C->SITE_TITLE) || empty($C->SITE_TITLE) ) {
				$C->SITE_TITLE	= 'Friendly';
			}
			$C->OUTSIDE_SITE_TITLE	= $C->SITE_TITLE;
		}

		public function get_user_by_username($uname, $force_refresh=FALSE, $return_id=FALSE)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			if( empty($uname) ) {
				return FALSE;
			}

			$uid	= FALSE;
			$r	= $this->db2->query('SELECT iduser FROM users WHERE username="'.$this->db2->e($uname).'" LIMIT 1', FALSE);
			if( $o = $this->db2->fetch_object($r) ) {
				$uid	= intval($o->iduser);
				return $return_id ? $uid : $this->get_user_by_id($uid);
			}
			return FALSE;
		}

		public function get_user_by_email($email, $force_refresh=FALSE, $return_id=FALSE)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			if( ! is_valid_email($email) ) {
				return FALSE;
			}

			$uid	= FALSE;
			$r	= $this->db2->query('SELECT iduser FROM users WHERE email="'.$this->db2->escape($email).'" LIMIT 1', FALSE);
			if( $o = $this->db2->fetch_object($r) ) {
				$uid	= intval($o->iduser);
				return $return_id ? $uid : $this->get_user_by_id($uid);
			}

			return FALSE;
		}

		public function get_user_by_id($uid, $force_refresh=FALSE)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$uid	= intval($uid);
			if( 0 == $uid ) {
				return FALSE;
			}

			$r	= $this->db2->query('SELECT * FROM users WHERE iduser="'.$uid.'" LIMIT 1', FALSE);
			if ($o = $this->db2->fetch_object($r)) {
				$o->active		= intval($o->active);
				$o->firstname	= stripslashes($o->firstname);
				$o->lastname	= stripslashes($o->lastname);
				$o->aboutme	= stripslashes($o->aboutme);
				$o->codecountry	= stripslashes($o->codecountry);
				$o->city	= stripslashes($o->city);
				$o->idregion	= intval($o->idregion);
				$o->network_id	= $this->id;
				$o->user_details	= FALSE;
				return $o;
			}

			return FALSE;
		}

		public function get_page_by_url($url, $return_id=FALSE)
		{
			if( ! $this->id ) return FALSE;
			if( empty($url) ) return FALSE;

			$uid = FALSE;
			$r = $this->db2->query('SELECT idpage FROM pages WHERE url="'.$this->db2->e($url).'" LIMIT 1', FALSE);
			if( $o = $this->db2->fetch_object($r) ) {
				$uid	= intval($o->idpage);
				return $return_id ? $uid : $this->get_page_by_id($uid);
			}
			return FALSE;
		}
		
		public function get_page_by_id($idpage)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$idpage	= intval($idpage);
			if (0 == $idpage) return FALSE;

			$r	= $this->db2->query('SELECT * FROM pages WHERE idpage='.$idpage.' LIMIT 1', FALSE);
			if ($o = $this->db2->fetch_object($r)) {
				$o->status	= intval($o->status);
				$o->title	= stripslashes($o->title);
				$o->url	= $o->url;
				$o->idpage	= intval($o->idpage);
				$o->code	= $o->code;
				return $o;
			}
			return FALSE;
		}
		
		public function get_group_by_url($url, $return_id=FALSE)
		{
			if( ! $this->id ) return FALSE;
			if( empty($url) ) return FALSE;

			$uid = FALSE;
			$r = $this->db2->query('SELECT idgroup FROM groups WHERE url="'.$this->db2->e($url).'" LIMIT 1', FALSE);
			if( $o = $this->db2->fetch_object($r) ) {
				$uid	= intval($o->idgroup);
				return $return_id ? $uid : $this->get_group_by_id($uid);
			}
			return FALSE;
		}
		
		public function get_group_by_id($idgroup)
		{
			if( ! $this->id ) return FALSE;
			
			$idgroup	= intval($idgroup);
			if (0 == $idgroup) return FALSE;

			$r	= $this->db2->query('SELECT * FROM groups WHERE idgroup='.$idgroup.' LIMIT 1', FALSE);
			if ($o = $this->db2->fetch_object($r)) {
				$o->status = intval($o->status);
				$o->name_group = stripslashes($o->name_group);
				$o->url	= $o->url;
				$o->idgroup	= intval($o->idgroup);
				$o->code	= $o->code;
				return $o;
			}
			return FALSE;
		}

		public function get_ads_basic($code)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			return $this->db2->fetch_field('SELECT adsource FROM ads_basic WHERE code="'.$code.'" LIMIT 1');
		}
		
		// Check if $uid1 is a follower of $uid2
		public function verifies_follower($uid1, $uid2)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$uid1 = intval($uid1);
			if( 0 == $uid1 ) {
				return FALSE;
			}

			$uid2 = intval($uid2);
			if( 0 == $uid2 ) {
				return FALSE;
			}
			
			return $this->db2->fetch_field('SELECT idrelation FROM relations WHERE leader='.$uid2.' AND type_leader=0 AND subscriber='.$uid1);
		}

		public function get_user_follows($uid, $type = FALSE)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$uid = intval($uid);
			if( 0 == $uid ) {
				return FALSE;
			}

			$data = new stdClass;
			$data->followers = array();
			$data->follow_users = array();
			
			if( ($type && $type == 'hisfollowers') || ($type === FALSE) ){
				$r	= $this->db2->query('SELECT suscriber FROM relations WHERE leader="'.$uid.'" AND type_leader=0 ORDER BY idrelation DESC', FALSE);
				while($o = $this->db2->fetch_object($r)) {
					$data->followers[intval($o->suscriber)]	= 1;
				}
			}
			if( ($type && $type == 'hefollows') || ($type === FALSE) ){
				$r	= $this->db2->query('SELECT leader FROM relations WHERE suscriber="'.$uid.'" AND type_leader=0 ORDER BY idrelation DESC', FALSE);
				while($o = $this->db2->fetch_object($r)) {
					$data->follow_users[intval($o->leader)]	= 2;
				}
			}
			return $data;
		}

		public function get_country($codecountry)
		{
			return $this->db2->fetch_field('SELECT country FROM country WHERE code="'.$codecountry.'" LIMIT 1');
		}

		public function get_region($idregion)
		{
			return $this->db2->fetch_field('SELECT region FROM country_region WHERE idregion='.$idregion.' LIMIT 1');
		}

		public function isUserVerified($uid)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$uid = intval($uid);
			if( 0 == $uid ) {
				return FALSE;
			}

			$r	= $this->db2->query('SELECT verified FROM users WHERE iduser="'.$uid.'" LIMIT 1', FALSE);
			if ($o = $this->db2->fetch_object($r)) {
				if ($o->verified==1) return TRUE;
			}
			return FALSE;
		}

		public function getUserAleat($total, $exclude=0, $privacy=-1)
		{
			if ($privacy==-1) $r = $this->db2->fetch_all('SELECT * FROM users WHERE active=1 AND iduser<>'.$exclude.' ORDER BY RAND() LIMIT '.$total);
			else $r = $this->db2->fetch_all('SELECT * FROM users WHERE active=1 AND privacy='.$privacy.' AND iduser<>'.$exclude.' ORDER BY RAND() LIMIT '.$total);
			return $r;
		}

		public function getPostsUser($iduser)
		{
			$r = $this->db2->fetch_all('SELECT idpost, code FROM posts WHERE iduser='.$iduser);
			return $r;
		}


		public function getCodePost($idp)
		{
			$idp = intval($idp);
			if( 0 == $idp ) return FALSE;
			return $this->db2->fetch_field('SELECT code FROM posts WHERE idpost='.$idp.' LIMIT 1');
		}

		public function getURLPage($idpage)
		{
			$idpage = intval($idpage);
			if( 0 == $idpage ) return FALSE;
			return $this->db2->fetch_field('SELECT url FROM pages WHERE idpage='.$idpage.' LIMIT 1');
		}

		public function getURLGroup($idgroup)
		{
			$idgroup = intval($idgroup);
			if( 0 == $idgroup ) return FALSE;
			return $this->db2->fetch_field('SELECT url FROM groups WHERE idgroup='.$idgroup.' LIMIT 1');
		}

		public function getCodeGroup($idgroup)
		{
			$idgroup = intval($idgroup);
			if( 0 == $idgroup ) return FALSE;
			return $this->db2->fetch_field('SELECT code FROM groups WHERE idgroup='.$idgroup.' LIMIT 1');
		}

		public function getInfoGroup($idgroup)
		{
			$idgroup = intval($idgroup);
			if( 0 == $idgroup ) return FALSE;
			$r = $this->db2->fetch('SELECT url, name_group FROM groups WHERE idgroup='.$idgroup.' LIMIT 1');
			return $r;
		}
		
		public function verifiedPost($code, $idu)
		{
			$code = $this->db2->e($code);
			if (strlen($code) != 11) return FALSE;
			$idu = intval($idu);
			if( 0 == $idu ) return FALSE;
			return $this->db2->fetch_field('SELECT idpost FROM posts WHERE code="'.$code.'" AND iduser='.$idu.' LIMIT 1');
		}
		
		public function verifiedPostinPage($code, $idpage)
		{
			$code = $this->db2->e($code);
			if (strlen($code) != 11) return FALSE;
			$idpage = intval($idpage);
			if( 0 == $idpage ) return FALSE;
			return $this->db2->fetch_field('SELECT idpost FROM posts WHERE code="'.$code.'" AND posted_in=1 AND id_wall='.$idpage.' LIMIT 1');
		}

		public function verifiedPostinGroup($code, $idgroup)
		{
			$code = $this->db2->e($code);
			if (strlen($code) != 11) return FALSE;
			$idgroup = intval($idgroup);
			if( 0 == $idgroup ) return FALSE;
			return $this->db2->fetch_field('SELECT idpost FROM posts WHERE code="'.$code.'" AND posted_in=2 AND id_wall='.$idgroup.' LIMIT 1');
		}
		
		public function idwall($code, $type)
		{
			$code = $this->db2->e($code);
			if (strlen($code) != 11) return FALSE;
			switch ($type) {
				case 0:
					return $this->db2->fetch_field('SELECT iduser FROM users WHERE code="'.$code.'" LIMIT 1');
					break;
				case 1:
					return $this->db2->fetch_field('SELECT idpage FROM pages WHERE code="'.$code.'" LIMIT 1');
					break;
				case 2:
					return $this->db2->fetch_field('SELECT idgroup FROM groups WHERE code="'.$code.'" LIMIT 1');
					break;
			}
		}
		
		public function infoBasicWall($posted_in, $id_wall)
		{
			switch ($posted_in) {
				case 0:
					$r = $this->db2->fetch('SELECT code, username, firstname, lastname FROM users WHERE iduser='.$id_wall.' LIMIT 1');
					break;	
				case 1:
					$r = $this->db2->fetch('SELECT code, url, title, idpage FROM pages WHERE idpage='.$id_wall.' LIMIT 1');
					break;	
				case 2:
					$r = $this->db2->fetch('SELECT idgroup, code, url, name_group FROM groups WHERE idgroup='.$id_wall.' LIMIT 1');
					break;	
			}
			return $r;			
		}

		public function getComment($idc)
		{
			$idc = intval($idc);
			if( 0 == $idc ) return FALSE;
			return $this->db2->fetch_field('SELECT comment FROM comments WHERE idcomment='.$idc.' LIMIT 1');
		}
		
		public function getInfoCommentById($idc)
		{
			$idc = intval($idc);
			if( 0 == $idc ) return FALSE;
			return $this->db2->fetch('SELECT posts.code, posts.iduser, comment, username FROM comments, posts, users  WHERE users.iduser=posts.iduser AND comments.idpost=posts.idpost AND idcomment='.$idc.' LIMIT 1');
		}

		public function getUsername($idu)
		{
			$idu = intval($idu);
			if( 0 == $idu ) return FALSE;
			return $this->db2->fetch_field('SELECT username FROM users WHERE iduser='.$idu.' LIMIT 1');
		}

		public function getNumNotifications($idu)
		{
			$idu = intval($idu);
			if( 0 == $idu ) return FALSE;
			return $this->db2->fetch_field('SELECT num_notifications FROM users WHERE iduser='.$idu.' LIMIT 1');
		}
		
		public function getNameCatPage($idcat)
		{
			$idcat = intval($idcat);
			if( 0 == $idcat ) return FALSE;
			return $this->db2->fetch_field('SELECT name FROM pages_cat WHERE idcategory='.$idcat.' LIMIT 1');
		}
		
		public function getUsersAleatHome($quantity=8)
		{
			//$r = $this->db2->fetch_all("SELECT * FROM users WHERE active=1 AND avatar<>'' ORDER BY RAND() LIMIT ".$quantity);
			$r = $this->db2->fetch_all("SELECT * FROM users WHERE active=1 ORDER BY RAND() LIMIT ".$quantity);
			return $r;			
		}	


		public function getTrendsTopic($quantity=10)
		{
			global $C;
			$timenow = time();
			$timeoneday = time() - 86400000 * $C->NUM_DAYS_TRENDS;
			$r = $this->db2->fetch_all("SELECT COUNT( DISTINCT iduser ) total, trend FROM trends WHERE whendate < '".$timenow."' AND whendate > '".$timeoneday."' && trend <> '' GROUP BY trend ORDER BY total DESC LIMIT ".$quantity);
			return $r;			
		}
	
		// Check if $uid1 is a friend of $uid2
		public function verifyFriendship($uid1, $uid2, $action)
		{
			if( ! $this->id ) {
				return FALSE;
			}
			$uid1 = intval($uid1);
			$uid2 = intval($uid2);
			if( 0 == $uid1 || 0 == $uid2 ) {
				return FALSE;
			}
			
			switch ($action) {
				case 1:
					return $this->db2->fetch_field('SELECT id FROM friends WHERE (user1='.$uid2.' AND user2='.$uid1.') OR (user1='.$uid1.' AND user2='.$uid2.')');
					break;
				case 2:
				case 3:
				case 4:
					return $this->db2->fetch_field('SELECT id FROM friends WHERE accepted=0 AND ((user1='.$uid2.' AND user2='.$uid1.') OR (user1='.$uid1.' AND user2='.$uid2.'))');
					break;
				case 5:
					return $this->db2->fetch_field('SELECT id FROM friends WHERE accepted<>0 AND ((user1='.$uid2.' AND user2='.$uid1.') OR (user1='.$uid1.' AND user2='.$uid2.'))');
					break;
			}
		}
		
		public function idOwnerPost($idpost)
		{
			$idp = intval($idpost);
			if( 0 == $idp ) return FALSE;
			return $this->db2->fetch_field('SELECT iduser FROM posts WHERE idpost='.$idp.' LIMIT 1');
		}
		
		public function PostLiketoUser($iduser, $idpost)
		{
			$r	= $this->db2->fetch_field('SELECT idlike FROM likes WHERE iduser='.$iduser.' AND idpost='.$idpost.' LIMIT 1');
			return $r;
		}
		
		public function getCommentsPost($start, $quantity, $idpost, $iduhidden=0)
		{
			$sqlCommentsHiddens = '';
			if ($iduhidden != 0) {
				$sqlCommentsHiddens = ' SELECT iditem FROM hiddens WHERE typeitem=2 AND iduser='.$iduhidden;
				$sqlCommentsHiddens = ' idcomment NOT IN ('.$sqlCommentsHiddens.') AND ';
			}
			
			$r = $this->db2->fetch_all('
			SELECT idcomment, comments.whendate, comment, comments.iduser, username, firstname, lastname, avatar, idpost, users.code as ucode 
			FROM comments, users 
			WHERE '.$sqlCommentsHiddens.'
			users.iduser=comments.iduser 
			AND idpost='.$idpost.' 
			ORDER BY comments.whendate DESC 
			LIMIT '.$start.','.$quantity);
			return $r;
		}

		public function getNumCommentsPost($idpost, $iduhidden=0)
		{
			$sqlCommentsHiddens = '';
			if ($iduhidden != 0) {
				$sqlCommentsHiddens = ' SELECT iditem FROM hiddens WHERE typeitem=2 AND iduser='.$iduhidden;
				$sqlCommentsHiddens = ' idcomment NOT IN ('.$sqlCommentsHiddens.') AND ';
			}
			
			$r = $this->db2->fetch_field('
			SELECT count(idcomment) 
			FROM comments 
			WHERE '.$sqlCommentsHiddens.'
			idpost='.$idpost);
			return $r;
		}

		public function idOwnerPage($idpage)
		{
			$idp = intval($idpage);
			if( 0 == $idp ) return FALSE;
			return $this->db2->fetch_field('SELECT idowner FROM pages WHERE idpage='.$idp.' LIMIT 1');
		}

		public function idOwnerGroup($idgroup)
		{
			$idg = intval($idgroup);
			if( 0 == $idg ) return FALSE;
			return $this->db2->fetch_field('SELECT idcreator FROM groups WHERE idgroup='.$idg.' LIMIT 1');
		}

		
	}
	
?>