/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.content.ContextCompatFroyo;
import android.support.v4.content.ContextCompatHoneycomb;
import android.support.v4.content.ContextCompatJellybean;
import android.support.v4.content.ContextCompatKitKat;
import java.io.File;

public class ContextCompat {
    private static final String DIR_ANDROID = "Android";
    private static final String DIR_DATA = "data";
    private static final String DIR_OBB = "obb";
    private static final String DIR_FILES = "files";
    private static final String DIR_CACHE = "cache";

    public static boolean startActivities(Context context, Intent[] intents) {
        return ContextCompat.startActivities(context, intents, null);
    }

    public static boolean startActivities(Context context, Intent[] intents, Bundle options) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 16) {
            ContextCompatJellybean.startActivities((Context)context, (Intent[])intents, (Bundle)options);
            return true;
        }
        if (version >= 11) {
            ContextCompatHoneycomb.startActivities((Context)context, (Intent[])intents);
            return true;
        }
        return false;
    }

    public static File[] getObbDirs(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return ContextCompatKitKat.getObbDirs((Context)context);
        }
        File single = version >= 11 ? ContextCompatHoneycomb.getObbDir((Context)context) : ContextCompat.buildPath(Environment.getExternalStorageDirectory(), DIR_ANDROID, DIR_OBB, context.getPackageName());
        return new File[]{single};
    }

    public static File[] getExternalFilesDirs(Context context, String type) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return ContextCompatKitKat.getExternalFilesDirs((Context)context, (String)type);
        }
        File single = version >= 8 ? ContextCompatFroyo.getExternalFilesDir((Context)context, (String)type) : ContextCompat.buildPath(Environment.getExternalStorageDirectory(), DIR_ANDROID, DIR_DATA, context.getPackageName(), DIR_FILES, type);
        return new File[]{single};
    }

    public static File[] getExternalCacheDirs(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return ContextCompatKitKat.getExternalCacheDirs((Context)context);
        }
        File single = version >= 8 ? ContextCompatFroyo.getExternalCacheDir((Context)context) : ContextCompat.buildPath(Environment.getExternalStorageDirectory(), DIR_ANDROID, DIR_DATA, context.getPackageName(), DIR_CACHE);
        return new File[]{single};
    }

    private static File buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            if (cur == null) {
                cur = new File(segment);
                continue;
            }
            if (segment == null) continue;
            cur = new File(cur, segment);
        }
        return cur;
    }
}

