<?php
// implement tinymce button

function fp_action_admin_init() {
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
		return;

	if ( get_user_option('rich_editing') == 'true') {
		add_filter( 'mce_external_plugins', 'fp_filter_mce_plugin');
		add_filter( 'mce_buttons', 'fp_filter_mce_button');
	}
}
add_action( 'admin_init', 'fp_action_admin_init');


function fp_filter_mce_button( $buttons ) {
	array_push( $buttons, '|', 'fp_btn' );
	return $buttons;
}

function fp_filter_mce_plugin( $plugins ) {
	if( (float)substr(get_bloginfo('version'), 0, 3) < 3.9) {
		$plugins['FontPress'] = FP_URL . '/js/tinymce_btn_old_wp.js';
	} else {
		$plugins['FontPress'] = FP_URL . '/js/tinymce_btn.js';
	}
	
	return $plugins;
}


// enqueue the colorpicker
function fp_shortcode_scripts() {
	if(strpos($_SERVER['REQUEST_URI'], 'post.php') === false && strpos($_SERVER['REQUEST_URI'], 'post-new.php') === false) {
		return false;	
	}
	
	include_once(FP_DIR .'/functions.php');
	$vals = fp_default_vals();
	$off_btn = '<small>OFF</small>';

	echo '
    <script src="'.FP_URL.'/js/colpick/js/colpick.min.js" type="text/javascript"></script>
	<script src="'.FP_URL.'/js/lc-switch/lc_switch.min.js" type="text/javascript"></script>
    
    <div id="fp_tinymce_wrap" style="display:none;">
    	<ul id="fp_tinymce_list">
          <li>
            <label>'. __('Font type', 'fp_ml') .'</label>
          	<select name="fp_font_type" id="fp_font_type" autocomplete="off">
                '.fp_get_fontypes('html').'
            </select>
          </li>
          <li>
              <label>'. __('Font name', 'fp_ml') .'</label>
              <span id="fp_font_name">
			  	<select name="fp-font-name" id="fp-font-name" autocomplete="off">
					'. fp_get_enabled_fonts('webfonts'). '
				</select>
			  </span>
          </li>
          <li>
             <label>'. __('Font size', 'fp_ml') .' '.$off_btn.'</label>
              
             <input type="number" min="0" max="100" maxlength="3" id="fp-font-size" name="fp-font-size" value="0" autocomplete="off" />
             <select name="fp-font-size-ms" id="fp-font-size-ms" autocomplete="off" style="width: 62px;">
             	'.fp_get_fontsize_types('html').'
             </select>
          </li>
          <li>
          	<label>'. __('Line height', 'fp_ml') .' '.$off_btn.'</label>
              
            <input type="number" min="0" max="150" id="fp-line-height" name="fp-line-height" value="0" autocomplete="off" />
          	<select name="fp-line-height-ms" id="fp-line-height-ms" autocomplete="off" style="width: 62px;">
            	'.fp_get_fontsize_types('html').'
            </select>
          </li>
		  <li>
          	<label>'. __('Text transform', 'fp_ml') .'</label>
              
         	<select name="fp-text-transform" id="fp-text-transform" autocomplete="off">
				'. fp_text_transform('html') .'
			</select>
          </li>
		  <li>
			<label>'. __('Outline', 'fp_ml') .'</label>
			
        	<select name="fp-text_stroke_w" id="fp-text_stroke_w" autocomplete="off" style="width: 62px;">
				'. fp_text_stroke_w('html') .'
			</select>
			<div class="lcwp_colpick">
				<span class="lcwp_colblock" style="background-color: '.$vals['text_stroke_col'].';"></span>
				<input type="text" name="fp-text-stroke-col" id="fp-text-stroke-col" value="'. $vals['text_stroke_col'] .'" autocomplete="off" />
			</div>
          </li>	
		  <li>
              <label>'. __('Highlight text', 'fp_ml') .' '.$off_btn.'</label>
              
			  <div class="lcwp_colpick">
			  	<span class="lcwp_colblock" style="background-color: '.$vals['highlight'].';"></span>
				<input type="text" id="fp_highlight" name="fp_highlight" maxlength="7" value="'. fp_empty_to_none($vals['highlight']) .'" autocomplete="off" />
			  </div>
          </li>  
          <li id="fp_mce_shadow_wrap">
              <label>'. __('Text Shadow', 'fp_ml') .' '.$off_btn.'</label>
			  
			  <label title="X axis offset">X</label>
			  <input type="number" min="0" max="30" maxlength="2" id="shadow_x" name="shadow_x" value="'. (int)$vals['shadow'][0] .'" autocomplete="off" />
			  
			  <label title="Y axis offset">Y</label>
			  <input type="number" min="0" max="30" maxlength="2" id="shadow_y" name="shadow_y" value="'. (int)$vals['shadow'][1] .'" autocomplete="off" />
			  
			  <label title="shadow radius">R</label>
			  <input type="number" min="0" max="30" maxlength="2" id="shadow_r" name="shadow_r" value="'. (int)$vals['shadow'][2] .'" autocomplete="off" />
			  
			  <label title="shadow opacity">%</label>
			  <input type="number" min="10" max="100" maxlength="3" id="shadow_perc" name="shadow_perc" value="'. (int)$vals['shadow'][3] .'" autocomplete="off" /><br/>
			  
			  <div class="lcwp_colpick" style="margin-top: 12px;">
				  <span class="lcwp_colblock" style="background-color: '.$vals['shadow'][4].';"></span>
				  <input type="text" id="fp-shadow-color" name="fp-shadow-color" value="'. $vals['shadow'][4] .'" />
			  </div>
          </li>
		  <li>
              <label>'. __('Unselectable text?', 'fp_ml') .'</label>
			  <input type="checkbox" id="fp_unselectable" name="fp_unselectable" value="1" autocomplete="off" />
          </li>
		  <li>
              <label>'. __('Custom class', 'fp_ml') .'</label>
			  <input type="text" id="fp_cust_class" name="fp_cust_class" value="" placeholder="'. __('class name, useful for custom CSS', 'fp_ml') .'" autocomplete="off" />
          </li>
		  
		  
          <li>
              <td colspan="2"><input type="button" class="fp_tinymce_submit button-primary" value="'. __('Insert', 'fp_ml') .'" name="submit" />
          </li>
		</ul>
    </div>';
	
	?>
    <div id="fp_mce_cufon_list" style="display: none;">
		<?php echo fp_get_enabled_fonts('cufon'); ?>
    </div>
    
    <div id="fp_mce_webfonts_list" style="display: none;">
        <?php echo fp_get_enabled_fonts('webfonts'); ?>
    </div>
    
    <div id="fp_mce_fontface_list" style="display: none;">
        <?php echo fp_get_enabled_fonts('fontface'); ?>
    </div>
    
    <div id="fp_mce_ad_typekit_list" style="display: none;">
        <?php echo fp_get_enabled_fonts('ad_typekit'); ?>
    </div>
    <?php
}
add_action('admin_footer', 'fp_shortcode_scripts');
