<?php
////////// SHORCODES

// [fontpress] 
function fp_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'type' 		=> 'inherit',
		'name' 		=> 'inherit',
		'size' 		=> '',
		'lh' 		=> '',
		'tnsf'		=> 'inherit',
		'ol'		=> '',
		'hl'		=> 'none',
		'shadow'	=> '',
		'unsel'		=> 0,
		'class'		=> ''
	), $atts ) );

	
	if($type == 'inherited' || $name != '') {
		include_once(FP_DIR .'/functions.php');
		
		// attributes array
		$classes = array('fp_sc_mark');
		if(!empty($class)) {$classes[] = $class;} // custom class
		
		$style = array(
			'background' 	=> 'none',
			'color'			=> 'inherit'
		);
		
		
		// font type/name
		if($type == 'css_font') {
			$style['font-family'] = "'".$name."'";
		}
		else {
			switch($type) {
				case 'cufon'		: $prefix = 'cf'; break;
				case 'webfonts'		: $prefix = 'wf'; break;	
				case 'ad_typekit'	: $prefix = 'at'; break;
				case 'fontface' 	:
				default				: $prefix = 'ff'; break;	
			}
			
			$classes[] = 'fp_'.$prefix.'_'.fp_stringToUrl($name);
		}
		
		
		// CSS properties
		if(!empty($size))	{
			$style['font-size'] = $size;
		}
		
		if(!empty($lh))	{
			$style['line-height'] = $lh;
		}
		
		if($tnsf != 'inherit')	{
			$style['text-transform'] = $tnsf;
		}
		
		if(!empty($ol))	{ // stroke / outline
			$data = explode('_', $ol);
			$style['text-shadow'] = '-'.$data[0].'px -'.$data[0].'px 0 '.$data[1].',  '.$data[0].'px -'.$data[0].'px 0 '.$data[1].', -'.$data[0].'px '.$data[0].'px 0 '.$data[1].', '.$data[0].'px '.$data[0].'px 0 '.$data[1];
		}
		
		if($hl != 'none') {
			$style['background'] = $hl;
			$style['border-color'] = $hl;
			$style['border-style'] = 'solid';
			$style['border-width'] = '3px 8px';
		}
		
		if(!empty($shadow)) {
			$data = explode('_', $shadow);
			if(count($data) == 4 || count($data) == 5) {
			
				// retrocompatibility
				if(count($data) == 4) {
					$new_data = array($data[0], $data[1], $data[2], 90, $data[3]);	
				}
				else {$new_data = $data;}
				
				$val = $new_data[0].'px '.$new_data[1].'px '.$new_data[2].'px '.fp_hex2rgb($new_data[4], $new_data[3]);	
					
				// consider stroke	
				$style['text-shadow'] = (isset($style['text-shadow'])) ? $style['text-shadow'] .', '. $val : $val;
			}
		}
		
		if(!empty($unsel)) {
			$style['-webkit-user-select'] 	= 'none';
			$style['-moz-user-select'] 		= 'none';
			$style['-ms-user-select'] 		= 'none';
			$style['user-select'] 			= 'none';     
		}
		
		
		// build
		$code = '<mark class="'. implode(' ', $classes) .'" style="';
		
		foreach($style as $attr => $val) {
			$code .= $attr.': '.$val.';';	
		}
		
		return $code . '">'. do_shortcode($content) .'</mark>';
	}
}
add_shortcode('fontpress', 'fp_shortcode');
