<?php include_once(FP_DIR. '/functions.php'); ?>

<div class="wrap fp_form">  
	<div class="icon32" id="pageicon-fontface"><br></div>
    <h1 class="fp_page_title">
    	<?php _e('Element Rules', 'fp_ml') ?>
        <a class="page-title-action" id="fp_add_rule" href="javascript:void(0)"><?php _e('Add New Rule', 'fp_ml') ?></a>
    </h1>  


    <?php
	// SAVE RULES
	if(isset($_POST['fp_save_rules'])) { 
		if (!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcweb')) {die('<p>Cheating?</p>');};
		
		// for no rules
		if(!isset($_POST['element'])) {
			$error = false;
			$fdata['fp_rules'] = false;
			
			// custom css
			$fdata['fp_custom_css'] = $_POST['fp_custom_css'];
		}
		
		// standard validation
		else {
			include(FP_DIR . '/classes/simple_form_validator.php');
		
			$validator = new simple_fv;
			$indexes[] = array('index'=>'element', 'label'=>__('Element', 'fp_ml'));
			$indexes[] = array('index'=>'element_subj', 'label'=>__('Element Subject', 'fp_ml'));
			
			$indexes[] = array('index'=>'font_type', 'label'=>__('Font Type', 'fp_ml'));
			$indexes[] = array('index'=>'font_name', 'label'=>__('Font Name', 'fp_ml'));
			
			$indexes[] = array('index'=>'font_size', 'label'=>__('Font Size', 'fp_ml'), 'type'=>'int');
			$indexes[] = array('index'=>'font_size_type', 'label'=>__('Font Size Type', 'fp_ml'));
			
			$indexes[] = array('index'=>'line_height', 'label'=>__('Line Height', 'fp_ml'), 'type'=>'int');
			$indexes[] = array('index'=>'line_height_type', 'label'=>__('Line Height Type', 'fp_ml'));
			
			$indexes[] = array('index'=>'font_weight', 'label'=>__('Font weight', 'fp_ml'));
			$indexes[] = array('index'=>'font_style', 'label'=>__('Font style', 'fp_ml'));
			$indexes[] = array('index'=>'text_decoration', 'label'=>__('Text decoration', 'fp_ml'));
			$indexes[] = array('index'=>'text_transform', 'label'=>__('Text transform', 'fp_ml'));
			$indexes[] = array('index'=>'text_color', 'label'=>__('Text Color', 'fp_ml'), 'max_len'=>7);
			
			$indexes[] = array('index'=>'text_stroke_w', 'label'=>__('Outline width', 'fp_ml'), 'type'=>'int');
			$indexes[] = array('index'=>'text_stroke_col', 'label'=>__('Outline color', 'fp_ml'), 'type'=>'hex', 'max_len'=>7);
			
			$indexes[] = array('index'=>'shadow_x', 'label'=>__( 'Shadow X', 'fp_ml' ), 'type'=>'int');
			$indexes[] = array('index'=>'shadow_y', 'label'=>__( 'Shadow Y', 'fp_ml' ), 'type'=>'int');
			$indexes[] = array('index'=>'shadow_r', 'label'=>__( 'Shadow Radius', 'fp_ml' ), 'type'=>'int');
			$indexes[] = array('index'=>'shadow_perc', 'label'=>__( 'Shadow opacity', 'fp_ml' ), 'type'=>'int');
			$indexes[] = array('index'=>'shadow_color', 'label'=>__( 'Shadow Color', 'fp_ml' ), 'type'=>'hex', 'max_len'=>7);
			
			$indexes[] = array('index'=>'highlight', 'label'=>__('Highlight color', 'fp_ml' ));
			$indexes[] = array('index'=>'unselectable', 'label'=>'unselectable');
			$indexes[] = array('index'=>'force_rule', 'label'=>'force rule');
			
			$indexes[] = array('index'=>'fp_custom_css', 'label'=>__( 'Custom CSS', 'fp_ml' ));
	
	
			// require all fields except checks - require a values for each block
			foreach($indexes as $key => $index) {
				if(in_array($index['index'], array('unselectable', 'force_rule', 'fp_custom_css'))) {continue;}
					
				$indexes[$key]['required'] = true;	
				$indexes[$key]['min_array'] = count((array)$_POST['element']);	
				$indexes[$key]['max_array'] = count((array)$_POST['element']);	
			}
			
	
			$validator->formHandle($indexes);
			$error = $validator->getErrors();
			$fdata = $validator->form_val;
			
			
			// create rules array
			$rules = array();
			for($a=0; $a < count($fdata['element_subj']); $a++) {
				
				$rules[$a]['element'] = $fdata['element'][$a];
				$rules[$a]['element_subj'] = $fdata['element_subj'][$a];
				$rules[$a]['font_type'] = $fdata['font_type'][$a];
				$rules[$a]['font_name'] = $fdata['font_name'][$a];
				
				$rules[$a]['font_size'] = $fdata['font_size'][$a];
				$rules[$a]['font_size_type'] = $fdata['font_size_type'][$a];
				
				$rules[$a]['line_height'] = $fdata['line_height'][$a];
				$rules[$a]['line_height_type'] = $fdata['line_height_type'][$a];	
				
				$rules[$a]['font_weight'] = $fdata['font_weight'][$a];
				$rules[$a]['font_style'] = $fdata['font_style'][$a];
				$rules[$a]['text_decoration'] = $fdata['text_decoration'][$a];
				$rules[$a]['text_transform'] = $fdata['text_transform'][$a];
				$rules[$a]['text_color'] = $fdata['text_color'][$a];
				
				$rules[$a]['shadow'] = array(
					$fdata['shadow_x'][$a],
					$fdata['shadow_y'][$a],
					$fdata['shadow_r'][$a],
					$fdata['shadow_perc'][$a],
					$fdata['shadow_color'][$a]
				);
				
				$rules[$a]['highlight'] = $fdata['highlight'][$a];
				$rules[$a]['unselectable'] = (isset($fdata['unselectable'][$a])) ? $fdata['unselectable'][$a] : 0;
				$rules[$a]['force_rule'] = (isset($fdata['force_rule'][$a])) ? $fdata['force_rule'][$a] : 0;
			}
			$fdata['fp_rules'] = $rules; // use array to allow population in error cases
		}
			
		if($error) {
			echo '<div class="error"><p>'.$error.'</p></div>';
		}
		else {
			// rules
			update_option('fp'.FP_BID.'_rules', $fdata['fp_rules']);
			update_option('fp'.FP_BID.'_custom_css', stripslashes($fdata['fp'.FP_BID.'_custom_css']));
			
			
			// create frontend css
			$mess = (!fp_create_frontend_files()) ? __("Your server doesn't allow direct files creation. Code will be used inline", 'fp_ml') : __('Rules Saved', 'fp_ml');
			echo '
			<div class="updated">
				<p><strong>'. $mess .'</strong></p>
			</div>';
		}
	}

	else { 
		$fdata['fp_rules'] = get_option('fp'.FP_BID.'_rules');
		$fdata['fp_custom_css'] = get_option('fp'.FP_BID.'_custom_css'); 
	} 
	?>

    <br/>
    <div class="lcwp_opt_block">
		<form name="fp_rules_form" method="post" class="form-wrap fp_rules_form" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>">      
			<?php 
			echo fp_rule_row_form($fdata['fp_rules']);	
			?>
            
            
            <hr style="margin: 10px 0;" />
            
            
            <h3>Custom CSS</h3>
            <table class="widefat lcwp_table">
              <tr>
                <td class="lcwp_field_td">
                    <textarea name="fp_custom_css" style="width: 100%" rows="5"><?php echo stripslashes($fdata['fp_custom_css']); ?></textarea>
                </td>
              </tr>
            </table>
                  
            <p class="submit">  
                <input type="submit" name="fp_save_rules" value="<?php _e('Save Rules and CSS', 'fp_ml' ) ?>" class="button-primary" />  
            </p>  
          
            <input type="hidden" name="lcwp_nonce" value="<?php echo wp_create_nonce('lcweb') ?>" /> 
		</form>
	</div>
</div>  


<?php // HIDDEN ELEMENTS ?>

<div id="fp_new_row" style="display: none;">
	<?php echo fp_rule_row_form(array(1)); ?>
</div>

<div id="cufon_list" style="display: none;">
	<?php echo fp_get_enabled_fonts('cufon'); ?>
</div>

<div id="webfonts_list" style="display: none;">
	<?php echo fp_get_enabled_fonts('webfonts'); ?>
</div>

<div id="fontface_list" style="display: none;">
	<?php echo fp_get_enabled_fonts('fontface'); ?>
</div>

<div id="ad_typekit_list" style="display: none;">
	<?php echo fp_get_enabled_fonts('ad_typekit'); ?>
</div>



<?php // SCRIPTS ?>

<script src="<?php echo FP_URL; ?>/js/colpick/js/colpick.min.js" type="text/javascript"></script>
<script src="<?php echo FP_URL; ?>/js/lc-switch/lc_switch.min.js" type="text/javascript"></script>
<script type="text/javascript" charset="utf8">
jQuery(document).ready(function($) {

	/*** add rule ***/
	jQuery(document).delegate('#fp_add_rule', 'click', function() {
		jQuery('.fp_rules_form hr').before( jQuery('#fp_new_row').html() );
	});


	/*** collapse/reveal block ***/
	jQuery(document).delegate('.fp_rule_block .fp_rule_cmd a', 'click', function() {
		if(jQuery(this).parents('.fp_rule_block').find('section').first().is(':hidden')) {
			jQuery('.fp_rule_block .fp_rule_cmd a').text("(<?php _e('collapse', 'fp_ml') ?>)")
			jQuery(this).parents('.fp_rule_block').find('section').slideDown();	
		}
		else {
			jQuery('.fp_rule_block .fp_rule_cmd a').text("(<?php _e('expand', 'fp_ml') ?>)")
			jQuery(this).parents('.fp_rule_block').find('section').slideUp();		
		}
	});


	/*** set field value as null ***/
	jQuery(document).delegate('.fp_rule_block > section label small', 'click', function() {
		var $parent = jQuery(this).parents('section');
		
		// disable font-size or line-height or shadow 
		if($parent.hasClass('fp_rule_font_size') || $parent.hasClass('fp_rule_line_height') || $parent.hasClass('fp_rule_shadow')) {
			$parent.find('input[type=number]').not('.fp_shadow_perc').val(0);
		}
		
		// disable text color or highlight
		else if($parent.hasClass('fp_rule_color') || $parent.hasClass('fp_rule_highlight')) {
			$parent.find('input').val('none');
		}
	});

	
	/*** element type ***/
	jQuery('body').delegate('.choose_element', "change", function() {
		var sel_elem = jQuery(this).val();
		var $subj = jQuery(this).parents('header').find('.fp_selector_helper');
		
		if(sel_elem != 'custom') {
			$subj.html('<input type="hidden" name="element_subj[]" value="'+ sel_elem +'" /><span>'+ sel_elem +'</span>');
		}
		else {
			$subj.html('<input type="text" name="element_subj[]" placeholder="<?php _e('insert a CSS selector', 'fp_ml') ?>" autocomplete="off" />');
		}	
	});
	
	
	/*** font type ***/
	jQuery('body').delegate('.choose_font_type', "change", function() {
		var sel_type = jQuery(this).val();
		var $subj = jQuery(this).parents('.fp_rule_block');
		
		if(sel_type != 'css_font' && sel_type != 'inherited') {
			var opts = jQuery('#'+ sel_type +'_list').html();
			$subj.find('.fp_rule_font_name').removeClass('fp_no_font_name');
			
			$subj.find('.fp_rule_font_name div').html('<select name="font_name[]" autocomplete="off">'+ opts +'</select>');
		}
		else if(sel_type == 'css_font') {
			$subj.find('.fp_rule_font_name').removeClass('fp_no_font_name');
			$subj.find('.fp_rule_font_name div').html('<input type="text" name="font_name[]" placeholder="<?php _e('write font name', 'fp_ml') ?>" autocomplete="off" />');	
		}
		else {
			$subj.find('.fp_rule_font_name').addClass('fp_no_font_name');
			$subj.find('.fp_rule_font_name div').html('<input type="hidden" name="font_name[]" value="inherited" />');
		}
	});
	
	
	/*** remove rule ***/
	jQuery('body').delegate('.fp_del_rule', "click", function() {
		if(confirm('<?php _e('Delete rule?', 'fp_ml') ?>')) {
			jQuery(this).parents('.fp_rule_block').slideUp(function() {
				jQuery(this).remove();
			});	
		}
	});
	
	
	////////////////////////////
	
	// cycle to find proper size
	var opts_width = function() {
		var w = jQuery('.fp_rules_form').width();
		
		for(a=7; a>0; a--) {
			if( (w / a) > 200 || a == 1 ) {
				var w_code = 'width: '+ (100/a) +'%;';
				break; 	
			}
		}
		
		jQuery('#fp_rule_opts_width').remove();
		jQuery('head').append('<style id="fp_rule_opts_width" type="text/css">.fp_rule_block > section {'+ w_code +'}</style>');
	}
	opts_width();
	
	jQuery(window).resize(function() {
		fp_column_w_to = setTimeout(function() {
			if(typeof(fp_column_w_to) != 'undefined') {clearTimeout(fp_column_w_to);}
			opts_width();
		}, 50);
	});
	
	
	/*** sort rows ***/
	jQuery(".fp_rules_form").sortable({
		handle: '.fp_move_rule',
		axis:	'y',
	});
	jQuery(".fp_rules_form .fp_move_rule").disableSelection();
	
	
	// colorpicker
	var live_colpick = function() {
		jQuery('.lcwp_colpick input').each(function() {
          	var curr_col = jQuery(this).val().replace('#', '');
			jQuery(this).colpick({
				layout:'rgbhex',
				submit:0,
				color: curr_col,
				onChange:function(hsb,hex,rgb, el, fromSetColor) {
					if(!fromSetColor){ 
						jQuery(el).val('#' + hex);
						jQuery(el).parents('.lcwp_colpick').find('.lcwp_colblock').css('background-color','#'+hex);
					}
				}
			}).keyup(function(){
				jQuery(this).colpickSetColor(this.value);
				jQuery(this).parents('.lcwp_colpick').find('.lcwp_colblock').css('background-color', this.value);
			});  
        });
	}
	live_colpick();
	
	
	// LC switch
	var lc_switch = function() {
		jQuery('.fp_rule_block :checkbox').lc_switch('YES', 'NO');
	}
	lc_switch();
});
</script>

