// closure to avoid namespace collision
(function(){
	
	fp_H = 600;
	fp_W = 440;
	
	// creates the plugin
	tinymce.PluginManager.add('FontPress', function( editor, url ) {

        // Add a button that opens a window
        editor.addButton('fp_btn', {
            text: false,
			title: 'FontPress',
            icon: 'fp_btn',  // css class  mce-i-pg_btn
            onclick: function() {
                tb_show('FontPress Shortcode', '#TB_inline?width='+ fp_W +'&height='+ fp_H +'&inlineId=fp_tinymce_wrap');
				
				jQuery('#TB_window').addClass('fp_tinymce_lb_wrap').removeAttr('style');
				jQuery('#TB_ajaxContent').addClass('fp_tinymce_lb').removeAttr('style');
				jQuery('#TB_overlay').css('z-index', 999998);
				
				fp_mce_colpick();
				fp_mce_lc_switch();
            }

        });
	});

	
	// colorpicker
	function fp_mce_colpick() {
		jQuery('.lcwp_colpick input').each(function() {
			var curr_col = jQuery(this).val().replace('#', '');
			jQuery(this).colpick({
				layout:'rgbhex',
				submit:0,
				color: curr_col,
				onChange:function(hsb,hex,rgb, el, fromSetColor) {
					if(!fromSetColor){ 
						jQuery(el).val('#' + hex);
						jQuery(el).parents('.lcwp_colpick').find('.lcwp_colblock').css('background-color','#'+hex);
					}
				}
			}).keyup(function(){
				jQuery(this).colpickSetColor(this.value);
				jQuery(this).parents('.lcwp_colpick').find('.lcwp_colblock').css('background-color', this.value);
			});  
		});
	}
	
	
	// LC switch
	function fp_mce_lc_switch() {
		jQuery('#fp_tinymce_list :checkbox').lc_switch('YES', 'NO');
	}
	
	
	
	// set field value as null
	jQuery(document).delegate('.fp_tinymce_lb #fp_tinymce_list label small', 'click', function() {
		var $parent = jQuery(this).parents('li');
		
		// disable font-size or line-height or shadow 
		if($parent.find('input[type=number]').length) {
			$parent.find('input[type=number]').not('#shadow_perc').val(0);
		}
		
		// disable text color or highlight
		else {
			$parent.find('input').val('none');
		}
	});
	
	
	// font list ajax
	jQuery(document).delegate('.fp_tinymce_lb #fp_tinymce_list #fp_font_type', "change", function() {
		var sel_font = jQuery(this).val();
		
		if(sel_font != 'css_font' && sel_font != 'inherited') {
			var opts = jQuery('#fp_mce_'+ sel_font +'_list').html(); 
			jQuery('#fp_font_name').html('<select name="fp-font-name" id="fp-font-name" autocomplete="off">'+ opts +'</select>');
		}
		else if(sel_font == 'css_font') {
			jQuery('#fp_font_name').html('<input type="text" id="fp-font-name" name="fp-font-name" autocomplete="off" />');
		}
		else {
			jQuery('#fp_font_name').html('<em>inherited</em> <input type="hidden" id="fp-font-name" name="fp-font-name" value="inherited" />');	
		}
	});
	
	
	
	// submit
	jQuery(document).delegate('.fp_tinymce_lb #fp_tinymce_list .fp_tinymce_submit', "click", function() {
		var $subj = jQuery('.fp_tinymce_lb #fp_tinymce_list'); 
		
		var font_type		= $subj.find('#fp_font_type').val();
		var font_name 		= $subj.find('#fp-font-name').val();	
		
		if(font_type == 'inherited' || jQuery.trim(font_name) != '') {
			var sc = '[fontpress';
			
			// font name
			if(font_type != 'inherited') {
				sc += ' type="'+ font_type +'" name="'+ font_name +'"';	
			}
			
			// font size 
			if(parseInt($subj.find('#fp-font-size').val())) {
				sc += ' size="'+ $subj.find('#fp-font-size').val() + $subj.find('#fp-font-size-ms').val() +'"';		
			}
			
			// line height
			if(parseInt($subj.find('#fp-line-height').val())) {
				sc += ' lh="'+ $subj.find('#fp-line-height').val() + $subj.find('#fp-line-height-ms').val() +'"';		
			}
			
			// text transform
			if($subj.find('#fp-text-transform').val() != 'inherit') {
				sc += ' tnsf="'+ $subj.find('#fp-text-transform').val() +'"';		
			}
			
			// outline
			if($subj.find('#fp-text_stroke_w').val() != 0) {
				sc += ' ol="'+ $subj.find('#fp-text_stroke_w').val() +'_'+ $subj.find('#fp-text-stroke-col').val() +'"';		
			}

			// highlight
			if($subj.find('#fp_highlight').val() != 'none') {
				sc += ' hl="'+ $subj.find('#fp_highlight').val() +'"';		
			}

			// shadow
			if(parseInt($subj.find('#shadow_x').val()) || parseInt($subj.find('#shadow_y').val()) || parseInt($subj.find('#shadow_r').val())) {
				sc += ' shadow="'+ $subj.find('#shadow_x').val() +'_'+ $subj.find('#shadow_y').val() +'_'+ $subj.find('#shadow_r').val() +'_'+ $subj.find('#shadow_perc').val() +'_'+ $subj.find('#fp-shadow-color').val() +'"';	
			}
			
			// unselectable
			if($subj.find('#fp_unselectable').is(':checked')) {
				sc += ' unsel="1"';	
			}
			
			// custom class
			if(jQuery.trim($subj.find('#fp_cust_class').val())) {
				sc += ' class="'+ $subj.find('#fp_cust_class').val() +'"';	
			}
			
			sc += '] [/fontpress]';
			
			// inserts the shortcode into the active editor
			tinymce.activeEditor.execCommand('mceInsertContent', false, sc);
			
			// closes Thickbox
			tb_remove();
		}
	});
})()

