	// Operations [ Arlind Nushi ]
	
	$(document).ready(function(){

		// Chrome Detection
		var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
		var is_opera = navigator.userAgent.toLowerCase().indexOf('opera') > -1;
		
		if( is_chrome || $.browser.msie ){
			$(".fp_button").css({"padding-left": "6px"});
			$(".fp_button span").css({"top": "0px"});
			$(".fp_button:active span").css({"top": "1px"});
		}
		else
		if( is_opera )
		{
			$(".fp_button span").css({"top": "0px", "left":"3px"});
		}
		
		
		// Make poll AJAX Based
		$("#fp_form").submit(function()
		{
			if( $.browser.msie && $.browser.version < 8 )
				return true;
				
			var $this = $(this);
			var fp_env = $(".fp_env");
			
			if( $(".success_msg, .warning_msg").length == 0 )
			{
				fp_env.before('<div class="success_msg"></div><div class="warning_msg"></div>');
			}
			
			var success_msg = $(".success_msg");
			var warning_msg = $(".warning_msg");
			
			if( success_msg.text().length == 0 && warning_msg.text().length == 0 )
			{
				success_msg.hide();
				warning_msg.hide();
			}
			
			if( $this.find(':checked').length == 0 )
			{
				alert("Please select an option");
				return false;
			}
			
			showLoader();
			var $option_id = $this.find(':checked').val();
			
			var datas = {
				"fp_option[]": $option_id,
				vote: true,
				ajax_request: true
			};
			
			jQuery.post("index.php", datas, function(response)
			{
				hideLoader();
				
				var resp;
				eval( response );
				
				if( resp.errors )
				{
					if( warning_msg.text().length == 0 )
					{
						warning_msg.html(resp.errorMsg);
						warning_msg.slideDown("fast", function(){
							warning_msg.show("shake", {distance:30}, 100);
						});
						
					}
					else
						warning_msg.show("shake", 100);
				}
				else
				{
					var title = $this.find('h1').html();
					
					var content = '<div class="fp_inner_cdiv">';
					content += "<h1>" + title + "</h1>";
					var tableData = resp.tableData;
					
					content += '<table class="fp_results_table" border="0" align="center" cellpadding="2" cellspacing="2">';
					for(var i=0; i<tableData.length; i++)
					{
						if( tableData[i] )
						{
							content+= '<tr>';
							try
							{
							content+= '<td align="right">' + tableData[i][0] + '</td>';
							}
							catch(e)
							{}
							content+= '<td><div class="fp_progress_bar"><div class="fill" fillto="'+tableData[i][2]+'" style="width:0%"></div></div></td>';
							content+= '<td><span class="percentage">'+tableData[i][1]+'</span></td>';
							content+= '</tr>';
						}
					}
					
					content += '</table>';
					
					content += '</div>';
					
					fp_env.flip({
						direction: 'lr',
						content: content,
						onEnd: function()
						{
							success_msg.html(resp.successMsg);
							success_msg.slideDown("slow");
							startFillingProgressbars();
							warning_msg.slideUp();
						}
					});
				}
			});
			
			return false;
		});
		
		$(".fp_poll_results_link").click(function()
		{
			showLoader();
			
			jQuery.post("index.php", {ajax_request:true, view_results: true}, function(response)
			{
				hideLoader();
				var resp;
				eval(response);
				
				var $this = $("#fp_form");
				var fp_env = $(".fp_env");
				var title = $this.find('h1').html();
				
				var content = '<div class="fp_inner_cdiv">';
				content += "<h1>" + title + "</h1>";
				var tableData = resp.tableData;
				
				content += '<table class="fp_results_table" border="0" align="center" cellpadding="2" cellspacing="2">';
				for(var i=0; i<tableData.length; i++)
				{
					if( tableData[i] )
					{
						content+= '<tr>';
						content+= '<td align="right">' + tableData[i][0] + '</td>';
						content+= '<td><div class="fp_progress_bar"><div class="fill" fillto="'+tableData[i][2]+'" style="width:0%"></div></div></td>';
						content+= '<td><span class="percentage">'+tableData[i][1]+'</span></td>';
						content+= '</tr>';
					}
				}
				
				content += '</table>';
				
				content += '</div>';
				
				fp_env.flip({
					direction: 'bt',
					content: content,
					onEnd: function()
					{
						startFillingProgressbars();
					}
				});
			});
			return false;
		});
	});
	
	function startFillingProgressbars()
	{
		var is_opera = navigator.userAgent.toLowerCase().indexOf('opera') > -1;
		
		var elements = $(".fp_progress_bar .fill");
		
		elements.each(function()
		{
			var $this = $(this);
			var parent_width = $this.parent().width;
			var fillTo = $this.attr("fillto");
			
			if( is_opera )
			{
				$this.width(fillTo+"%");
			}
			else
			{
				$this.animate({width:fillTo+"%"}, 1800);
			}
		});
		
	}
	
	function showLoader()
	{
		var fp_inner_cdiv = $(".fp_inner_cdiv");
		fp_inner_cdiv.css("position", "relative");
		
		if( $(".loader_bar").length == 0 )
		{
			fp_inner_cdiv.append('<div class="loader_bar"></div>');
			fp_inner_cdiv.append('<div class="preloader"></div>');
		}
		
		var loader_bar = $(".loader_bar");
		var preloader = $(".preloader");
		
		loader_bar.css({
			"display":"none",
			"position":"absolute",
			"top":"0px",
			"left":"0px",
			"width":fp_inner_cdiv.get(0).offsetWidth,
			"height":fp_inner_cdiv.get(0).offsetHeight,
			"background":"#000"
			});
		
		preloader.css({
			"display":"none",
			"position":"absolute",
			"top":"0px",
			"left":"0px",
			"width":fp_inner_cdiv.get(0).offsetWidth,
			"height":fp_inner_cdiv.get(0).offsetHeight,
			"background":"url(imgs/preloader.gif) no-repeat center"
			});
			
		loader_bar.fadeTo(250, 0.4);
		preloader.fadeTo(250, 1);
	}
	
	function hideLoader()
	{
		var loader_bar = $(".loader_bar");
		var preloader = $(".preloader");
		
		if( loader_bar.length == 1 )
		{
			loader_bar.fadeTo(250, 0, function()
			{
				loader_bar.css("display","none");
			});
			
			preloader.fadeTo(250, 0, function()
			{
				preloader.css("display","none");
			});
		}
	}