<?php

	/**
	 * @class FlipperPoll
	 * @author Arlind Nushi <arlindd@gmail.com>
	 */
	 
	class FlipperPoll
	{
		private $poll_options = array();
		private $votes_total = 0;
		private $votes_max_value = 0;
		
		public function FlipperPoll()
		{
		}
		
		public function addPollOption($poll_option)
		{
			if( $poll_option instanceof FlipperPollOption )
			{
				if( is_numeric($poll_option->getId()) && $poll_option->getName() )
				{
					array_push($this->poll_options, $poll_option);
				}
			}
		}
		
		public function processPoll()
		{
			$options = &$this->poll_options;
			
			foreach($options as $option)
			{
				$q = mysql_query("SELECT * FROM `".FP_PREFIX."polloptions` WHERE PollOptionID = '".$option->getId()."'") or die(mysql_error());
				
				if( !mysql_num_rows($q) )
				{
					mysql_query("INSERT INTO `".FP_PREFIX."polloptions`(`PollOptionID`,`OptionName`) VALUES('".$option->getId()."','".mysql_real_escape_string($option->getName())."')");
				}
				else
				{
					$r = mysql_fetch_array($q);
					$votes = $r['Votes'];
					
					
					if( $r['OptionName'] != $option->getName() )
					{
						mysql_query("UPDATE `".FP_PREFIX."polloptions` SET `OptionName` = '".mysql_real_escape_string($option->getName())."' WHERE `PollOptionID` = '".$option->getId()."'");
					}
					
					$this->votes_total += $votes;
					
					if( $this->votes_max_value < $votes )
						$this->votes_max_value = $votes;
						
					$option->votes($votes);
				}
			}
		}
		
		public function isValidPollOption($option_id)
		{
			$q = mysql_query("SELECT * FROM `".FP_PREFIX."polloptions` WHERE PollOptionID = '".$option_id."'");
			
			if( mysql_num_rows($q) )
			{
				return true;
			}
			
			return false;			
		}
		
		public function clientHasVoted()
		{
			$default_time_period = 24 * 3600;
			$remote_addr = $_SERVER['REMOTE_ADDR'];
			$country_code = CountryDetector::getCountryCode();
			
			if( defined('FP_VOTING_PERIOD') && is_numeric(FP_VOTING_PERIOD) && FP_VOTING_PERIOD >= 0 ) 
			{
				$default_time_period = FP_VOTING_PERIOD;
			}
			
			$timeout = time() - $default_time_period;
			$check = mysql_query("SELECT * FROM `".FP_PREFIX."pollvotes` WHERE `Time` > $timeout AND `RemoteAddress` = '$remote_addr' AND `CountryCode` = '$country_code'");
			
			if( mysql_num_rows($check) )
			{
				return true;
			}
			
			return false;
		}
		
		public function voteOption($option_id)
		{
			$remote_addr = $_SERVER['REMOTE_ADDR'];
			$country_code = CountryDetector::getCountryCode();
			
			mysql_query("INSERT INTO `".FP_PREFIX."pollvotes`(`PollOptionID`,`Time`,`RemoteAddress`,`CountryCode`) VALUES($option_id,".time().",'$remote_addr','$country_code')");
			
			$results = mysql_query("SELECT PollOptionID, COUNT(*) Votes FROM `".FP_PREFIX."pollvotes` GROUP BY `PollOptionID`");
			
			while($r = mysql_fetch_array($results))
			{
				mysql_query("UPDATE `".FP_PREFIX."polloptions` SET `Votes` = '{$r['Votes']}' WHERE `PollOptionID` = '{$r['PollOptionID']}'");
			}
		}
		
		public function votesTotal()
		{
			return $this->votes_total;
		}
		
		public function votesMaxValue()
		{
			return $this->votes_max_value;
		}
		
		public function getPollOptions()
		{
			return $this->poll_options;
		}
		
		public function editConfigurationFile($site_title, $poll_title, $thankyou_msg, $already_msg, $optionids, $options, $progressbar_fill, $voting_timeout, $default_theme, $db_host, $db_user, $db_pass, $db_name, $table_prefix)
		{
			$fp = fopen("configuration.php", "r+");
			
			$new_file_contents = "";
			
			while($line = fgets($fp))
			{
				if( strpos($line, '$site_title') > -1 )
				{
					$new_file_contents .=  "\t" . '$site_title = "'.addslashes($site_title).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$poll_title') > -1 )
				{
					$new_file_contents .=  "\t" . '$poll_title = "'.addslashes($poll_title).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$db_host') > -1 )
				{
					$new_file_contents .=  "\t" . '$db_host = "'.addslashes($db_host).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$db_user') > -1 )
				{
					$new_file_contents .=  "\t" . '$db_user = "'.addslashes($db_user).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$db_pass') > -1 )
				{
					$new_file_contents .=  "\t" . '$db_pass = "'.addslashes($db_pass).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$db_name') > -1 )
				{
					$new_file_contents .=  "\t" . '$db_name = "'.addslashes($db_name).'";' . PHP_EOL;
				}
				elseif( strpos($line, 'define(\'FP_PREFIX\'') > -1 )
				{
					$new_file_contents .=  "\t" . 'define(\'FP_PREFIX\', "'.addslashes($table_prefix).'");' . PHP_EOL;
				}
				elseif( strpos($line, 'define(\'FP_VOTING_PERIOD\'') > -1 )
				{
					$new_file_contents .=  "\t" . 'define(\'FP_VOTING_PERIOD\', '.addslashes($voting_timeout).');' . PHP_EOL;
				}
				elseif( strpos($line, '$thank_you_msg') > -1 )
				{
					$new_file_contents .=  "\t" . '$thank_you_msg = "'.addslashes($thankyou_msg).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$already_voted_msg') > -1 )
				{
					$new_file_contents .=  "\t" . '$already_voted_msg = "'.addslashes($already_msg).'";' . PHP_EOL;
				}
				elseif( strpos($line, '$optimum_filling') > -1 )
				{
					$new_file_contents .=  "\t" . '$optimum_filling = '.addslashes($progressbar_fill).';' . PHP_EOL;
				}
				elseif( strpos($line, '$default_theme') > -1 )
				{
					$new_file_contents .=  "\t" . '$default_theme = '.$default_theme.';' . PHP_EOL;
				}
				elseif( strpos($line, '$options = array()') > -1 )
				{
					$new_file_contents .= $line . PHP_EOL . '#OPTIONS_HERE#';
				}
				elseif( strpos($line, '$options[') > -1 )
				{
					// Remove Options [ Temporarely ]
				}
				else
					$new_file_contents .= $line;
			}
			
			$options_define = "";
			
			fclose($fp);
			
			foreach($optionids as $i => $id)
			{
				$value = $options[ $i ];
				$options_define .= "\t" . '$options[] = new FlipperPollOption('.$id.', "'.addslashes($value).'");' . PHP_EOL;
			}
			
			$options_define = substr($options_define, 0, -1);
			
			$new_file_contents = str_replace('#OPTIONS_HERE#', $options_define, $new_file_contents);
			$new_file_contents = str_replace(array("\n\n\n", "\'"), array("\n", "'"), $new_file_contents);
			
			$fp = fopen("configuration.php", "w");
			fwrite($fp, $new_file_contents);
			fclose($fp);
		}
		
		
		public function deleteOptionId($option_id)
		{
			$q1 = mysql_query("DELETE FROM `".FP_PREFIX."pollvotes` WHERE PollOptionID = '".$option_id."'");
			$q2 = mysql_query("DELETE FROM `".FP_PREFIX."polloptions` WHERE PollOptionID = '".$option_id."'");
			
		
			$fp = fopen("configuration.php", "r+");
			
			$new_file_contents = "";
			
			while($line = fgets($fp))
			{
				if( strpos($line, 'FlipperPollOption('.$option_id.',') > -1 )
				{
					// Remove Line - DONE
				}
				else
					$new_file_contents .= $line;
			}
			
			fclose($fp);
			
			$fp = fopen("configuration.php", "w");
			fwrite($fp, $new_file_contents);
			fclose($fp);
		}
		
		public function changePassword($new_password)
		{
			$fp = fopen("configuration.php", "r+");
			
			$new_file_contents = "";
			
			while($line = fgets($fp))
			{
				if( strpos($line, '$admin_password') > -1 )
				{
					$admin_password = sha1(md5(base64_encode($new_password)));
					$new_file_contents .=  "\t" . '$admin_password = "'.$admin_password.'";' . PHP_EOL;
				}
				else
					$new_file_contents .= $line;
			}
			
			fclose($fp);
			
			$fp = fopen("configuration.php", "w");
			fwrite($fp, $new_file_contents);
			fclose($fp);
		}
	}
	
	
	/**
	 * @class FlipperPollOption
	 */
	 
	class FlipperPollOption
	{
		private $option_id;
		private $option_name;
		private $votes = 0;
		
		public function FlipperPollOption($option_id, $option_name)
		{
			$this->option_id = $option_id;
			$this->option_name = $option_name;
		}
		
		public function getId()
		{
			return $this->option_id;
		}
		
		public function getName()
		{
			return $this->option_name;
		}
		
		public function votes($votes = null)
		{
			if( is_numeric($votes) )
			{
				$this->votes = $votes;
			}
			else
			{
				return $this->votes;
			}
		}
	}

	/**
	 * @interface CountryDetectorInterface
	 * @author Arlind Nushi
	 */
	
	interface CountryDetectorInterface
	{
		/** @var IP_API_URL - Do not change API url, in order this class to work properly! */
		const IP_API_URL = 'http://api.wipmania.com/#REMOTE_ADDR#';
		
		public static function redirect($country, $url, $except = null);
		
		public static function includeFile($country, $include_path, $except = null);
		
		public static function includeFileOnce($country, $include_path, $except = null);
		
		public static function callback($country, $callback_func, $except = null);
	}

	
	/**
	 * Class that lookup's for a country code then it redirects (include files, or callbacks) the user to desired content you want.
	 * The function of this class is like Google that redirects users from countries that support google 
	 * e.g. in UK when you enter google.com you will be redirected to google.co.uk and this is excatly 
	 * what you can do with CountryDetector
	 *
	 * This class is builded in static context for purpose of best usage
	 *
	 * @class CountryDetector
	 * @author Arlind Nushi <arlindd@gmail.com>
	 * @version 1.0.0.1
	 * @date Feb 24, 2010
	 */
	
	
	class CountryDetector implements CountryDetectorInterface
	{
		private static $current_country;
		
		private static $include_done;
		
		private static $redirecting = false;
		
		
		/** Defined Countries */
		private static $BALKANS = array("AL", "BA","HR", "RS", "ME", "BG", "MK", "GR");
		
		private static $EUROPE = array("AL", "AD", "AM", "AT", "AZ", "BY", "BE", "BA", "BG", "HR", "CY", "CZ", "CS", "DK", "EE", "FI", "FR", "FX", "GE", "DE", "GR", "HU", "IS", "IE", "IT", "KZ", "LV", "LI", "LT", "LU", "MK", "MT", "MD", "MC", "ME", "NL", "NO", "PL", "PT", "RO", "RU", "SM", "RS", "SI", "ES", "SE", "CH", "TR", "UA", "UK", "VA");
		
		private static $MIDDLEEAST = array("TR", "BH", "KW", "OM", "QA", "SA", "AE", "YE", "PS", "IQ", "IL. JO", "LB", "SY", "IR", "CY", "EG");
		
		private static $ASIA = array("AF", "AM", "AZ", "BH", "BD", "BT", "IO", "DN", "KH", "CN", "CX", "CC", "GE", "HK", "IN", "ID", "IR", "IQ", "IL", "JP", "JO", "KZ", "KP", "KR", "KW", "KG", "LA", "LB", "MO", "MY", "MV", "MN", "NP", "OM", "PK", "PS", "PH", "QA", "RU", "SA", "SG", "LK", "SY", "TW", "TJ", "TH", "TP", "AE", "UZ", "VN", "YE");
		
		private static $AMERICA = array("US", "BZ", "CR", "SV", "GT", "HN", "NI", "PA", "MX", "HT", "CU", "AR", "BO", "BR", "CL", "CO", "EC", "FK", "GF", "GY", "PY", "PE", "SR", "UY", "VE");
		
		private static $NORTHAMERICA = array("US");
		
		private static $SOUTHAMERICA = array("AR", "BO", "BR", "CL", "CO", "EC", "FK", "GF", "GY", "PY", "PE", "SR", "UY", "VE");
		
		private static $CENTRALAMERICA = array("BZ", "CR", "SV", "GT", "HN", "NI", "PA", "MX", "HT", "CU");
		
		private static $CARIBBEAN = array("AI", "AG", "AW", "BS", "BB", "VG", "KY", "CU", "DM", "DO", "GD", "GP", "HT", "JM", "MQ", "MS", "AN", "PR", "KN", "LC", "VC", "TT", "TC", "VI");
		
		
		/**
		 * Redirect to URL based on country code
		 *
		 * @param $country - Country that want to apply this rule
		 * @param $url - If country matches then will be redirected to this url
		 *
		 * @return void
		 */
		 
		public static function redirect($country, $url, $except = null)
		{
			self::_lookup();
			
			$matches = self::countryMatches($country, $except);
			
			if( $matches && !self::$redirecting )
			{
				if( !@header("Location: $url") )
				{
					print('<script type="text/javascript"> window.location = "'.$url.'"; </script>');
				}
				
				self::$redirecting = true;
			}
		}
		
		
		/**
		 * Use reserved word `include` to require a file based on country code
		 *
		 * @param $country - Country that want to apply this rule
		 * @param $include_path - If country matches then will be included the selected file
		 *
		 * @return void
		 */
		 
		public static function includeFile($country, $include_path, $except = null)
		{
			self::_lookup();
			
			$matches = self::countryMatches($country, $except);
			
			if( $matches )
			{
				include($include_path);
			}
		}
		
		
		/**
		 * Include Once - It will include just one time file
		 *
		 * @param $country - Country that want to apply this rule
		 * @param $include_path - If country matches then will be included the selected file
		 *
		 * @return void
		 */
		
		public static function includeFileOnce($country, $include_path, $except = null)
		{
			if( !self::$include_done )
			{
				self::_lookup();
				
				$matches = self::countryMatches($country, $except);
				
				if( $matches )
				{
					include($include_path);
					self::$include_done = true;
				}
			}
		}
		
		
		/**
		 * Call's specified function based on country code
		 *
		 * @param $country - Country that want to apply this rule
		 * @param $callback_func - If country matches then the function named $callback_func() will be called (with no parameters)
		 *
		 * @return void
		 */
		 
		public static function callback($country, $callback_func, $except = null)
		{
			self::_lookup();
			
			$matches = self::countryMatches($country, $except);
			
			if( $matches )
			{
				call_user_func($callback_func, self::$current_country);
			}
		}
		
		
		/**
		 * Lookup's for a country (based on IP)
		 *
		 * @return void
		 */
		
		private static function _lookup()
		{
			if( !self::$current_country )
			{
				$remote_addr = $_SERVER['REMOTE_ADDR'];
				$api_url = str_replace("#REMOTE_ADDR#", $remote_addr, self::IP_API_URL);
				
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $api_url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$country_code = curl_exec($ch);
				curl_close($ch);
				
				self::$current_country = strtoupper($country_code);				
			}
		}
		
		
		/**
		 * Check if country matches with the country parameter
		 *
		 * @return boolean - true if it matches, false if not
		 */
		
		private function countryMatches($country, $except)
		{
			$cs = $country;
			
			if( ! is_array($country) )
			{
				switch( strtoupper($country) )
				{
					case "AMERICA":
						$country = self::$AMERICA;
						break;
					
					case "ASIA":
						$country = self::$ASIA;
						break;
						
					case "BALKANS":
					case "BALKAN":
						$country = self::$BALKANS;
						break;
					
					case "CARIBBEAN":
						$country = self::$CARIBBEAN;
						break;
					
					case "CENTRALAMERICA":
						$country = self::$CENTRALAMERICA;
						break;
					
					case "EUROPE":
						$country = self::$EUROPE;
						break;
					
					case "MIDDLEEAST":
					case "MIDDLE EAST":
						$country = self::$MIDDLEEAST;
						break;
					
					case "NORTHAMERICA":
					case "UNITED STATES":
						$country = self::$NORTHAMERICA;
						break;
					
					case "SOUTHAMERICA":
					case "LATIN AMERICA":
						$country = self::$SOUTHAMERICA;
						break;
					
					default:
						$country = array($country);
				}
			}
			
			if( is_array($except) )
			{
				foreach($except as $except_country)
				{
					if( $except_country == self::$current_country )
						return false;
				}
			}
			
			if( $cs == "*" || strtoupper($cs) == "INTERNATIONAL" )
			{
				return true;
			}
			
			if( in_array(self::$current_country, $country) && !in_array($except, $country) )
			{
				return true;
			}
			
			return false;
		}
		
		
		/**
		 * Get Current Country Code
		 *
		 * @return void
		 */
		 
		public static function getCountryCode()
		{
			if( !self::$current_country )
			{
				self::_lookup();
			}
			
			return self::$current_country;
		}
	}	
?>