<?php

	/**
	 * Flipper Poll Administrator
	 */
	
	session_start();
	
	require("configuration.php");
		
	$current_page = "dashboard";
	
	if( $_GET['action'] == "poll_settings" )
		$current_page = "poll_settings";
	
	if( ($delete_option = $_GET['delete_option']) && $_COOKIE['token'] == $admin_password )
	{
		if( is_numeric($delete_option) && $delete_option > 0 )
		{
			$flipper_poll->deleteOptionId($delete_option);
		}
	}
	else
	if( isset($_POST['change_password']) && $_COOKIE['token'] == $admin_password )
	{
		if( $_POST['new_password'] )
		{
			$flipper_poll->changePassword($_POST['new_password']);
			define("FP_PASSWORD_CHANGED", 1);
		}
	}
	else
	if( isset($_POST['save']) && $_COOKIE['token'] == $admin_password )
	{
		$_site_title = $_POST['site_title'];
		$_poll_title = $_POST['poll_title'];
		
		$_thankyou_msg = $_POST['success_msg'];
		$_alreadyv_msg = $_POST['warning_msg'];
		
		$_optionids = $_POST['optionids'];
		$_options = $_POST['options'];
		
		$_progressbar_fill = $_POST['progressbar_fill'];
		$_vote_timeout = $_POST['vote_timeout'];
		$_default_theme = $_POST['default_theme'];
		
		$_db_host = $_POST['db_host'];
		$_db_user = $_POST['db_user'];
		$_db_pass = $_POST['db_pass'];
		$_db_name = $_POST['db_name'];
		$_table_prefix = $_POST['table_prefix'];
		
		$flipper_poll->editConfigurationFile($_site_title, $_poll_title, $_thankyou_msg, $_alreadyv_msg, $_optionids, $_options, $_progressbar_fill, $_vote_timeout, $_default_theme, $_db_host, $_db_user, $_db_pass, $_db_name, $_table_prefix);
		define("CHANGES_SAVED", 1);
	}
	else
	if( isset($_POST['login']) )
	{
		$typed_password = sha1(md5(base64_encode($_POST['password'])));
		
		if( $admin_password == $typed_password )
		{
			setcookie("token", $typed_password);
			header("Location: admin.php");
		}
		else
			define("FP_INVALID_PASSWD", 1);
	}
	else
	if( isset($_GET['logout']) )
	{
		setcookie("token", "-");
		header("Location: admin.php");
	}
	
	if( $_COOKIE['token'] != $admin_password )
		$current_page = "login";
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Administration - <?php echo $site_title; ?></title>
<link href="css/main.css" rel="stylesheet" type="text/css" />
<link rel="canonical" href="http://www.20script.ir" />
<link href="css/ui-lightness/jquery-ui-1.8.7.custom.css" rel="stylesheet" type="text/css" media="screen" />
<script type="text/javascript" src="js/jquery-1.4.4.min.js"></script>
<script type="text/javascript" src="js/jquery-ui-1.8.7.custom.min.js"></script>
<style type="text/css">
	.admin_content {
		padding-top:5px;
		padding-left:25px;
	}
	
	a img {
		border:none;
	}
	
	.menu {
		list-style:none;
		padding:0px;
		margin:0px;
		float:left;
		width:200px;
	}
	
	.menu li {
		background:#FFF;
		line-height:30px;
		padding:0px 10px;
		border-radius:5px;
		-webkit-border-radius:5px;
		-moz-border-radius:5px;
		margin-bottom:5px;
	}
	
	.menu li a {
		color:#333;
		text-decoration:none;
		display:block;
	}
	
	.menu li:hover {
		background:#F0F0F0;
	}
	
	.menu li a:hover {
		color:#000;
	}
	
	.content {
		width:700px;
		background:url(imgs/separator.png) repeat-x top;
		padding:0px 5px;
		padding-top:18px;
		margin-left:230px;
	}
	
	.content h1, .heading {
		margin:0px;
		text-align:left;
		font-family:"Trebuchet MS", Arial, Helvetica, sans-serif;
		font-size:18px;
		color:#2e9dff;
	}
	
	.fp_progress_bar {
		background:#1b1d26;
		box-shadow:none;
		-webkit-box-shadow:1px 1px 2px rgba(255,255,255,.15);
		-moz-box-shadow:none;
	}
	
	.pct {
		padding-left:10px;
		color:#CCC;
	}
	
	.p01 {
		font-weight:bold;
		font-size:13px;
	}
	
	
	.p01 .img {
		width:20px;
		height:15px;
		position:relative;
		top:-2px;
	}
	
	.res_table tr th {
		background:url(imgs/trans_bg.png);
	}
	
	.tl_radius {
		border-radius:5px 0px 0px 0px;
		-webkit-border-radius:5px 0px 0px 0px;
		-moz-border-radius:5px 0px 0px 0px;
	}
	
	.tr_radius {
		border-radius:0px 5px 0px 0px;
		-webkit-border-radius:0px 5px 0px 0px;
		-moz-border-radius:0px 5px 0px 0px;
	}
	
	.res_table tr td, .res_table tr th {
		padding:5px;
	}
	
	.res_table tr th {
		border-bottom:1px solid #515673;
	}
	
	
	.res_table tr td {
		border-bottom:1px solid #515673;
	}
	
	.tr_radius1 {		
		border-radius:0px 5px 0px 0px;
		-webkit-border-radius:0px 5px 0px 0px;
		-moz-border-radius:0px 5px 0px 0px;
	}
	
	.form_table {
		margin-top:0px;
	}
	
	.form_table input[type="text"], .form_table input[type="password"], .form_table select {
		padding:5px;
		font-family:"Trebuchet MS", Arial, Helvetica, sans-serif;
		font-weight:bold;
		font-size:11px;
		width:350px;
		border:none;
		border-radius:4px;
		-webkit-border-radius:4px;
		-moz-border-radius:4px;
		outline:none;
	}
	
	.form_table select#default_theme {
		width:187px;
	}
	
	.form_table .label {
		font-size:15px;
		font-family:Tahoma, Geneva, sans-serif;
		text-transform:uppercase;
	}
	
	#save, #login {
		font-size:18px;
		padding:5px 10px;
		margin-top:10px;
	}
	
	.add_new_option {
		background:url(imgs/add.png) no-repeat left center;
		padding-left:16px;
	}
	
	.remove {
		background:url(imgs/remove.png) no-repeat;
		width:12px;
		height:12px;
		display:inline-block;
	}
	
	#password {
		padding:8px 10px;
		text-align:center;
		position:relative;
		top:-1px;
	}
	
	.change_passwd_dialog {
		display:none;
	}
	
	* {
		outline:none;
	}
	
	.warning {
		font-size:13px;
		font-weight:bold;
		font-family:"Courier New", Courier, monospace;
		padding:10px;
		background:url(imgs/trans_bg.png);
		margin-top:10px;
		border-radius:5px;
		-moz-border-radius:5px;
		-webkit-border-radius:5px;
	}
	
	.menu li.active {
		background:#1f6bad;
	}
	
	.menu li.active a {
		color:#FFF;
	}
	
	.theme_thumbnail {
		border:1px solid #FFF;
		padding:5px;
		background:url(imgs/trans_bg.png);
	}
</style>
<!--[if IE 6]>
<link href="css/ie6.css" rel="stylesheet" type="text/css" />
<script src="js/DD_belatedPNG_0.0.8a.js"></script>
<script>
    	DD_belatedPNG.fix('.png');
</script>
<![endif]-->
<!--[if IE 7]>
<style>
	.fp_button span {
		left:-9px;
        top:1px;
	}
</style>
<![endif]-->
<script type="text/javascript">

	$(document).ready(function()
	{
		$("#default_theme").change(function()
		{
			var theme_thumbnail = $(".theme_thumbnail");
			theme_thumbnail.attr("src", "imgs/th_style"+$(this).val()+".png");
		});
		$(".change_passwd").click(function()
		{
			var change_passwd_dialog = $(".change_passwd_dialog");
			
			change_passwd_dialog.dialog({
				width:500,
				height:170,
				modal:true,
				resizable:false,
				title: "Change Password"
			});
			return false;
		});
		
		$(".remove").click(function()
		{
			if( !confirm("Are you sure you want to remove this option?") )
				return false;
		});
		
		$(".add_new_option").click(function()
		{
			var tr_parent = $(this).parent().parent();
			var OPTION_ID = getNewOptionID();
			var field = '<input type="hidden" name="optionids[]" value="'+OPTION_ID+'" />';
			
			field += '<input type="text" name="options[]" class="option" id="option_'+OPTION_ID+'" value="" />';
			
			tr_parent.before("<tr><td width='220' class='label'>OPTION "+OPTION_ID+"</td><td>"+field+"</td></tr>");
			$('#option_'+OPTION_ID).focus();
			return false;
		});
		
		$("#fp_options_form").submit(function()
		{
			var return_val = true;
			
			$(".option").each(function()
			{
				if( $(this).val().length == 0 )
				{
					return_val = false;
					$(this).focus();
					return false;
				}
			});
			
			if( !$("#vote_timeout").val().match(/^[0-9\s\*]+$/) )
			{
				alert("Please enter valid number (also arithmetic operation * is allowed)");
				$("#vote_timeout").focus();
				return false;
			}
			
			return return_val;
		});
	});
	
	function getNewOptionID()
	{
		var i = 1;
		while( true )
		{
			if( $("#option_"+i).length == 0 )
			{
				return i;
			}
			
			i++;
		}
		return 1;
	}
</script>
</head>

<body>
<div class="admin_content">
	<a href="<?php echo $current_page == "login" ? "index.php" : $_SERVER['PHP_SELF']; ?>">
		<img src="imgs/flipper_poll.png" width="270" height="105" alt="" class="png" />
    </a>
    
    <div class="clear"></div>
    
    <?php if( $current_page != "login" ){ ?>
    <ul class="menu">
    	<li<?php echo $current_page == "dashboard" ? ' class="active"' : ''; ?>>
        	<a href="<?php echo $_SERVER['PHP_SELF']; ?>">Dashboard</a>
        </li>
    	<li<?php echo $current_page == "poll_settings" ? ' class="active"' : ''; ?>>
        	<a href="?action=poll_settings">Poll Settings</a>
        </li>
    	<li>
        	<a href="#" class="change_passwd">Change Password</a>
        </li>
    	<li>
        	<a href="index.php" target="_blank">Preview</a>
        </li>
    	<li>
        	<a href="admin.php?logout">Logout</a>
        </li>
    </ul>
    <?php } ?>
    
    <div class="content png">
    <?php
		
		if( file_exists("install.php") && $current_page != "login" )
		{
			?>
            <div class="warning png">
            	Installation file must be deleted after successfull installation.<br />
                Click <a href="delinsfile.php"><strong>here</strong></a> to take that action &raquo;
            </div>
            <?php
		}
		
		if( defined("FP_PASSWORD_CHANGED") )
		{
			?>
            <div class="success_msg png">
            	<h1>Password Changed</h1>
                Now you can login with your new password.
            </div>
            <?php
		}
		
		switch( $current_page )
		{
			case "dashboard":
			?>
            	<h1><?php echo $poll_title; ?></h1>
                <?php
					if( count($flipper_poll->getPollOptions()) == 0 )
					{
						?><span>There is no option added to the poll!</span><?php
					}
				?>
                <table border="0" cellspacing="2" cellpadding="2">
                <?php
				
					$total_votes = $flipper_poll->votesTotal();
					$votes_max_v = $flipper_poll->votesMaxValue();
					
					foreach($flipper_poll->getPollOptions() as $option)
					{
						$option_id = $option->getId();
						$option_name = $option->getName();
						$option_votes = $option->votes();
						
						$percentage = 0;
						
						if( $total_votes > 0 )
						{
							$percentage = 100 * ($option_votes / $total_votes);
							
							if( $optimum_filling && $percentage != 100 )
							{
								$percentage_second = 100 * ( $option_votes / $votes_max_v);
							}
						}
						
						$percentage = number_format($percentage, 1);
				?>
                  <tr>
                    <td><?php echo $option_name; ?></td>
                    <td>
                    	<div class="fp_progress_bar">
                        	<div class="fill" style="width:<?php echo intval($percentage_second ? $percentage_second : $percentage); ?>%">
                          </div>
                      </div>
                    </td>
                    <td align="right"><strong><?php echo $option_votes; ?> / <?php echo $total_votes; ?></strong></td>
                    <td align="right" class="pct"><?php echo $percentage; ?> %</td>
                  </tr>
              <?php
					}
			  ?>
                </table>
                
                <br />
      <h1>Votes by countries</h1>
                <?php
				
					$country_votes = mysql_query("SELECT CountryCode, COUNT(*) Votes FROM `".FP_PREFIX."pollvotes` WHERE CountryCode <> '' GROUP BY CountryCode ORDER BY Votes DESC");
					
					if( !mysql_num_rows($country_votes) )
					{
						?><span>There is no vote registered</span><?php
					}
					else
					{
						?><table width="60%" border="0" cellpadding="0" cellspacing="0" class="res_table">
							<tr>
                           	  <th align="center" class="tl_radius">Flag</th>
                           	  <th align="left">Country Code</th>
                           	  <th align="right">Votes</th>
                           	  <th align="right" class="tr_radius"><span class="tr_radius1">Percentage</span></th>
                            </tr>
						<?php
						
						while($r = mysql_fetch_array($country_votes))
						{
							$percentage = 0;
							
							if( $total_votes != 0 )
							{
								$percentage = 100 * $r['Votes'] / $total_votes;
							}
							
							$percentage = number_format($percentage, 2);
							?>
                                  <tr>
                                    <td align="center" class="p01">
                                    <div class="img" style="background-image:url(http://1.envato-static.com/images/badges/country/<?php echo strtolower($r['CountryCode']); ?>.png?<?php echo time(); ?>);">
                                    </div>
                                    </td>
                                    <td class="p01"><?php echo $r['CountryCode']; ?></td>
                                    <td align="right" class="p01"><?php echo $r['Votes']; ?></td>
                                    <td align="right" class="p01"><?php echo $percentage; ?> %</td>
                  </tr>
                            <?php
						}
						
						?></table><?php
					}
				?>
            <?php
				break;
			
			case "poll_settings":
			
			if( !is_writable("configuration.php") )
			{
				?>
                <div class="warning_msg png">
                	<h1 style="color:#f4cf00;">Warning</h1>
                    Configuration file is not writable. Please chmod 777 file name <em>configuration.php</em>
                </div>
                <br />
                <?php
			}
			else
			if( defined("CHANGES_SAVED") )
			{
				?>
                <div class="success_msg png">
                	<h1>Changes has been saved</h1>
                    Configuration file is modified successfully.
                </div>
                <?php
			}
			else
			{
			?>
      <form action="admin.php?action=poll_settings" method="post" enctype="application/x-www-form-urlencoded" name="form1" id="fp_options_form">
			<h1>Titles and messages</h1>
                <table border="0" class="form_table" cellspacing="2" cellpadding="2">
                  <tr>
                    <td width="220" class="label"><label for="site_title">Site title</label></td>
                    <td>
                    <input type="text" name="site_title" id="site_title" value="<?php echo addslashes($site_title); ?>" /></td>
                  </tr>
                  <tr>
                    <td width="120" class="label"><label for="poll_title">Poll title</label></td>
                    <td>
                    <input type="text" name="poll_title" id="poll_title" value="<?php echo addslashes($poll_title); ?>" /></td>
                  </tr>
                  <tr>
                    <td class="label">&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td class="label">Thank you message</td>
                    <td><input type="text" name="success_msg" id="success_msg" value="<?php echo addslashes($thank_you_msg); ?>" /></td>
                  </tr>
                  <tr>
                    <td class="label">Already voted message</td>
                    <td><input type="text" name="warning_msg" id="warning_msg" value="<?php echo addslashes($already_voted_msg); ?>" /></td>
                  </tr>
                </table>
                <br />
        <h1>Poll Options</h1>
                <table border="0" class="form_table" cellspacing="2" cellpadding="2">
				<?php
				
					$total_votes = $flipper_poll->votesTotal();
					$votes_max_v = $flipper_poll->votesMaxValue();
					
					foreach($flipper_poll->getPollOptions() as $i => $option)
					{
						$option_id = $option->getId();
						$option_name = $option->getName();
						$option_votes = $option->votes();
						
						$percentage = 0;
						
						if( $total_votes > 0 )
						{
							$percentage = 100 * ($option_votes / $total_votes);
							
							if( $optimum_filling && $percentage != 100 )
							{
								$percentage_second = 100 * ( $option_votes / $votes_max_v);
							}
						}
						
						$percentage = number_format($percentage, 1);
						
						if( $delete_option != $option_id )
						{
						?>
                      <tr>
                        <td width="220" class="label">
                        <a href="admin.php?action=poll_settings&delete_option=<?php echo $option_id; ?>" class="remove"></a>
                        <label for="option_<?php echo $i+1; ?>">Option <?php echo $i+1; ?></label>
                        </td>
                        <td>
                        <input type="hidden" name="optionids[]" value="<?php echo $option_id; ?>" />
                        <input type="text" name="options[]" class="option" id="option_<?php echo $i+1; ?>" value="<?php echo $option_name; ?>" />
                        </td>
                      </tr>
                        <?php
						}
					}
			?>
                      <tr>
                        <td width="220" class="label">&nbsp;</td>
                        <td><a href="#" class="add_new_option">Add New Option</a></td>
                      </tr>
            </table>
            
        <br />
        <h1>Settings &amp; Theme</h1>
        <table border="0" class="form_table" cellspacing="2" cellpadding="2">
          <tr>
            <td width="220" class="label">Progresbar Fill (<a href="#" title="Optimum: Even if poll option has not reached 100%, the maximum value will reach the 100% of progress bar, and so on with the others" onclick="return false">?</a>)</td>
            <td>
              <select name="progressbar_fill" id="progressbar_fill">
                <option value="1">Optimum</option>
                <option value="0" <?php echo $optimum_filling == 0 ? ' selected' : ''; ?>>Real percentage fill</option>
            </select></td>
          </tr>
          <tr>
            <td class="label"><label for="vote_timeout">Next vote timeout (<a href="#" title="Period in seconds that user can re-vote again after the previous time" onclick="return false">?</a>)</label></td>
            <td>
            <input type="text" name="vote_timeout" id="vote_timeout" value="<?php echo FP_VOTING_PERIOD; ?>" /></td>
          </tr>
          <tr>
            <td valign="top" class="label">Default Theme</td>
            <td><table border="0" cellspacing="2" cellpadding="2">
              <tr>
                <td><img src="imgs/th_style<?php echo $default_theme; ?>.png" class="theme_thumbnail" width="150" height="96" alt="" /></td>
                <td valign="top">
                  <select name="default_theme" id="default_theme">
                  <?php
				  	for($i=1; $i<=5; $i++)
					{
						?>
                        <option value="<?php echo $i; ?>"<?php echo $i == $default_theme ? ' selected': ''; ?>>Theme <?php echo $i; ?></option>
                        <?php
					}
				  ?>
                  </select></td>
              </tr>
            </table></td>
          </tr>
        </table>
            
        <br />
        <h1>Flipper Poll Database</h1>
        <table border="0" class="form_table" cellspacing="2" cellpadding="2">
          <tr>
            <td colspan="2">
            	<div style="width:600px; line-height:1.7; color:#FFFF00">Do not change these settings unless you are sure that another database has recently installed <em>Flipper Poll tables </em>to the given <em>table prefix</em>, otherwise it will result in permanent error, and to fix it you need to re-install Flipper Poll again!</div>
                </td>
          </tr>
          <tr>
            <td width="220" class="label"><label for="db_host">db host [:port]</label></td>
            <td>
            <input type="text" name="db_host" id="db_host" value="<?php echo $db_host; ?>" /></td>
          </tr>
          <tr>
            <td class="label"><label for="db_user">db user</label></td>
            <td><input type="text" name="db_user" id="db_user" value="<?php echo $db_user; ?>" /></td>
          </tr>
          <tr>
            <td class="label"><label for="db_pass">db pass</label></td>
            <td><input type="password" name="db_pass" id="db_pass" value="<?php echo $db_pass; ?>" /></td>
          </tr>
          <tr>
            <td class="label"><label for="db_name">db name</label></td>
            <td><input type="text" name="db_name" id="db_name" value="<?php echo $db_name; ?>" /></td>
          </tr>
          <tr>
            <td class="label"><label for="table_prefix">table prefix</label></td>
            <td><input type="text" name="table_prefix" id="table_prefix" value="<?php echo FP_PREFIX; ?>" /></td>
          </tr>
              <tr>
                <td class="label">&nbsp;</td>
                <td><input type="submit" name="save" id="save" value="Save Changes" /></td>
              </tr>
        </table>
      </form>
            <?php
					}
				break;
			
			default:
			?>
            <br />
            
            <form action="admin.php" method="post" enctype="application/x-www-form-urlencoded" name="form2" id="fp_login_form">
            <?php if( defined("FP_INVALID_PASSWD") ){ ?>
            <div class="warning_msg png" style="margin-bottom:10px; margin-top:0px;">
            	<h1 style="color:#f4cf00;">Invalid Login</h1>
                The password you've entered is invalid.
            </div>
            <?php } ?>
            <table align="center" class="form_table" border="0" cellspacing="2" cellpadding="2">
              <tr>
                <td class="label" align="center">
                    ADMIN PASSWORD
                    <br />
                    <input name="password" id="password" type="password" autofocus />
                    <input name="login" id="login" type="submit" value="Login" />
                </td>
              </tr>
            </table>

            </form>
            <?php
		}
	?>
    <div class="clear"></div>
    <br />
    <div class="copyrights">Copyrights © <?php echo date("Y"); ?>.  Author &lt;<a href="mailto:arlindd@gmail.com">Arlind Nushi</a>&gt; <?php echo $current_page == "dashboard" ? '- Country flags are supported by Envato Static Images' : ''; ?></div>
    </div>
    
    <div class="clear"></div>
    
    <div class="change_passwd_dialog" align="center">
        <form action="admin.php" method="post" class="form_table" enctype="application/x-www-form-urlencoded" style="padding:15px 0px;">
        	<span class="label">NEW ADMIN PASSWORD</span>
            <div style="padding:5px 0px;">
            <input name="new_password" style="text-align:center" type="password" />
            </div>
            <input name="change_password" type="submit" style="font-weight:bold;" value="Change Password" />
            
        </form>
    </div>
    
</div>
</body>
</html>