<?php
function smarty_function_image( $params, &$smarty )
{
$path = "/timthumb.php?src=";
if(isset($params['backdrop_path'])){ $path = '/timthumb.php?src=http://image.tmdb.org/t/p/w780/'.$params['backdrop_path'];}
if(isset($params['poster_path'])){ $path = '/timthumb.php?src=http://image.tmdb.org/t/p/w154/'.$params['poster_path'];}
if(isset($params['profile_path'])){ $path = '/timthumb.php?src=http://image.tmdb.org/t/p/w185/'.$params['profile_path'];}
if(isset($params['user_profile_path'])){ return $path = $params['user_profile_path'].'&?width='.$params['w'].'&height='.$params['h'].'&w='.$params['w'].'&h='.$params['h'].'';;}
if(isset($params['still_path'])){ $path = '/timthumb.php?src=http://image.tmdb.org/t/p/w154/'.$params['still_path'];}
if(isset($params['original_path'])){ $path = '/timthumb.php?src=http://image.tmdb.org/t/p/original/'.$params['original_path'];}
if(isset($params['src'])){ $path = '/timthumb.php?src='.$params['src'];}
if(isset($params['w'])){ $path .= '&w='.$params['w'];}
if(isset($params['h'])){ $path .= '&h='.$params['h'];}
return $path;
}

function redirect($message){
switch($message){
case 1: echo '<script type="text/javascript">window.location.href = "/";</script>'; break;
case 2: echo '<script type="text/javascript">window.location.href = "/error/404";</script>'; break;
case 3: echo '<script type="text/javascript">window.location.href = "/error/304";</script>'; break;
}
}

function notice($message, $type){
switch($type){
case 'error': echo '<div class="alert alert-danger fade in"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.$message.'</div>'; break;
case 'warning': echo '<div class="alert alert-warning fade in"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.$message.'</div>'; break;
case 'success': echo '<div class="alert alert-success fade in"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>'.$message.'</div>'; break;
}
}

function DB( $table, $limit, $order )
{
    global $db;
    return $posts = $db->query('SELECT * FROM  '.$table.' ORDER BY  `'.$order.'` DESC LIMIT 0 ,'.$limit);
}


function JSON( $query, $append, $return = "" )
{
global $LANG;
global $CONF;
$url = 'https://api.themoviedb.org/3/'.$query.'?api_key='.$CONF['TMDBAPIkey'].$append.'&language='.$LANG['CODE'];
$ch=curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$r=curl_exec($ch);
curl_close($ch);
$json = json_decode($r, true); 
if($return == ''){return $json;}else{return $json[$return];}
}


function GET($type, $id='0', $param1='', $param2='', $param3='', $param4='', $param5=''){
////////////////////////////////////////////////
    /////////////// MOVIE ///////////////
////////////////////////////////////////////////
    

if($type == 'movie'){            //Type Get Movie
return JSON('movie/'.$id, '&append_to_response=videos,images,similar_movies,reviews,credits');
}
    
if($type == 'movie_popular'){    //Type Get Popular Movies
return JSON('movie/popular', '', 'results');
}

if($type == 'movie_top_rated'){  //Type Get Top Rated Movies
return JSON('movie/top_rated', '', 'results');
}

if($type == 'movie_upcoming'){   //Type Get Upcoming Movies
return JSON('movie/upcoming', '', 'results');
}

if($type == 'movie_now_playing'){ //Type Get Now Playing Movies
return JSON('movie/now_playing', '', 'results');
}
  

if($type == 'movie_credits'){     //Type Get Movie Credits
return JSON('movie/'.$id, '&append_to_response=credits');
}     
    
if($type == 'movie_images'){      //Type Get Movie Images
return JSON('movie/'.$id, '&append_to_response=images');
} 

////////////////////////////////////////////////
    /////////////// PEOPLE ///////////////
////////////////////////////////////////////////
    
if($type == 'person'){           //Type Get Person
return JSON('person/'.$id, '&append_to_response=combined_credits,tagged_images,images');
}
   
if($type == 'person_credits'){   //Type Get Persons Combined Credits
return JSON('person/'.$id, '&append_to_response=combined_credits');
}
    
if($type == 'people_popular'){   //Type Get Popular People
if($id){$sa = '&page='.$id;}else{$sa = "";}
return JSON('person/popular', $sa, 'results');
}


////////////////////////////////////////////////
    /////////////// TV ///////////////
////////////////////////////////////////////////
    
if($type == 'tv'){                //Type Get TV
return JSON('tv/'.$id, '&append_to_response=credits,images,videos,similar');
}
   
if($type == 'tv_season'){       //Type Get TV Season
return JSON('tv/'.$id.'/season/'.$param1, "");
}
   
if($type == 'tv_on_the_air'){   //Type Get TV Shows On Air Now
return JSON('tv/on_the_air', '', 'results');
}
 
if($type == 'tv_airing_today'){ //Type Get TV Airing Today
return JSON('tv/airing_today', '', 'results');
}
 
if($type == 'tv_top_rated'){    //Type Get TV Top Rated
return JSON('tv/top_rated', '', 'results');
}

if($type == 'tv_popular'){      //Type Get TV Popular
return JSON('tv/popular', '', 'results');
}
 
////////////////////////////////////////////////
    /////////////// SEARCH ///////////////
////////////////////////////////////////////////
    
if($type == 'search_movie'){       //Search Movie
return JSON('search/movie', '&query='.$id, 'results');
}
        
if($type == 'search_person'){      //Search Person
return JSON('search/person', '&query='.$id, 'results');
}
 
if($type == 'search_tv'){          //Search TV
return JSON('search/tv', '&query='.$id, 'results');
}
    
if($type == 'discover_movies'){    //Discover Movies
return JSON('discover/movie', '&page='.$id.'&sort_by='.$param1.'&include_adult='.$param2.'&release_date.gte='.$param3.'&release_date.lte='.$param4.'&with_genres='.$param5, 'results');
}

if($type == 'discover_tv'){       //Discover Tv Showes
return JSON('discover/tv', '&page='.$id.'&sort_by='.$param1.'&include_adult='.$param2.'&first_air_date.gte='.$param3.'&first_air_date.lte='.$param4.'&with_genres='.$param5, 'results');
}
    
if($type == 'genres'){            //Genres
return JSON('genre/list', '', 'genres');
}
    
}
