<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTaxRateTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tax_rate_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('tax_rate_id')->unsigned();
            $table->string('locale');
            $table->string('name');

            $table->unique(['tax_rate_id', 'locale']);
            $table->foreign('tax_rate_id')->references('id')->on('tax_rates')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tax_rate_translations');
    }
}
