$.fn.wizard.logging = true;
var wizard = $('#feral-wizard').wizard({
	contentHeight : 550,
	contentWidth : 800,
	backdrop: 'static',
	buttons: {
        submitText: "Finish",
        submittingText: "Finishing...",
    },
});

wizard.on('closed', function() {
	wizard.reset();
});

wizard.on("reset", function() {
	wizard.modal.find(':input').val('').removeAttr('disabled');
	wizard.modal.find('.form-group').removeClass('has-error').removeClass('has-succes');
	wizard.modal.find('#fqdn').data('is-valid', 0).data('lookup', 0);
});


wizard.on("submit", function(wizard) {		
	location.href='/install/finish';
});

$('#open-wizard').click(function(e) {
	e.preventDefault();
	wizard.show();
});

$('#ConfigurationMailserverTransport').change(function() {
    if($(this).val() == 'SMTP') {
        $('#mailSmtp').show();
    }else{
        $('#mailSmtp').hide();
    }
});

function validateStep2() {    
    var $validator = $("#wizard-step2").validate({
        rules: {
            'data[Database][database_host]': {
                required: true
            },
            'data[Database][database_user]': {
                required: true
            },
            'data[Database][database_password]': {
                required: true
            },
            'data[Database][database_name]': {
                required: true
            }
        }
    });

    var $valid = $("#wizard-step2").valid();
	if(!$valid) {
		$validator.focusInvalid();
        return false;
	}else{
	    var succeed = false;
	    
        $.ajax({
            async: false,
            type: 'post',
    		url: '/install/create_datasource/',
    		data: $('#wizard-step2').serialize(),
    		cache: false,
            dataType: 'json',
    		success: function(data) {
    		    if(data.status == "OK") {
    		        wizard.getActiveCard().toggleAlert(data.msg, false);               
    		        succeed = true;
    		    }else{
    		        wizard.getActiveCard().toggleAlert(data.msg, true);
        		    succeed = false;
    		    }
    		}
    	});
    	if(succeed) {
        	$.ajax({
                async: false,
                type: 'post',
        		url: '/install/fill_datasource/',
        		data: $('#wizard-step2').serialize(),
        		cache: false,
                dataType: 'json',
        		success: function(data) {
        		    if(data.status == "OK") {
        		        wizard.getActiveCard().toggleAlert(data.msg, false);               
        		        succeed = true;
        		    }else{
        		        wizard.getActiveCard().toggleAlert(data.msg, true);
            		    succeed = false;
        		    }
        		}
        	});
    	}
    }
    return succeed;
}

function validateStep3() {    
    var $validator = $("#wizard-step3").validate({
        rules: {
            'data[Configuration][site_url]': {
                required: true,
                url: true
            },
            'data[Configuration][site_name]': {
                required: true
            },
            'data[Configuration][site_short_name]': {
                required: true
            },
            'data[Configuration][site_title]': {
                required: true
            }
        }
    });

    var $valid = $("#wizard-step3").valid();
	if(!$valid) {
		$validator.focusInvalid();
        return false;
	}else{
	    var succeed = false;
	    
        $.ajax({
            async: false,
            type: 'post',
            url: '/configurations/edit/',
    		data: $('#wizard-step3').serialize(),
    		cache: false,
            dataType: 'json',
    		success: function(data) {
    		    if(data.status == "OK") {
    		        succeed = true;
    		    }else{
        		    succeed = false;
    		    }
    		}
    	});
    }
    return succeed;
}

function validateStep4() {    
    var succeed = false;
	    
    $.ajax({
        async: false,
        type: 'post',
        url: '/configurations/edit/',
		data: $('#wizard-step4').serialize(),
		cache: false,
        dataType: 'json',
		success: function(data) {
		    if(data.status == "OK") {
		        succeed = true;
		    }else{
    		    succeed = false;
		    }
		}
	});
    return succeed;
}

function validateStep5() {    
    var $validator = $("#wizard-step5").validate({
        rules: {
            'data[Configuration][email_to_email]': {
                required: true,
                email: true
            },
            'data[Configuration][email_from_name]': {
                required: true
            },
            'data[Configuration][email_from_email]': {
                required: true,
                email: true
            }
        }
    });

    var $valid = $("#wizard-step5").valid();
	if(!$valid) {
		$validator.focusInvalid();
        return false;
	}else{
	    var succeed = false;
	    
        $.ajax({
            async: false,
            type: 'post',
            url: '/configurations/edit/',
    		data: $('#wizard-step5').serialize(),
    		cache: false,
            dataType: 'json',
    		success: function(data) {
    		    if(data.status == "OK") {
    		        succeed = true;
    		    }else{
        		    succeed = false;
    		    }
    		}
    	});
    }
    return succeed;
}

function validateStep6() {    
    var $validator = $("#wizard-step6").validate({
        rules: {
            'data[User][email]': {
				required: true,
				email: true
			},
			'data[User][password]': {
				required: true,
				minlength: 6
			},
			'data[Profile][first_name]': {
				required: true
			},
			'data[Profile][last_name]': {
				required: true
			}
        }
    });

    var $valid = $("#wizard-step6").valid();
	if(!$valid) {
		$validator.focusInvalid();
        return false;
	}else{
	    var succeed = false;
	    
	    $.ajax({
            async: false,
            type: 'post',
            url: '/configurations/edit/',
    		data: $('#wizard-step6').serialize(),
    		cache: false,
            dataType: 'json',
    		success: function(data) {
    		    if(data.status == "OK") {
    		        succeed = true;
    		    }else{
        		    succeed = false;
    		    }
    		}
    	});
    	if(succeed) {
            $.ajax({
                async: false,
                type: 'post',
                url: '/users/add/json',
        		data: $('#wizard-step6').serialize(),
        		cache: false,
                dataType: 'json',
        		success: function(data) {
        		    if(data.status == "OK") {
        		        wizard.getActiveCard().toggleAlert(data.msg, false);               
        		        succeed = true;
        		    }else{
        		        wizard.getActiveCard().toggleAlert(data.msg, true);
            		    succeed = false;
        		    }
        		}
        	});
    	}
    }
    return succeed;
}