$('#adminSettingsSubmit').click(function() {
    submitAdminSettings();
});
$('#adminSettingsCancel').click(function() {
    $('#adminSettingsModal').modal('hide');
});
$('#adminSettingsModal').on('hidden.bs.modal', function () {
    reload();
});


$('#adminSettingsSubmit').click(function() {
    submitAdminSettings();
});
$('#adminSettingsCancel').click(function() {
    reload();
});
$('#adminSettingsCancel').bind('keypress', function(event){
    if(event.keyCode == 13) {
        event.preventDefault();
        $('#adminSettingsCancel').modal('hide');
        submitSettings();
    }
});

$('#ConfigurationMailserverTransport').change(function() {
    if($(this).val() == 'SMTP') {
        $('#mailSmtp').show();
    }else{
        $('#mailSmtp').hide();
    }
});

function submitAdminSettings() {
    var $validator = $("#adminSettingsForm").validate({
        rules: {
            'data[Configuration][site_url]': {
                required: true,
                url: true
            },
            'data[Configuration][site_name]': {
                required: true
            },
            'data[Configuration][site_short_name]': {
                required: true
            },
            'data[Configuration][site_title]': {
                required: true
            },
            'data[Configuration][email_to_email]': {
                required: true,
                email: true
            },
            'data[Configuration][email_from_name]': {
                required: true
            },
            'data[Configuration][email_from_email]': {
                required: true,
                email: true
            }
        }
    });

    var $valid = $("#adminSettingsForm").valid();
	if(!$valid) {
		$validator.focusInvalid();
        return false;
	}else{
	    var succeed = false;
	    
	    $.ajax({
        	async: false,
            type: 'post',
            url: '/configurations/edit/',
            data: $('#adminSettingsForm').serialize(),
            cache: false,
            dataType: 'json',
            success: function (data) {
                if (data.status == 'OK') {
                    reload();
                }
            }
        });
    }
    return succeed;
}